/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.api.util.Color;
import com.xcompwiz.mystcraft.client.render.CloudRendererMyst;
import com.xcompwiz.mystcraft.client.render.WeatherRendererMyst;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.network.NetworkUtils;
import com.xcompwiz.mystcraft.world.AgeController;
import com.xcompwiz.mystcraft.world.BiomeWrapperManager;
import com.xcompwiz.mystcraft.world.ChunkProviderMyst;
import com.xcompwiz.mystcraft.world.SkyRendererMyst;
import com.xcompwiz.mystcraft.world.agedata.AgeData;
import com.xcompwiz.mystcraft.world.storage.WorldInfoMyst;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.IRenderHandler;

public class WorldProviderMyst
extends WorldProvider {
    public int ageUID;
    public AgeData agedata;
    private AgeController controller;
    private BiomeWrapperManager biomeManager;
    private SkyRendererMyst skyrenderer;
    private CloudRendererMyst cloudrenderer;
    private WeatherRendererMyst weatherrenderer;
    private int emptyTicks;

    public void setDimension(int dim) {
        this.ageUID = dim;
        this.field_76574_g = dim;
        super.setDimension(dim);
    }

    protected void func_76572_b() {
        this.field_76577_b = WorldType.field_77137_b;
        this.agedata = AgeData.getAge(this.ageUID, this.field_76579_a.field_72995_K);
        this.biomeManager = new BiomeWrapperManager(this);
        this.controller = new AgeController(this.field_76579_a, this.agedata);
        this.skyrenderer = this.controller.getSkyRenderer();
        this.weatherrenderer = this.controller.getWeatherRenderer();
        this.cloudrenderer = this.controller.getCloudRenderer();
        this.field_76578_c = this.controller.getWorldChunkManager();
        this.setWorldInfo();
    }

    public AgeController getAgeController() {
        return this.controller;
    }

    public void setWorldInfo() {
        if (this.field_76579_a.func_72912_H() instanceof WorldInfoMyst) {
            return;
        }
        ObfuscationReflectionHelper.setPrivateValue(World.class, (Object)this.field_76579_a, (Object)((Object)new WorldInfoMyst(this, this.field_76579_a.func_72912_H())), (String[])new String[]{"worldInfo", "field_72986_A"});
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        return this.skyrenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getCloudRenderer() {
        return this.cloudrenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getWeatherRenderer() {
        return this.weatherrenderer;
    }

    public IChunkProvider func_76555_c() {
        return new ChunkProviderMyst(this.getAgeController(), this.field_76579_a, this.agedata);
    }

    protected void func_76556_a() {
        this.getAgeController().generateLightBrightnessTable(this.field_76573_f);
    }

    public float[] func_76560_a(float f, float f1) {
        return null;
    }

    public float func_76563_a(long time, float partialtick) {
        return this.getAgeController().calculateCelestialAngle(time, partialtick);
    }

    public double func_76565_k() {
        return 1.0;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_76562_b(float celestial_angle, float partialtick) {
        EntityLivingBase entity = Minecraft.func_71410_x().field_71451_h;
        BiomeGenBase biome = this.field_76579_a.func_72807_a(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.field_70161_v));
        Vec3 fog = this.getAgeController().getFogColor((Entity)entity, biome, this.field_76579_a.func_72820_D(), celestial_angle, partialtick);
        if (fog == null) {
            float f2 = MathHelper.func_76134_b((float)(celestial_angle * 3.141593f * 2.0f)) * 2.0f + 0.5f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            float f3 = 0.7529412f;
            float f4 = 0.8470588f;
            float f5 = 1.0f;
            return Vec3.func_72443_a((double)(f3 *= f2 * 0.94f + 0.06f), (double)(f4 *= f2 * 0.94f + 0.06f), (double)(f5 *= f2 * 0.91f + 0.09f));
        }
        return fog;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 drawClouds(float partialtick) {
        float var9;
        float var8;
        float var6;
        float var5;
        float var4;
        float celestial_angle = this.field_76579_a.func_72826_c(partialtick);
        float var3 = MathHelper.func_76134_b((float)(celestial_angle * (float)Math.PI * 2.0f)) * 2.0f + 0.5f;
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        EntityLivingBase entity = Minecraft.func_71410_x().field_71451_h;
        BiomeGenBase biome = this.field_76579_a.func_72807_a(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.field_70161_v));
        Vec3 temp = this.getAgeController().getCloudColor((Entity)entity, biome, this.field_76579_a.func_72820_D(), celestial_angle, partialtick);
        if (temp != null) {
            var4 = (float)temp.field_72450_a;
            var5 = (float)temp.field_72448_b;
            var6 = (float)temp.field_72449_c;
        } else {
            var4 = 1.0f;
            var5 = 1.0f;
            var6 = 1.0f;
        }
        float var7 = this.field_76579_a.func_72867_j(partialtick);
        if (var7 > 0.0f) {
            var8 = (var4 * 0.3f + var5 * 0.59f + var6 * 0.11f) * 0.6f;
            var9 = 1.0f - var7 * 0.95f;
            var4 = var4 * var9 + var8 * (1.0f - var9);
            var5 = var5 * var9 + var8 * (1.0f - var9);
            var6 = var6 * var9 + var8 * (1.0f - var9);
        }
        var4 *= var3 * 0.9f + 0.1f;
        var5 *= var3 * 0.9f + 0.1f;
        var6 *= var3 * 0.85f + 0.15f;
        var8 = this.field_76579_a.func_72819_i(partialtick);
        if (var8 > 0.0f) {
            var9 = (var4 * 0.3f + var5 * 0.59f + var6 * 0.11f) * 0.2f;
            float var10 = 1.0f - var8 * 0.95f;
            var4 = var4 * var10 + var9 * (1.0f - var10);
            var5 = var5 * var10 + var9 * (1.0f - var10);
            var6 = var6 * var10 + var9 * (1.0f - var10);
        }
        return Vec3.func_72443_a((double)var4, (double)var5, (double)var6);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76564_j() {
        return false;
    }

    public boolean func_76561_g() {
        return false;
    }

    public float func_76571_f() {
        return this.getAgeController().getCloudHeight();
    }

    public double getHorizon() {
        return this.getAgeController().getHorizon();
    }

    public int func_76557_i() {
        return 64;
    }

    public boolean canBlockFreeze(int x, int y, int z, boolean reqLand) {
        Block block;
        BiomeGenBase biome = this.getBiomeGenForCoords(x, z);
        float temp = biome.func_150564_a(x, y, z);
        temp = this.getAgeController().getTemperatureAtHeight(temp, y);
        if (temp > 0.15f) {
            return false;
        }
        if (y >= 0 && y < 256 && this.field_76579_a.func_72972_b(EnumSkyBlock.Block, x, y, z) < 10 && ((block = this.field_76579_a.func_147439_a(x, y, z)) == Blocks.field_150355_j || block == Blocks.field_150358_i) && this.field_76579_a.func_72805_g(x, y, z) == 0) {
            if (!reqLand) {
                return true;
            }
            boolean var8 = true;
            if (var8 && this.field_76579_a.func_147439_a(x - 1, y, z).func_149688_o() != Material.field_151586_h) {
                var8 = false;
            }
            if (var8 && this.field_76579_a.func_147439_a(x + 1, y, z).func_149688_o() != Material.field_151586_h) {
                var8 = false;
            }
            if (var8 && this.field_76579_a.func_147439_a(x, y, z - 1).func_149688_o() != Material.field_151586_h) {
                var8 = false;
            }
            if (var8 && this.field_76579_a.func_147439_a(x, y, z + 1).func_149688_o() != Material.field_151586_h) {
                var8 = false;
            }
            if (!var8) {
                return true;
            }
        }
        return false;
    }

    public boolean canSnowAt(int x, int y, int z, boolean checkLight) {
        Block var7;
        BiomeGenBase biome = this.getBiomeGenForCoords(x, z);
        float temp = biome.func_150564_a(x, y, z);
        temp = this.getAgeController().getTemperatureAtHeight(temp, y);
        if (temp > 0.15f) {
            return false;
        }
        return y >= 0 && y < 256 && this.field_76579_a.func_72972_b(EnumSkyBlock.Block, x, y, z) < 10 && ((var7 = this.field_76579_a.func_147439_a(x, y, z)) == null || var7.isAir((IBlockAccess)this.field_76579_a, x, y, z)) && Blocks.field_150431_aC.func_149742_c(this.field_76579_a, x, y, z);
    }

    public void calculateInitialWeather() {
        this.updateWeather();
    }

    public boolean canDoLightning(Chunk chunk) {
        this.getAgeController().tickBlocksAndAmbiance(chunk);
        return false;
    }

    public void updateWeather() {
        this.getAgeController().tick();
        this.getAgeController().getWeatherController().updateRaining();
        this.weatherrenderer.updateClouds();
        this.cloudrenderer.updateClouds();
        this.field_76579_a.field_73003_n = this.field_76579_a.field_73004_o;
        this.field_76579_a.field_73004_o = this.getAgeController().getWeatherController().getRainingStrength();
        this.field_76579_a.field_73018_p = this.field_76579_a.field_73017_q;
        this.field_76579_a.field_73017_q = this.getAgeController().getWeatherController().getStormStrength();
        if (this.field_76579_a.field_72995_K || !(this.field_76579_a instanceof WorldServer)) {
            return;
        }
        WorldServer world = (WorldServer)this.field_76579_a;
        if (this.field_76579_a.field_73010_i.isEmpty()) {
            if (this.emptyTicks == 10) {
                world.field_73059_b.func_73240_a();
            }
            ++this.emptyTicks;
        } else {
            this.emptyTicks = 0;
        }
        if (world.func_73056_e()) {
            this.setWorldTime(this.getWorldTime() + this.timeToSunrise());
        }
        this.setWorldTime(this.getWorldTime() + 1L);
        if (this.agedata.needsResend() && world.func_82737_E() % 200L == 0L) {
            this.agedata.resent();
            for (Object player : this.field_76579_a.field_73010_i) {
                NetworkUtils.sendAgeData((EntityPlayer)player, this.field_76574_g);
            }
        }
    }

    private long timeToSunrise() {
        return this.getAgeController().getTimeToSunrise(this.getWorldTime());
    }

    public void resetRainAndThunder() {
        this.agedata.markNeedsResend();
        this.getAgeController().getWeatherController().reset();
    }

    public void togglePrecipitation() {
        this.agedata.markNeedsResend();
        this.getAgeController().getWeatherController().togglePrecipitation();
    }

    public ChunkCoordinates getSpawnPoint() {
        this.verifySpawn();
        return new ChunkCoordinates(this.agedata.getSpawn());
    }

    public ChunkCoordinates getRandomizedSpawnPoint() {
        return this.getSpawnPoint();
    }

    public ChunkCoordinates func_76554_h() {
        this.verifySpawn();
        return new ChunkCoordinates(this.agedata.getSpawn());
    }

    private void verifySpawn() {
        if (this.agedata.getSpawn() != null) {
            return;
        }
        if (this.field_76579_a.field_72995_K) {
            this.agedata.setSpawn(new ChunkCoordinates(0, 0, 0));
            return;
        }
        this.field_76579_a.field_72987_B = true;
        Random random = new Random(this.agedata.getSeed());
        ChunkPosition chunkposition = this.field_76578_c.func_150795_a(0, 0, 256, this.field_76578_c.func_76932_a(), random);
        int x = 0;
        int y = this.getAgeController().getSeaLevel();
        int z = 0;
        if (chunkposition != null) {
            x = chunkposition.field_151329_a;
            z = chunkposition.field_151328_c;
        } else {
            System.out.println("Still searching for a spawn point.");
        }
        for (int l = 0; l < 1000 && !this.func_76566_a(x, z) && this.agedata.getSpawn() == null; ++l) {
            x = random.nextInt(64) - random.nextInt(64);
            z = random.nextInt(64) - random.nextInt(64);
        }
        if (this.agedata.getSpawn() == null) {
            this.field_76579_a.func_72938_d(x, z);
            while (!this.field_76579_a.func_147437_c(x, y, z)) {
                ++y;
            }
            this.agedata.setSpawn(new ChunkCoordinates(x, y, z));
        }
        this.field_76579_a.field_72987_B = false;
    }

    public boolean func_76566_a(int x, int z) {
        int y = this.field_76579_a.func_72825_h(x, z);
        Block block = this.field_76579_a.func_147439_a(x, y, z);
        if (block == Blocks.field_150357_h) {
            return false;
        }
        if (this.field_76579_a.func_147437_c(x, y, z)) {
            return false;
        }
        return block.func_149688_o().func_76230_c();
    }

    public BiomeGenBase getBiomeGenForCoords(int x, int z) {
        return this.biomeManager.getWrapper(x, z);
    }

    private int getSkyColorByTemp(float par1) {
        if ((par1 /= 3.0f) < -1.0f) {
            par1 = -1.0f;
        }
        if (par1 > 1.0f) {
            par1 = 1.0f;
        }
        return java.awt.Color.getHSBColor(0.62222224f - par1 * 0.05f, 0.5f + par1 * 0.1f, 1.0f).getRGB();
    }

    public Color getStaticColor(String string, BiomeGenBase biome, int x, int y, int z) {
        return this.getAgeController().getStaticColor(string, biome, x, y, z);
    }

    public Vec3 getSkyColor(Entity entity, float partialtick) {
        float var14;
        float celestial_angle = this.field_76579_a.func_72826_c(partialtick);
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        BiomeGenBase biome = this.field_76579_a.func_72807_a(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.field_70161_v));
        Vec3 out = this.getAgeController().getSkyColor(entity, biome, this.field_76579_a.func_72820_D(), celestial_angle, partialtick);
        if (out == null) {
            float var4 = MathHelper.func_76134_b((float)(celestial_angle * (float)Math.PI * 2.0f)) * 2.0f + 0.5f;
            if (var4 < 0.0f) {
                var4 = 0.0f;
            }
            if (var4 > 1.0f) {
                var4 = 1.0f;
            }
            float var8 = biome.func_150564_a(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.field_70163_u), MathHelper.func_76128_c((double)entity.field_70161_v));
            int var9 = this.getSkyColorByTemp(var8);
            red = (float)(var9 >> 16 & 0xFF) / 255.0f;
            green = (float)(var9 >> 8 & 0xFF) / 255.0f;
            blue = (float)(var9 & 0xFF) / 255.0f;
            red *= var4;
            green *= var4;
            blue *= var4;
        } else {
            red = (float)out.field_72450_a;
            green = (float)out.field_72448_b;
            blue = (float)out.field_72449_c;
        }
        float rainstrength = this.field_76579_a.func_72867_j(partialtick);
        if (rainstrength > 0.0f) {
            var14 = (red * 0.3f + green * 0.59f + blue * 0.11f) * 0.6f;
            float var15 = 1.0f - rainstrength * 0.75f;
            red = red * var15 + var14 * (1.0f - var15);
            green = green * var15 + var14 * (1.0f - var15);
            blue = blue * var15 + var14 * (1.0f - var15);
        }
        if ((var14 = this.field_76579_a.func_72819_i(partialtick)) > 0.0f) {
            float var15 = (red * 0.3f + green * 0.59f + blue * 0.11f) * 0.2f;
            float var16 = 1.0f - var14 * 0.75f;
            red = red * var16 + var15 * (1.0f - var16);
            green = green * var16 + var15 * (1.0f - var16);
            blue = blue * var16 + var15 * (1.0f - var16);
        }
        if (this.field_76579_a.field_73016_r > 0) {
            float var15 = (float)this.field_76579_a.field_73016_r - partialtick;
            if (var15 > 1.0f) {
                var15 = 1.0f;
            }
            red = red * (1.0f - (var15 *= 0.45f)) + 0.8f * var15;
            green = green * (1.0f - var15) + 0.8f * var15;
            blue = blue * (1.0f - var15) + 1.0f * var15;
        }
        return Vec3.func_72443_a((double)red, (double)green, (double)blue);
    }

    public String getSaveFolder() {
        return WorldProviderMyst.getSaveFolderName(this.ageUID);
    }

    public static String getSaveFolderName(int dimid) {
        return "DIM_MYST" + dimid;
    }

    public String getWelcomeMessage() {
        return "Traveling to " + this.func_80007_l();
    }

    public String getDepartMessage() {
        return "Traveling from " + this.func_80007_l();
    }

    public String func_80007_l() {
        if (this.agedata == null) {
            if (this.field_76579_a != null) {
                this.agedata = AgeData.getAge(this.ageUID, this.field_76579_a.field_72995_K);
            } else {
                LoggerUtils.warn("Someone is trying to get the age name from an improperly constructed world provider with dim id " + this.ageUID, new Object[0]);
                this.agedata = AgeData.getAge(this.ageUID, false);
            }
        }
        if (this.agedata == null) {
            return "Age " + this.ageUID;
        }
        return this.agedata.getAgeName();
    }

    public long getWorldTime() {
        return this.agedata.getWorldTime();
    }

    public void setWorldTime(long time) {
        this.agedata.setWorldTime(time);
    }

    public boolean func_76567_e() {
        return Mystcraft.respawnInAges;
    }

    public boolean isPvPEnabled() {
        return this.getAgeController().isPvPEnabled();
    }

    public float getTemperature(float temperature, int biomeId) {
        return this.getAgeController().getWeatherController().getTemperature(temperature, biomeId);
    }

    public float getRainfall(float rainfall, int biomeId) {
        return this.getAgeController().getWeatherController().getRainfall(rainfall, biomeId);
    }

    public boolean getEnableSnow(boolean enableSnow, int biomeId) {
        return this.getAgeController().getWeatherController().getEnableSnow(enableSnow, biomeId);
    }

    public boolean getEnableRain(boolean canSpawnLightningBolt, int biomeId) {
        return this.getAgeController().getWeatherController().getEnableRain(canSpawnLightningBolt, biomeId);
    }
}

