/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.data.GarageDoor;
import com.carpentersblocks.renderer.BlockHandlerBase;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.registry.IconRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockHandlerCarpentersGarageDoor
extends BlockHandlerBase {
    private GarageDoor data = new GarageDoor();
    private ItemStack iron = new ItemStack(Blocks.field_150339_S);
    ForgeDirection dir;
    boolean isOpen;

    @Override
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderBlocks) {
        renderBlocks.func_147782_a(0.4375, 0.75, 0.0, 0.5625, 1.0, 1.0);
        super.renderInventoryBlock(block, metadata, modelID, renderBlocks);
        renderBlocks.func_147782_a(0.4375, 0.625, 0.0, 0.5625, 0.75, 0.3125);
        super.renderInventoryBlock(block, metadata, modelID, renderBlocks);
        renderBlocks.func_147782_a(0.4375, 0.625, 0.6875, 0.5625, 0.75, 1.0);
        super.renderInventoryBlock(block, metadata, modelID, renderBlocks);
        renderBlocks.func_147782_a(0.4375, 0.0, 0.0, 0.5625, 0.625, 1.0);
        super.renderInventoryBlock(block, metadata, modelID, renderBlocks);
    }

    @Override
    protected void renderCarpentersBlock(int x, int y, int z) {
        if (this.data.isVisible(this.TE)) {
            this.renderBlocks.field_147837_f = true;
            this.isOpen = this.data.isOpen(this.TE);
            ItemStack itemStack = this.getCoverForRendering(new TEBase[0]);
            this.dir = this.data.getDirection(this.TE);
            switch (this.data.getType(this.TE)) {
                case 0: {
                    this.renderTypeDefault(itemStack, x, y, z);
                    break;
                }
                case 1: {
                    this.renderTypeGlassTop(itemStack, x, y, z);
                    break;
                }
                case 2: {
                    this.renderTypeGlass(itemStack, x, y, z);
                    break;
                }
                case 3: {
                    this.renderTypeSiding(itemStack, x, y, z);
                    break;
                }
                case 4: {
                    this.renderTypeHidden(itemStack, x, y, z);
                }
            }
            this.renderBlocks.field_147837_f = false;
        }
    }

    public void renderPartPane(IIcon icon, int x, int y, int z, float offset) {
        switch (this.dir) {
            case NORTH: {
                this.renderBlocks.func_147782_a(0.0, 0.0, (double)(1.0f - offset), 1.0, 1.0, (double)(1.0f - offset));
                break;
            }
            case SOUTH: {
                this.renderBlocks.func_147782_a(0.0, 0.0, (double)offset, 1.0, 1.0, (double)offset);
                break;
            }
            case WEST: {
                this.renderBlocks.func_147782_a((double)(1.0f - offset), 0.0, 0.0, (double)(1.0f - offset), 1.0, 1.0);
                break;
            }
            case EAST: {
                this.renderBlocks.func_147782_a((double)offset, 0.0, 0.0, (double)offset, 1.0, 1.0);
                break;
            }
        }
        this.renderPane(icon, x, y, z, this.dir, true, true);
    }

    private ItemStack getOpenCover() {
        return this.getCoverForRendering(this.data.getBottommost(this.TE.func_145831_w(), this.TE.field_145851_c, this.TE.field_145848_d, this.TE.field_145849_e));
    }

    public void renderTypeDefault(ItemStack itemStack, int x, int y, int z) {
        if (this.data.isOpen(this.TE)) {
            this.renderBlockWithRotation(this.getOpenCover(), x, y, z, 0.0, 0.5, 0.125, 1.0, 1.0, 0.25, this.dir);
        } else {
            this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.0, 0.125, 0.3125, 1.0, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.3125, 0.75, 0.125, 0.6875, 1.0, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.3125, 0.0, 0.125, 0.6875, 0.625, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.6875, 0.0, 0.125, 1.0, 1.0, 0.25, this.dir);
        }
    }

    public void renderTypeGlassTop(ItemStack itemStack, int x, int y, int z) {
        if (this.data.isOpen(this.TE)) {
            itemStack = this.getOpenCover();
            this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.5, 0.1875, 1.0, 1.0, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.5, 0.125, 0.125, 1.0, 0.1875, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.9375, 0.125, 0.875, 1.0, 0.1875, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.5, 0.125, 0.875, 0.625, 0.1875, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.875, 0.5, 0.125, 1.0, 1.0, 0.1875, this.dir);
        } else if (this.data.isHost(this.TE)) {
            this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.0, 0.125, 0.125, 1.0, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.875, 0.125, 0.875, 1.0, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.4375, 0.125, 0.875, 0.5625, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.0, 0.125, 0.875, 0.125, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.125, 0.1875, 0.875, 0.4375, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.875, 0.0, 0.125, 1.0, 1.0, 0.25, this.dir);
            this.renderPartPane(IconRegistry.icon_garage_glass_top, x, y, z, 0.1875f);
        } else {
            this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.0, 0.125, 0.125, 1.0, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.875, 0.125, 0.875, 1.0, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.4375, 0.125, 0.875, 0.5625, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.0, 0.125, 0.875, 0.125, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.0, 0.1875, 1.0, 1.0, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.875, 0.0, 0.125, 1.0, 1.0, 0.25, this.dir);
        }
    }

    public void renderPanelsOpen(ItemStack itemStack, int x, int y, int z) {
        this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.5, 0.1875, 1.0, 1.0, 0.25, this.dir);
        this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.5, 0.125, 0.125, 1.0, 0.1875, this.dir);
        this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.9375, 0.125, 0.875, 1.0, 0.1875, this.dir);
        this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.5, 0.125, 0.875, 0.625, 0.1875, this.dir);
        this.renderBlockWithRotation(itemStack, x, y, z, 0.875, 0.5, 0.125, 1.0, 1.0, 0.1875, this.dir);
    }

    public void renderPanelsGlassTop(ItemStack itemStack, int x, int y, int z) {
        if (this.data.isOpen(this.TE)) {
            this.renderPanelsOpen(this.getOpenCover(), x, y, z);
        } else {
            this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.0, 0.125, 0.125, 1.0, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.875, 0.125, 0.875, 1.0, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.4375, 0.125, 0.875, 0.5625, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.0, 0.125, 0.875, 0.125, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.125, 0.1875, 0.875, 0.4375, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.875, 0.0, 0.125, 1.0, 1.0, 0.25, this.dir);
            this.renderPartPane(IconRegistry.icon_garage_glass_top, x, y, z, 0.1875f);
        }
    }

    public void renderPanels(ItemStack itemStack, int x, int y, int z) {
        if (this.data.isOpen(this.TE)) {
            this.renderPanelsOpen(this.getOpenCover(), x, y, z);
        } else {
            this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.0, 0.125, 0.125, 1.0, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.875, 0.125, 0.875, 1.0, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.4375, 0.125, 0.875, 0.5625, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.0, 0.125, 0.875, 0.125, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.0, 0.1875, 1.0, 1.0, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.875, 0.0, 0.125, 1.0, 1.0, 0.25, this.dir);
        }
    }

    public void renderTypeGlass(ItemStack itemStack, int x, int y, int z) {
        if (this.data.isBottommost(this.TE)) {
            this.renderPanelsGlassTop(itemStack, x, y, z);
        } else if (this.data.isOpen(this.TE)) {
            this.renderPanelsOpen(this.getOpenCover(), x, y, z);
        } else {
            this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.0, 0.125, 0.125, 1.0, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.875, 0.125, 0.875, 1.0, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.0, 0.125, 0.875, 0.125, 0.25, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.875, 0.0, 0.125, 1.0, 1.0, 0.25, this.dir);
            this.renderPartPane(IconRegistry.icon_garage_glass, x, y, z, 0.1875f);
        }
    }

    public void renderTypeSiding(ItemStack itemStack, int x, int y, int z) {
        if (this.data.isOpen(this.TE)) {
            this.suppressOverlay = true;
            this.suppressDyeColor = true;
            this.suppressChiselDesign = true;
            this.renderBlockWithRotation(this.iron, x, y, z, 0.0, 0.5, 0.1875, 1.0, 1.0, 0.25, this.dir);
            this.suppressOverlay = false;
            this.suppressDyeColor = false;
            this.suppressChiselDesign = false;
            this.renderBlockWithRotation(this.getOpenCover(), x, y, z, 0.0, 0.5, 0.125, 1.0, 0.9375, 0.1875, this.dir);
        } else {
            this.suppressOverlay = true;
            this.suppressDyeColor = true;
            this.suppressChiselDesign = true;
            this.renderBlockWithRotation(this.iron, x, y, z, 0.0, 0.0, 0.1875, 1.0, 1.0, 0.25, this.dir);
            this.suppressOverlay = false;
            this.suppressDyeColor = false;
            this.suppressChiselDesign = false;
            this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.0, 0.125, 1.0, 0.4375, 0.1875, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.5, 0.125, 1.0, 0.9375, 0.1875, this.dir);
        }
    }

    public void renderTypeHidden(ItemStack itemStack, int x, int y, int z) {
        this.renderBlockWithRotation(this.isOpen ? this.getOpenCover() : itemStack, x, y, z, 0.0, this.data.isOpen(this.TE) ? 0.5 : 0.0, 0.0, 1.0, 1.0, 0.125, this.dir);
    }
}

