/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util;

import com.carpentersblocks.api.IWrappableBlock;
import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.handler.ChatHandler;
import com.carpentersblocks.util.handler.DyeHandler;
import com.carpentersblocks.util.handler.OverlayHandler;
import com.carpentersblocks.util.registry.FeatureRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockSlab;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class BlockProperties {
    public static final Block.SoundType stepSound = new Block.SoundType("CarpentersBlocks", 1.0f, 1.0f);
    public static final int MASK_DEFAULT_ICON = 16;

    public static boolean isMetadataDefaultIcon(int metadata) {
        return (metadata & 0x10) > 0;
    }

    public static TEBase getTileEntity(Block block, World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity != null && tileEntity instanceof TEBase && world.func_147439_a(x, y, z).equals(block)) {
            return (TEBase)tileEntity;
        }
        return null;
    }

    public static void prepareItemStackForRendering(ItemStack itemStack) {
        if (BlockProperties.toBlock(itemStack) instanceof BlockCoverable) {
            itemStack.func_77964_b(itemStack.func_77960_j() | 0x10);
        }
    }

    public static boolean hasAttribute(TEBase TE, byte attr) {
        return TE != null && TE.hasAttribute(attr);
    }

    public static Block toBlock(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemBlock) {
            return Block.func_149634_a((Item)itemStack.func_77973_b());
        }
        return Blocks.field_150350_a;
    }

    public static float getSideCoverDepth(TEBase TE, int side) {
        if (side == 1) {
            Block block;
            if (TE.hasAttribute(TEBase.ATTR_COVER[side]) && ((block = BlockProperties.toBlock(BlockProperties.getCover(TE, side))).equals(Blocks.field_150433_aE) || block.equals(Blocks.field_150431_aC))) {
                return 0.125f;
            }
        }
        return 0.0625f;
    }

    public static boolean blockRotates(ItemStack itemStack) {
        Block block = BlockProperties.toBlock(itemStack);
        return block instanceof BlockQuartz || block instanceof BlockRotatedPillar;
    }

    public static void playBlockSound(World world, ItemStack itemStack, int x, int y, int z, boolean reducedVolume) {
        if (itemStack != null) {
            Object block = itemStack.func_77973_b() instanceof ItemBlock ? BlockProperties.toBlock(itemStack) : Blocks.field_150354_m;
            Block.SoundType soundType = block.field_149762_H;
            float volume = (soundType.func_150497_c() + 1.0f) / (reducedVolume ? 8.0f : 2.0f);
            float pitch = soundType.func_150494_d() * 0.8f;
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), soundType.func_150496_b(), volume, pitch);
        }
    }

    public static ItemStack getCallableItemStack(ItemStack itemStack) {
        Block block = BlockProperties.toBlock(itemStack);
        if (block instanceof BlockCoverable || block instanceof IWrappableBlock) {
            return itemStack;
        }
        return block.hasTileEntity(itemStack.func_77960_j()) ? new ItemStack(Blocks.field_150344_f) : itemStack;
    }

    public static ItemStack getCover(TEBase TE, int side) {
        ItemStack itemStack = BlockProperties.getCoverSafe(TE, side);
        return BlockProperties.getCallableItemStack(itemStack);
    }

    public static ItemStack getCoverSafe(TEBase TE, int side) {
        ItemStack itemStack = TE.getAttribute(TEBase.ATTR_COVER[side]);
        return itemStack != null ? itemStack : new ItemStack(TE.func_145838_q());
    }

    public static boolean isCover(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemBlock && !BlockProperties.isOverlay(itemStack)) {
            Block block = BlockProperties.toBlock(itemStack);
            return block.func_149686_d() || block instanceof BlockSlab || block instanceof BlockPane || block instanceof BlockBreakable || FeatureRegistry.coverExceptions.contains(itemStack.func_82833_r()) || FeatureRegistry.coverExceptions.contains(ChatHandler.getDefaultTranslation(itemStack));
        }
        return false;
    }

    public static boolean isIlluminator(ItemStack itemStack) {
        if (itemStack != null) {
            for (int Id : OreDictionary.getOreIDs((ItemStack)itemStack)) {
                if (!OreDictionary.getOreName((int)Id).equals("dustGlowstone")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDye(ItemStack itemStack, boolean allowWhite) {
        return itemStack.func_77973_b() != null && DyeHandler.isDye(itemStack, allowWhite);
    }

    public static boolean isOverlay(ItemStack itemStack) {
        return OverlayHandler.overlayMap.containsKey(itemStack.func_82833_r()) || OverlayHandler.overlayMap.containsKey(ChatHandler.getDefaultTranslation(itemStack));
    }

    public static String getOreDictMatch(ItemStack itemStack, String ... name) {
        if (itemStack != null) {
            for (int Id : OreDictionary.getOreIDs((ItemStack)itemStack)) {
                for (String oreName : name) {
                    if (!OreDictionary.getOreName((int)Id).equals(oreName)) continue;
                    return oreName;
                }
            }
        }
        return "";
    }

    public static ItemStack getFeatureSensitiveSideItemStack(TEBase TE, ForgeDirection side) {
        if (side.equals((Object)ForgeDirection.UNKNOWN)) {
            return BlockProperties.getCover(TE, 6);
        }
        ItemStack itemStack = null;
        int effectiveSide = TE.hasAttribute(TEBase.ATTR_COVER[side.ordinal()]) ? side.ordinal() : 6;
        if (TE.hasAttribute(TEBase.ATTR_OVERLAY[effectiveSide])) {
            OverlayHandler.Overlay overlay = OverlayHandler.getOverlayType(TE.getAttribute(TEBase.ATTR_OVERLAY[effectiveSide]));
            if (OverlayHandler.coversFullSide(overlay, side.ordinal())) {
                itemStack = overlay.getItemStack();
            }
        }
        if (itemStack == null) {
            itemStack = BlockProperties.getCover(TE, effectiveSide);
        }
        return itemStack;
    }
}

