/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ICustomElectricItem;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.IEnergizedItem;
import mekanism.common.ISustainedInventory;
import mekanism.common.ISustainedTank;
import mekanism.common.Mekanism;
import mekanism.common.TileEntityElectricBlock;
import mekanism.generators.common.BlockGenerator;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.input.Keyboard;
import thermalexpansion.api.item.IChargeableItem;
import universalelectricity.core.electricity.ElectricityDisplay;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.item.IItemElectric;

public class ItemBlockGenerator
extends ItemBlock
implements IEnergizedItem,
IItemElectric,
ICustomElectricItem,
ISustainedInventory,
ISustainedTank,
IChargeableItem {
    public Block metaBlock;

    public ItemBlockGenerator(int id, Block block) {
        super(id);
        this.metaBlock = block;
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public int func_77647_b(int i) {
        return i;
    }

    public Icon func_77617_a(int i) {
        return this.metaBlock.func_71858_a(2, i);
    }

    public String func_77667_c(ItemStack itemstack) {
        String name = "";
        switch (itemstack.func_77960_j()) {
            case 0: {
                name = "HeatGenerator";
                break;
            }
            case 1: {
                name = "SolarGenerator";
                break;
            }
            case 2: {
                name = "ElectrolyticSeparator";
                break;
            }
            case 3: {
                name = "HydrogenGenerator";
                break;
            }
            case 4: {
                name = "BioGenerator";
                break;
            }
            case 5: {
                name = "AdvancedSolarGenerator";
                break;
            }
            case 6: {
                name = "WindTurbine";
                break;
            }
            default: {
                name = "Unknown";
            }
        }
        return this.func_77658_a() + "." + name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        if (!Keyboard.isKeyDown((int)42)) {
            list.add("Hold " + EnumColor.AQUA + "shift" + EnumColor.GREY + " for details.");
        } else {
            list.add(EnumColor.BRIGHT_GREEN + "Stored Energy: " + EnumColor.GREY + ElectricityDisplay.getDisplayShort((double)this.getJoules(itemstack), (ElectricityDisplay.ElectricUnit)ElectricityDisplay.ElectricUnit.JOULES));
            list.add(EnumColor.BRIGHT_GREEN + "Voltage: " + EnumColor.GREY + this.getVoltage(itemstack) + "v");
            if (this.hasTank(itemstack) && this.getLiquidStack(itemstack) != null) {
                list.add(EnumColor.PINK + LiquidDictionary.findLiquidName((LiquidStack)this.getLiquidStack(itemstack)) + ": " + EnumColor.GREY + this.getLiquidStack((Object[])new Object[]{itemstack}).amount + "mB");
            }
            list.add(EnumColor.AQUA + "Inventory: " + EnumColor.GREY + (this.getInventory(itemstack) != null && this.getInventory(itemstack).func_74745_c() != 0));
        }
    }

    public double getJoules(ItemStack itemStack) {
        return this.getEnergy(itemStack);
    }

    public void setJoules(double wattHours, ItemStack itemStack) {
        this.setEnergy(itemStack, wattHours);
    }

    public double getMaxJoules(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack);
    }

    public double getVoltage(ItemStack itemStack) {
        return itemStack.func_77960_j() == 3 ? 240.0 : 120.0;
    }

    public ElectricityPack onReceive(ElectricityPack electricityPack, ItemStack itemStack) {
        if (itemStack.func_77960_j() == 2) {
            double rejectedElectricity = Math.max(this.getJoules(itemStack) + electricityPack.getWatts() - this.getMaxJoules(itemStack), 0.0);
            double joulesToStore = electricityPack.getWatts() - rejectedElectricity;
            this.setJoules(this.getJoules(itemStack) + joulesToStore, itemStack);
            return ElectricityPack.getFromWatts((double)joulesToStore, (double)this.getVoltage(itemStack));
        }
        return new ElectricityPack();
    }

    public ElectricityPack onProvide(ElectricityPack electricityPack, ItemStack itemStack) {
        if (itemStack.func_77960_j() != 2) {
            double electricityToUse = Math.min(this.getJoules(itemStack), electricityPack.getWatts());
            this.setJoules(this.getJoules(itemStack) - electricityToUse, itemStack);
            return ElectricityPack.getFromWatts((double)electricityToUse, (double)this.getVoltage(itemStack));
        }
        return new ElectricityPack();
    }

    public ElectricityPack getReceiveRequest(ItemStack itemStack) {
        return itemStack.func_77960_j() == 2 ? ElectricityPack.getFromWatts((double)Math.min(this.getMaxJoules(itemStack) - this.getJoules(itemStack), this.getTransferRate(itemStack)), (double)this.getVoltage(itemStack)) : new ElectricityPack();
    }

    public ElectricityPack getProvideRequest(ItemStack itemStack) {
        return itemStack.func_77960_j() != 2 ? ElectricityPack.getFromWatts((double)Math.min(this.getJoules(itemStack), this.getTransferRate(itemStack)), (double)this.getVoltage(itemStack)) : new ElectricityPack();
    }

    public double getTransferRate(ItemStack itemStack) {
        return this.getMaxJoules(itemStack) * 0.01;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        boolean place = true;
        if (stack.func_77960_j() == BlockGenerator.GeneratorType.ADVANCED_SOLAR_GENERATOR.meta) {
            if (world.func_72798_a(x, y, z) != Block.field_71962_X.field_71990_ca && world.func_72798_a(x, y, z) != 0) {
                place = false;
            }
            if (world.func_72798_a(x, y, z) != 0 && Block.field_71973_m[world.func_72798_a(x, y, z)].isBlockReplaceable(world, x, y, z)) {
                place = true;
            }
            for (int xPos = -1; xPos <= 1; ++xPos) {
                for (int zPos = -1; zPos <= 1; ++zPos) {
                    if (world.func_72798_a(x + xPos, y + 2, z + zPos) == 0 && y + 2 <= 255) continue;
                    place = false;
                }
            }
        } else if (stack.func_77960_j() == BlockGenerator.GeneratorType.WIND_TURBINE.meta) {
            if (world.func_72798_a(x, y, z) != Block.field_71962_X.field_71990_ca && world.func_72798_a(x, y, z) != 0) {
                place = false;
            }
            if (world.func_72798_a(x, y, z) != 0 && Block.field_71973_m[world.func_72798_a(x, y, z)].isBlockReplaceable(world, x, y, z)) {
                place = true;
            }
            for (int yPos = y + 1; yPos <= y + 4; ++yPos) {
                if (world.func_72798_a(x, yPos, z) == 0 && yPos <= 255) continue;
                place = false;
            }
        }
        if (place && super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata)) {
            TileEntityElectricBlock tileEntity = (TileEntityElectricBlock)world.func_72796_p(x, y, z);
            tileEntity.electricityStored = this.getJoules(stack);
            tileEntity.setInventory(this.getInventory(stack), new Object[0]);
            if (tileEntity instanceof ISustainedTank && this.hasTank(stack) && this.getLiquidStack(stack) != null) {
                ((ISustainedTank)tileEntity).setLiquidStack(this.getLiquidStack(stack), new Object[]{stack});
            }
            return true;
        }
        return false;
    }

    public int charge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (itemStack.func_77960_j() == 2) {
            double energyNeeded = this.getMaxEnergy(itemStack) - this.getEnergy(itemStack);
            double energyToStore = Math.min(Math.min((double)amount * Mekanism.FROM_IC2, this.getMaxEnergy(itemStack) * 0.01), energyNeeded);
            if (!simulate) {
                this.setEnergy(itemStack, this.getEnergy(itemStack) + energyToStore);
            }
            return (int)(energyToStore * Mekanism.TO_IC2);
        }
        return 0;
    }

    public int discharge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (itemStack.func_77960_j() != 2) {
            double energyWanted = (double)amount * Mekanism.FROM_IC2;
            double energyToGive = Math.min(Math.min(energyWanted, this.getMaxEnergy(itemStack) * 0.01), this.getJoules(itemStack));
            if (!simulate) {
                this.setJoules(this.getJoules(itemStack) - energyToGive, itemStack);
            }
            return (int)(energyToGive * Mekanism.TO_IC2);
        }
        return 0;
    }

    public boolean canUse(ItemStack itemStack, int amount) {
        return this.getJoules(itemStack) >= (double)amount * Mekanism.FROM_IC2;
    }

    public boolean canShowChargeToolTip(ItemStack itemStack) {
        return false;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return itemStack.func_77960_j() != 2;
    }

    public int getChargedItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    public int getEmptyItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    public int getMaxCharge(ItemStack itemStack) {
        return 0;
    }

    public int getTier(ItemStack itemStack) {
        return 3;
    }

    public int getTransferLimit(ItemStack itemStack) {
        return 0;
    }

    public void setInventory(NBTTagList nbtTags, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74782_a("Items", (NBTBase)nbtTags);
        }
    }

    public NBTTagList getInventory(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return null;
            }
            return itemStack.field_77990_d.func_74761_m("Items");
        }
        return null;
    }

    public void setLiquidStack(LiquidStack liquidStack, Object ... data) {
        if (liquidStack == null || liquidStack.amount == 0 || liquidStack.itemID == 0) {
            return;
        }
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74782_a("liquidTank", (NBTBase)liquidStack.writeToNBT(new NBTTagCompound()));
        }
    }

    public LiquidStack getLiquidStack(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return null;
            }
            if (itemStack.field_77990_d.func_74764_b("liquidTank")) {
                return LiquidStack.loadLiquidStackFromNBT((NBTTagCompound)itemStack.field_77990_d.func_74775_l("liquidTank"));
            }
        }
        return null;
    }

    public boolean hasTank(Object ... data) {
        return data[0] instanceof ItemStack && ((ItemStack)data[0]).func_77973_b() instanceof ISustainedTank && ((ItemStack)data[0]).func_77960_j() == 2;
    }

    public double getEnergy(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 0.0;
        }
        return itemStack.field_77990_d.func_74769_h("electricity");
    }

    public void setEnergy(ItemStack itemStack, double amount) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        double electricityStored = Math.max(Math.min(amount, this.getMaxJoules(itemStack)), 0.0);
        itemStack.field_77990_d.func_74780_a("electricity", electricityStored);
    }

    public double getMaxEnergy(ItemStack itemStack) {
        return BlockGenerator.GeneratorType.getFromMetadata((int)itemStack.func_77960_j()).maxEnergy;
    }

    public double getMaxTransfer(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack) * 0.005;
    }

    public boolean canReceive(ItemStack itemStack) {
        return itemStack.func_77960_j() == BlockGenerator.GeneratorType.ELECTROLYTIC_SEPARATOR.meta;
    }

    public boolean canSend(ItemStack itemStack) {
        return itemStack.func_77960_j() != BlockGenerator.GeneratorType.ELECTROLYTIC_SEPARATOR.meta;
    }

    public float receiveEnergy(ItemStack theItem, float energy, boolean doReceive) {
        return 0.0f;
    }

    public float transferEnergy(ItemStack theItem, float energy, boolean doTransfer) {
        double energyRemaining = this.getEnergy(theItem);
        double toSend = Math.min((double)energy * Mekanism.FROM_BC, energyRemaining);
        if (doTransfer) {
            this.setEnergy(theItem, this.getEnergy(theItem) - toSend);
        }
        return (float)(toSend * Mekanism.TO_BC);
    }

    public float getEnergyStored(ItemStack theItem) {
        return (float)(this.getEnergy(theItem) * Mekanism.TO_BC);
    }

    public float getMaxEnergyStored(ItemStack theItem) {
        return (float)(this.getMaxEnergy(theItem) * Mekanism.TO_BC);
    }

    public boolean isMetadataSpecific() {
        return true;
    }
}

