/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import mekanism.api.InfuseObject;
import mekanism.api.InfuseRegistry;
import mekanism.api.InfuseType;
import mekanism.common.IModule;
import mekanism.common.ItemMekanism;
import mekanism.common.Mekanism;
import mekanism.common.MekanismRecipe;
import mekanism.common.PacketHandler;
import mekanism.common.RecipeHandler;
import mekanism.common.Version;
import mekanism.generators.common.BlockGenerator;
import mekanism.generators.common.GeneratorsCommonProxy;
import mekanism.generators.common.GeneratorsGuiHandler;
import mekanism.generators.common.ItemBlockGenerator;
import mekanism.generators.common.TileEntitySolarGenerator;
import mekanism.generators.common.network.PacketElectrolyticSeparatorParticle;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="MekanismGenerators", name="MekanismGenerators", version="5.5.6", dependencies="required-after:Mekanism")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class MekanismGenerators
implements IModule {
    @SidedProxy(clientSide="mekanism.generators.client.GeneratorsClientProxy", serverSide="mekanism.generators.common.GeneratorsCommonProxy")
    public static GeneratorsCommonProxy proxy;
    @Mod.Instance(value="MekanismGenerators")
    public static MekanismGenerators instance;
    public static Version versionNumber;
    public static Item BioFuel;
    public static Item ElectrolyticCore;
    public static Item SolarPanel;
    public static Block Generator;
    public static int generatorID;
    public static double advancedSolarGeneration;
    public static double bioGeneration;
    public static double heatGeneration;
    public static double hydrogenGeneration;
    public static double solarGeneration;
    public static double windGeneration;
    public static double electrolyticSeparatorUsage;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        InfuseRegistry.registerInfuseType((InfuseType)new InfuseType("BIO", "/mods/mekanism/infuse/Infusions.png", 12, 0));
    }

    @Mod.Init
    public void init(FMLInitializationEvent event) {
        Mekanism.modulesLoaded.add(this);
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)new GeneratorsGuiHandler());
        proxy.loadConfiguration();
        proxy.registerSpecialTileEntities();
        proxy.registerRenderInformation();
        this.addBlocks();
        this.addItems();
        this.addNames();
        this.addRecipes();
        this.addEntities();
        PacketHandler.registerPacket(PacketElectrolyticSeparatorParticle.class);
        Mekanism.logger.info("[MekanismGenerators] Loaded module.");
    }

    public void addRecipes() {
        CraftingManager.func_77594_a().func_77592_b().add(new MekanismRecipe(new ItemStack(Generator, 1, 0), new Object[]{"PPP", "EeE", "IRI", Character.valueOf('P'), "ingotOsmium", Character.valueOf('E'), Mekanism.EnrichedAlloy, Character.valueOf('e'), Mekanism.EnrichedIron, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('R'), Item.field_77767_aC}));
        CraftingManager.func_77594_a().func_77592_b().add(new MekanismRecipe(new ItemStack(Generator, 1, 1), new Object[]{"SSS", "AIA", "PEP", Character.valueOf('S'), SolarPanel, Character.valueOf('A'), Mekanism.EnrichedAlloy, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('P'), "dustOsmium", Character.valueOf('E'), Mekanism.EnergyTablet.getUnchargedItem()}));
        CraftingManager.func_77594_a().func_77592_b().add(new MekanismRecipe(new ItemStack(Generator, 1, 5), new Object[]{"SES", "SES", "III", Character.valueOf('S'), new ItemStack(Generator, 1, 1), Character.valueOf('E'), Mekanism.EnrichedAlloy, Character.valueOf('I'), Item.field_77703_o}));
        CraftingManager.func_77594_a().func_77592_b().add(new MekanismRecipe(new ItemStack(Generator, 1, 4), new Object[]{"RER", "BCB", "NEN", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('E'), Mekanism.EnrichedAlloy, Character.valueOf('B'), BioFuel, Character.valueOf('C'), "circuitBasic", Character.valueOf('N'), Item.field_77703_o}));
        CraftingManager.func_77594_a().func_77592_b().add(new MekanismRecipe(new ItemStack(Generator, 1, 2), new Object[]{"IRI", "ECE", "IRI", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('E'), Mekanism.EnrichedAlloy, Character.valueOf('C'), ElectrolyticCore}));
        CraftingManager.func_77594_a().func_77592_b().add(new MekanismRecipe(new ItemStack(Generator, 1, 3), new Object[]{"PEP", "ICI", "PEP", Character.valueOf('P'), "ingotOsmium", Character.valueOf('E'), Mekanism.EnrichedAlloy, Character.valueOf('I'), new ItemStack(Mekanism.BasicBlock, 1, 8), Character.valueOf('C'), ElectrolyticCore}));
        CraftingManager.func_77594_a().func_77592_b().add(new MekanismRecipe(new ItemStack(ElectrolyticCore), new Object[]{"EPE", "IEG", "EPE", Character.valueOf('E'), Mekanism.EnrichedAlloy, Character.valueOf('P'), "dustOsmium", Character.valueOf('I'), "dustIron", Character.valueOf('G'), "dustGold"}));
        CraftingManager.func_77594_a().func_77592_b().add(new MekanismRecipe(new ItemStack(SolarPanel), new Object[]{"GGG", "RAR", "PPP", Character.valueOf('G'), Block.field_72003_bq, Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('A'), Mekanism.EnrichedAlloy, Character.valueOf('P'), "ingotOsmium"}));
        CraftingManager.func_77594_a().func_77592_b().add(new MekanismRecipe(new ItemStack(Generator, 1, 6), new Object[]{" O ", "OAO", "ECE", Character.valueOf('O'), "ingotOsmium", Character.valueOf('A'), Mekanism.EnrichedAlloy, Character.valueOf('E'), Mekanism.EnergyTablet.getUnchargedItem(), Character.valueOf('C'), "circuitBasic"}));
        RecipeHandler.addCrusherRecipe((ItemStack)new ItemStack(Block.field_71987_y), (ItemStack)new ItemStack(BioFuel, 2));
        RecipeHandler.addCrusherRecipe((ItemStack)new ItemStack((Block)Block.field_71962_X), (ItemStack)new ItemStack(BioFuel, 4));
        RecipeHandler.addCrusherRecipe((ItemStack)new ItemStack(Item.field_77758_aJ), (ItemStack)new ItemStack(BioFuel, 2));
        RecipeHandler.addCrusherRecipe((ItemStack)new ItemStack(Item.field_77690_S), (ItemStack)new ItemStack(BioFuel, 2));
        RecipeHandler.addCrusherRecipe((ItemStack)new ItemStack(Item.field_77685_T), (ItemStack)new ItemStack(BioFuel, 4));
        RecipeHandler.addCrusherRecipe((ItemStack)new ItemStack(Item.field_77739_bg), (ItemStack)new ItemStack(BioFuel, 2));
        RecipeHandler.addCrusherRecipe((ItemStack)new ItemStack(Item.field_77740_bh), (ItemStack)new ItemStack(BioFuel, 2));
        RecipeHandler.addCrusherRecipe((ItemStack)new ItemStack(Item.field_77706_j), (ItemStack)new ItemStack(BioFuel, 4));
        RecipeHandler.addCrusherRecipe((ItemStack)new ItemStack(Item.field_77684_U), (ItemStack)new ItemStack(BioFuel, 4));
        RecipeHandler.addCrusherRecipe((ItemStack)new ItemStack(Item.field_82794_bL), (ItemStack)new ItemStack(BioFuel, 4));
        RecipeHandler.addCrusherRecipe((ItemStack)new ItemStack(Item.field_82797_bK), (ItemStack)new ItemStack(BioFuel, 4));
        for (int i = 0; i < BlockLeaves.field_72136_a.length; ++i) {
            RecipeHandler.addCrusherRecipe((ItemStack)new ItemStack(Block.field_71987_y, 1, i), (ItemStack)new ItemStack(BioFuel, 2));
        }
        InfuseRegistry.registerInfuseObject((ItemStack)new ItemStack(BioFuel), (InfuseObject)new InfuseObject(InfuseRegistry.get((String)"BIO"), 5));
    }

    public void addNames() {
        LanguageRegistry.addName((Object)BioFuel, (String)"Bio Fuel");
        LanguageRegistry.addName((Object)ElectrolyticCore, (String)"Electrolytic Core");
        LanguageRegistry.addName((Object)SolarPanel, (String)"Solar Panel");
        LanguageRegistry.instance().addStringLocalization("tile.Generator.HeatGenerator.name", "Heat Generator");
        LanguageRegistry.instance().addStringLocalization("tile.Generator.SolarGenerator.name", "Solar Generator");
        LanguageRegistry.instance().addStringLocalization("tile.Generator.ElectrolyticSeparator.name", "Electrolytic Separator");
        LanguageRegistry.instance().addStringLocalization("tile.Generator.HydrogenGenerator.name", "Hydrogen Generator");
        LanguageRegistry.instance().addStringLocalization("tile.Generator.BioGenerator.name", "Bio-Generator");
        LanguageRegistry.instance().addStringLocalization("tile.Generator.AdvancedSolarGenerator.name", "Advanced Solar Generator");
        LanguageRegistry.instance().addStringLocalization("tile.Generator.WindTurbine.name", "Wind Turbine");
    }

    public void addEntities() {
        GameRegistry.registerTileEntity(TileEntitySolarGenerator.class, (String)"SolarGenerator");
    }

    public void addBlocks() {
        Generator = new BlockGenerator(generatorID).func_71864_b("Generator");
        Item.field_77698_e[MekanismGenerators.generatorID] = new ItemBlockGenerator(generatorID - 256, Generator).func_77655_b("Generator");
    }

    public void addItems() {
        Mekanism.configuration.load();
        SolarPanel = new ItemMekanism(Mekanism.configuration.getItem("SolarPanel", 11300).getInt()).func_77655_b("SolarPanel");
        BioFuel = new ItemMekanism(Mekanism.configuration.getItem("BioFuel", 11301).getInt()).func_77655_b("BioFuel");
        ElectrolyticCore = new ItemMekanism(Mekanism.configuration.getItem("ElectrolyticCore", 11302).getInt()).func_77655_b("ElectrolyticCore");
        Mekanism.configuration.save();
        GameRegistry.registerItem((Item)SolarPanel, (String)"SolarPanel");
        GameRegistry.registerItem((Item)BioFuel, (String)"BioFuel");
        GameRegistry.registerItem((Item)ElectrolyticCore, (String)"ElectrolyticCore");
        OreDictionary.registerOre((String)"itemBioFuel", (ItemStack)new ItemStack(BioFuel));
    }

    public Version getVersion() {
        return versionNumber;
    }

    public String getName() {
        return "Generators";
    }

    static {
        versionNumber = new Version(5, 5, 6);
        generatorID = 3005;
    }
}

