/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computer.api.IComputerAccess;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mekanism.client.Sound;
import mekanism.common.ChargeUtils;
import mekanism.common.LiquidSlot;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import mekanism.common.TileEntityElectricBlock;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.TileEntityGenerator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import universalelectricity.core.item.IItemElectric;

public class TileEntityBioGenerator
extends TileEntityGenerator
implements ITankContainer {
    @SideOnly(value=Side.CLIENT)
    public Sound audio;
    public float crushMatrix = 0.0f;
    public LiquidSlot bioFuelSlot;
    public static Map fuels = new HashMap();

    public TileEntityBioGenerator() {
        super("Bio-Generator", 160000.0, MekanismGenerators.bioGeneration * 2.0);
        this.bioFuelSlot = new LiquidSlot(24000, Mekanism.hooks.ForestryBiofuelID);
        this.inventory = new ItemStack[2];
        if (Mekanism.hooks.ForestryLoaded) {
            fuels.put(Mekanism.hooks.ForestryBiofuelID, 16);
        }
    }

    public float getMatrix() {
        float matrix = 0.0f;
        if (this.crushMatrix <= 2.0f) {
            return this.crushMatrix;
        }
        return 2.0f - (this.crushMatrix - 2.0f);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_70331_k.field_72995_K) {
            this.crushMatrix = this.crushMatrix < 4.0f ? (this.crushMatrix += 0.2f) : 0.0f;
        }
        ChargeUtils.charge((int)1, (TileEntityElectricBlock)this);
        if (this.inventory[0] != null) {
            LiquidStack liquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)this.inventory[0]);
            if (liquid != null) {
                int liquidToAdd;
                if (fuels.containsKey(liquid.itemID) && this.bioFuelSlot.liquidStored + (liquidToAdd = liquid.amount * (Integer)fuels.get(liquid.itemID)) <= this.bioFuelSlot.MAX_LIQUID) {
                    this.bioFuelSlot.setLiquid(this.bioFuelSlot.liquidStored + liquidToAdd);
                    if (LiquidContainerRegistry.isBucket((ItemStack)this.inventory[0])) {
                        this.inventory[0] = new ItemStack(Item.field_77788_aw);
                    } else {
                        --this.inventory[0].field_77994_a;
                        if (this.inventory[0].field_77994_a == 0) {
                            this.inventory[0] = null;
                        }
                    }
                }
            } else {
                int fuel = this.getFuel(this.inventory[0]);
                ItemStack prevStack = this.inventory[0].func_77946_l();
                if (fuel > 0) {
                    int fuelNeeded = this.bioFuelSlot.MAX_LIQUID - this.bioFuelSlot.liquidStored;
                    if (fuel <= fuelNeeded) {
                        this.bioFuelSlot.liquidStored += fuel;
                        --this.inventory[0].field_77994_a;
                        if (prevStack.func_77969_a(new ItemStack(Item.field_77775_ay))) {
                            this.inventory[0] = new ItemStack(Item.field_77788_aw);
                        }
                    }
                    if (this.inventory[0].field_77994_a == 0) {
                        this.inventory[0] = null;
                    }
                }
            }
        }
        if (this.canOperate()) {
            if (!this.field_70331_k.field_72995_K) {
                this.setActive(true);
            }
            this.bioFuelSlot.setLiquid(this.bioFuelSlot.liquidStored - 1);
            this.setEnergy(this.electricityStored + MekanismGenerators.bioGeneration);
        } else if (!this.field_70331_k.field_72995_K) {
            this.setActive(false);
        }
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return this.getFuel(itemstack) > 0 || LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)itemstack) != null && fuels.containsKey(LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)itemstack).itemID);
        }
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IElectricItem || itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getReceiveRequest((ItemStack)itemstack).amperes != 0.0;
        }
        return true;
    }

    @Override
    public boolean canOperate() {
        return this.electricityStored < this.MAX_ELECTRICITY && this.bioFuelSlot.liquidStored > 0;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.bioFuelSlot.liquidStored = nbtTags.func_74762_e("bioFuelStored");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74768_a("bioFuelStored", this.bioFuelSlot.liquidStored);
    }

    @Override
    public double getEnvironmentBoost() {
        return 0.0;
    }

    public int getFuel(ItemStack itemstack) {
        return itemstack.field_77993_c == MekanismGenerators.BioFuel.field_77779_bT ? 100 : 0;
    }

    public int getScaledFuelLevel(int i) {
        return this.bioFuelSlot.liquidStored * i / this.bioFuelSlot.MAX_LIQUID;
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (ForgeDirection.getOrientation((int)side) == MekanismUtils.getRight((int)this.facing)) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        return nArray;
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == MekanismUtils.getRight((int)this.facing)) {
            return 1;
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    public boolean canSetFacing(int facing) {
        return facing != 0 && facing != 1;
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.bioFuelSlot.liquidStored = dataStream.readInt();
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.bioFuelSlot.liquidStored);
        return data;
    }

    public String[] getMethodNames() {
        return new String[]{"getStored", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getBioFuel", "getBioFuelNeeded"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.MAX_ELECTRICITY};
            }
            case 3: {
                return new Object[]{this.MAX_ELECTRICITY - this.electricityStored};
            }
            case 4: {
                return new Object[]{this.bioFuelSlot.liquidStored};
            }
            case 5: {
                return new Object[]{this.bioFuelSlot.MAX_LIQUID - this.bioFuelSlot.liquidStored};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return null;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (from != ForgeDirection.getOrientation((int)this.facing) && resource.itemID == Mekanism.hooks.ForestryBiofuelID) {
            int fuelTransfer = 0;
            int attemptTransfer = resource.amount;
            int fuelNeeded = this.bioFuelSlot.MAX_LIQUID - this.bioFuelSlot.liquidStored;
            fuelTransfer = attemptTransfer <= fuelNeeded ? attemptTransfer : fuelNeeded;
            if (doFill) {
                this.bioFuelSlot.setLiquid(this.bioFuelSlot.liquidStored + fuelTransfer);
            }
            return fuelTransfer;
        }
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{new LiquidTank(this.bioFuelSlot.liquidID, this.bioFuelSlot.liquidStored, this.bioFuelSlot.MAX_LIQUID)};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return null;
    }
}

