/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import com.google.common.io.ByteArrayDataInput;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import ic2.api.Direction;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import java.util.Random;
import mekanism.api.EnumGas;
import mekanism.api.GasTransmission;
import mekanism.api.IGasAcceptor;
import mekanism.api.IGasStorage;
import mekanism.api.IStorageTank;
import mekanism.api.IStrictEnergyAcceptor;
import mekanism.api.ITubeConnection;
import mekanism.api.Object3D;
import mekanism.common.ChargeUtils;
import mekanism.common.ISustainedTank;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import mekanism.common.PacketHandler;
import mekanism.common.TileEntityElectricBlock;
import mekanism.common.network.IMekanismPacket;
import mekanism.generators.common.BlockGenerator;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.network.PacketElectrolyticSeparatorParticle;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import universalelectricity.core.item.IItemElectric;

public class TileEntityElectrolyticSeparator
extends TileEntityElectricBlock
implements IGasStorage,
IEnergySink,
ITankContainer,
IPeripheral,
ITubeConnection,
IStrictEnergyAcceptor,
ISustainedTank {
    public LiquidTank waterTank = new LiquidTank(24000);
    public int MAX_GAS = 2400;
    public int oxygenStored;
    public int hydrogenStored;
    public int output = 16;
    public EnumGas outputType;
    public EnumGas dumpType;

    public TileEntityElectrolyticSeparator() {
        super("Electrolytic Separator", BlockGenerator.GeneratorType.ELECTROLYTIC_SEPARATOR.maxEnergy);
        this.inventory = new ItemStack[4];
        this.outputType = EnumGas.HYDROGEN;
        this.dumpType = EnumGas.NONE;
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.field_70331_k.field_72995_K) {
            int rejects;
            int sendingGas;
            LiquidStack liquid;
            ChargeUtils.discharge((int)3, (TileEntityElectricBlock)this);
            if (this.inventory[0] != null && (liquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)this.inventory[0])) != null && liquid.itemID == Block.field_71943_B.field_71990_ca && (this.waterTank.getLiquid() == null || this.waterTank.getLiquid().amount + liquid.amount <= this.waterTank.getCapacity())) {
                this.waterTank.fill(liquid, true);
                if (this.inventory[0].func_77969_a(new ItemStack(Item.field_77786_ax))) {
                    this.inventory[0] = new ItemStack(Item.field_77788_aw);
                } else {
                    --this.inventory[0].field_77994_a;
                    if (this.inventory[0].field_77994_a == 0) {
                        this.inventory[0] = null;
                    }
                }
            }
            if (!this.field_70331_k.field_72995_K) {
                IStorageTank item;
                if (this.inventory[1] != null && this.hydrogenStored > 0 && this.inventory[1].func_77973_b() instanceof IStorageTank && (((IStorageTank)this.inventory[1].func_77973_b()).getGasType(this.inventory[1]) == EnumGas.HYDROGEN || ((IStorageTank)this.inventory[1].func_77973_b()).getGasType(this.inventory[1]) == EnumGas.NONE) && (item = (IStorageTank)this.inventory[1].func_77973_b()).canReceiveGas(this.inventory[1], EnumGas.HYDROGEN)) {
                    sendingGas = 0;
                    if (item.getRate() <= this.hydrogenStored) {
                        sendingGas = item.getRate();
                    } else if (item.getRate() > this.hydrogenStored) {
                        sendingGas = this.hydrogenStored;
                    }
                    rejects = item.addGas(this.inventory[1], EnumGas.HYDROGEN, sendingGas);
                    this.setGas(EnumGas.HYDROGEN, this.hydrogenStored - (sendingGas - rejects), new Object[0]);
                }
                if (this.inventory[2] != null && this.oxygenStored > 0 && this.inventory[2].func_77973_b() instanceof IStorageTank && (((IStorageTank)this.inventory[2].func_77973_b()).getGasType(this.inventory[2]) == EnumGas.OXYGEN || ((IStorageTank)this.inventory[2].func_77973_b()).getGasType(this.inventory[2]) == EnumGas.NONE) && (item = (IStorageTank)this.inventory[2].func_77973_b()).canReceiveGas(this.inventory[2], EnumGas.OXYGEN)) {
                    sendingGas = 0;
                    if (item.getRate() <= this.oxygenStored) {
                        sendingGas = item.getRate();
                    } else if (item.getRate() > this.oxygenStored) {
                        sendingGas = this.oxygenStored;
                    }
                    rejects = item.addGas(this.inventory[2], EnumGas.OXYGEN, sendingGas);
                    this.setGas(EnumGas.OXYGEN, this.oxygenStored - (sendingGas - rejects), new Object[0]);
                }
            }
            if (this.oxygenStored < this.MAX_GAS && this.hydrogenStored < this.MAX_GAS && this.waterTank.getLiquid() != null && this.waterTank.getLiquid().amount - 2 >= 0 && this.electricityStored - 100.0 > 0.0) {
                this.waterTank.drain(2, true);
                this.setEnergy(this.electricityStored - MekanismGenerators.electrolyticSeparatorUsage);
                this.setGas(EnumGas.OXYGEN, this.oxygenStored + 1, new Object[0]);
                this.setGas(EnumGas.HYDROGEN, this.hydrogenStored + 2, new Object[0]);
            }
            if (this.outputType != EnumGas.NONE && this.getGas(this.outputType, new Object[0]) > 0) {
                this.setGas(this.outputType, this.getGas(this.outputType, new Object[0]) - (Math.min(this.getGas(this.outputType, new Object[0]), this.output) - GasTransmission.emitGasToNetwork((EnumGas)this.outputType, (int)Math.min(this.getGas(this.outputType, new Object[0]), this.output), (TileEntity)this, (ForgeDirection)ForgeDirection.getOrientation((int)this.facing))), new Object[0]);
                TileEntity tileEntity = Object3D.get((TileEntity)this).getFromSide(ForgeDirection.getOrientation((int)this.facing)).getTileEntity((IBlockAccess)this.field_70331_k);
                if (tileEntity instanceof IGasAcceptor && ((IGasAcceptor)tileEntity).canReceiveGas(ForgeDirection.getOrientation((int)this.facing).getOpposite(), this.outputType)) {
                    sendingGas = 0;
                    if (this.getGas(this.outputType, new Object[0]) >= this.output) {
                        sendingGas = this.output;
                    } else if (this.getGas(this.outputType, new Object[0]) < this.output) {
                        sendingGas = this.getGas(this.outputType, new Object[0]);
                    }
                    rejects = ((IGasAcceptor)tileEntity).transferGasToAcceptor(sendingGas, this.outputType);
                    this.setGas(this.outputType, this.getGas(this.outputType, new Object[0]) - (sendingGas - rejects), new Object[0]);
                }
            }
            if (this.dumpType != EnumGas.NONE && this.getGas(this.dumpType, new Object[0]) > 0) {
                this.setGas(this.dumpType, this.getGas(this.dumpType, new Object[0]) - 8, new Object[0]);
                if (new Random().nextInt(3) == 2) {
                    PacketHandler.sendPacket((PacketHandler.Transmission)PacketHandler.Transmission.CLIENTS_RANGE, (IMekanismPacket)new PacketElectrolyticSeparatorParticle().setParams(new Object[]{this}), (Object[])new Object[]{Object3D.get((TileEntity)this), 40.0});
                }
            }
        }
    }

    public void spawnParticle() {
        switch (this.facing) {
            case 3: {
                this.field_70331_k.func_72869_a("smoke", (double)this.field_70329_l + 0.1, (double)(this.field_70330_m + 1), (double)this.field_70327_n + 0.25, 0.0, 0.0, 0.0);
                break;
            }
            case 4: {
                this.field_70331_k.func_72869_a("smoke", (double)this.field_70329_l + 0.75, (double)(this.field_70330_m + 1), (double)this.field_70327_n + 0.1, 0.0, 0.0, 0.0);
                break;
            }
            case 2: {
                this.field_70331_k.func_72869_a("smoke", (double)this.field_70329_l + 0.9, (double)(this.field_70330_m + 1), (double)this.field_70327_n + 0.75, 0.0, 0.0, 0.0);
                break;
            }
            case 5: {
                this.field_70331_k.func_72869_a("smoke", (double)this.field_70329_l + 0.25, (double)(this.field_70330_m + 1), (double)this.field_70327_n + 0.9, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 3) {
            return itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getProvideRequest(itemstack).getWatts() > 0.0 || itemstack.func_77973_b() instanceof IElectricItem && ((IElectricItem)itemstack.func_77973_b()).canProvideEnergy(itemstack) && (!(itemstack.func_77973_b() instanceof IItemElectric) || ((IItemElectric)itemstack.func_77973_b()).getProvideRequest(itemstack).getWatts() > 0.0);
        }
        if (slotID == 0) {
            return LiquidContainerRegistry.isEmptyContainer((ItemStack)itemstack);
        }
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IStorageTank && ((IStorageTank)itemstack.func_77973_b()).getGas(EnumGas.HYDROGEN, new Object[]{itemstack}) == ((IStorageTank)itemstack.func_77973_b()).getMaxGas(EnumGas.HYDROGEN, new Object[]{itemstack});
        }
        if (slotID == 2) {
            return itemstack.func_77973_b() instanceof IStorageTank && ((IStorageTank)itemstack.func_77973_b()).getGas(EnumGas.OXYGEN, new Object[]{itemstack}) == ((IStorageTank)itemstack.func_77973_b()).getMaxGas(EnumGas.HYDROGEN, new Object[]{itemstack});
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)itemstack) != null && LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)itemstack).itemID == Block.field_71943_B.field_71990_ca;
        }
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IStorageTank && ((IStorageTank)itemstack.func_77973_b()).getGasType(itemstack) == EnumGas.HYDROGEN || ((IStorageTank)itemstack.func_77973_b()).getGasType(itemstack) == EnumGas.NONE;
        }
        if (slotID == 2) {
            return itemstack.func_77973_b() instanceof IStorageTank && ((IStorageTank)itemstack.func_77973_b()).getGasType(itemstack) == EnumGas.OXYGEN || ((IStorageTank)itemstack.func_77973_b()).getGasType(itemstack) == EnumGas.NONE;
        }
        if (slotID == 3) {
            return itemstack.func_77973_b() instanceof IElectricItem && ((IElectricItem)itemstack.func_77973_b()).canProvideEnergy(itemstack) || itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getProvideRequest((ItemStack)itemstack).amperes != 0.0 || itemstack.field_77993_c == Item.field_77767_aC.field_77779_bT;
        }
        return true;
    }

    public int[] func_94128_d(int side) {
        if (ForgeDirection.getOrientation((int)side) == MekanismUtils.getLeft((int)this.facing)) {
            return new int[]{3};
        }
        if (side == this.facing || ForgeDirection.getOrientation((int)side) == ForgeDirection.getOrientation((int)this.facing).getOpposite()) {
            return new int[]{1, 2};
        }
        return new int[]{0};
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == MekanismUtils.getLeft((int)this.facing)) {
            return 3;
        }
        if (side == ForgeDirection.getOrientation((int)this.facing) || side == ForgeDirection.getOrientation((int)this.facing).getOpposite()) {
            return 1;
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.getOrientation((int)this.facing) || side == ForgeDirection.getOrientation((int)this.facing).getOpposite()) {
            return 2;
        }
        return 1;
    }

    public double transferEnergyToAcceptor(double amount) {
        double rejects = 0.0;
        double neededElectricity = this.MAX_ELECTRICITY - this.electricityStored;
        if (amount <= neededElectricity) {
            this.electricityStored += amount;
        } else {
            this.electricityStored += neededElectricity;
            rejects = amount - neededElectricity;
        }
        return rejects;
    }

    public boolean canReceiveEnergy(ForgeDirection side) {
        return true;
    }

    public int getScaledHydrogenLevel(int i) {
        return this.hydrogenStored * i / this.MAX_GAS;
    }

    public int getScaledOxygenLevel(int i) {
        return this.oxygenStored * i / this.MAX_GAS;
    }

    public int getScaledWaterLevel(int i) {
        return this.waterTank.getLiquid() != null ? this.waterTank.getLiquid().amount * i / this.waterTank.getCapacity() : 0;
    }

    public int getScaledEnergyLevel(int i) {
        return (int)(this.electricityStored * (double)i / this.MAX_ELECTRICITY);
    }

    public void handlePacketData(ByteArrayDataInput dataStream) {
        if (!this.field_70331_k.field_72995_K) {
            byte type = dataStream.readByte();
            if (type == 0) {
                this.outputType = EnumGas.getFromName((String)dataStream.readUTF());
                return;
            }
            if (type == 1) {
                this.dumpType = EnumGas.getFromName((String)dataStream.readUTF());
                return;
            }
        }
        super.handlePacketData(dataStream);
        int amount = dataStream.readInt();
        if (amount != 0) {
            this.waterTank.setLiquid(new LiquidStack(Block.field_71943_B.field_71990_ca, amount, 0));
        } else {
            this.waterTank.setLiquid(null);
        }
        this.oxygenStored = dataStream.readInt();
        this.hydrogenStored = dataStream.readInt();
        this.outputType = EnumGas.getFromName((String)dataStream.readUTF());
        this.dumpType = EnumGas.getFromName((String)dataStream.readUTF());
    }

    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.waterTank.getLiquid() != null) {
            data.add(this.waterTank.getLiquid().amount);
        } else {
            data.add(0);
        }
        data.add(this.oxygenStored);
        data.add(this.hydrogenStored);
        data.add(this.outputType.name);
        data.add(this.dumpType.name);
        return data;
    }

    public int getMaxGas(EnumGas type, Object ... data) {
        return this.MAX_GAS;
    }

    public void setGas(EnumGas type, int amount, Object ... data) {
        if (type == EnumGas.HYDROGEN) {
            this.hydrogenStored = Math.max(Math.min(amount, this.MAX_GAS), 0);
        } else if (type == EnumGas.OXYGEN) {
            this.oxygenStored = Math.max(Math.min(amount, this.MAX_GAS), 0);
        }
    }

    public int getGas(EnumGas type, Object ... data) {
        if (type == EnumGas.HYDROGEN) {
            return this.hydrogenStored;
        }
        if (type == EnumGas.OXYGEN) {
            return this.oxygenStored;
        }
        return 0;
    }

    public int demandsEnergy() {
        return (int)((this.MAX_ELECTRICITY - this.electricityStored) * Mekanism.TO_IC2);
    }

    public int getMaxSafeInput() {
        return 2048;
    }

    public int injectEnergy(Direction direction, int i) {
        double rejects = 0.0;
        double neededEnergy = this.MAX_ELECTRICITY - this.electricityStored;
        if ((double)i <= neededEnergy) {
            this.electricityStored += (double)i;
        } else if ((double)i > neededEnergy) {
            this.electricityStored += neededEnergy;
            rejects = (double)i - neededEnergy;
        }
        return (int)(rejects * Mekanism.TO_IC2);
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return direction.toForgeDirection() != ForgeDirection.getOrientation((int)this.facing);
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (resource.itemID == Block.field_71943_B.field_71990_ca && tankIndex == 0) {
            return this.waterTank.fill(resource, doFill);
        }
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this.waterTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.waterTank;
    }

    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.hydrogenStored = nbtTags.func_74762_e("hydrogenStored");
        this.oxygenStored = nbtTags.func_74762_e("oxygenStored");
        if (nbtTags.func_74764_b("waterTank")) {
            this.waterTank.readFromNBT(nbtTags.func_74775_l("waterTank"));
        }
        this.outputType = EnumGas.getFromName((String)nbtTags.func_74779_i("outputType"));
        this.dumpType = EnumGas.getFromName((String)nbtTags.func_74779_i("dumpType"));
    }

    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74768_a("hydrogenStored", this.hydrogenStored);
        nbtTags.func_74768_a("oxygenStored", this.oxygenStored);
        if (this.waterTank.getLiquid() != null) {
            nbtTags.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        }
        nbtTags.func_74778_a("outputType", this.outputType.name);
        nbtTags.func_74778_a("dumpType", this.dumpType.name);
    }

    public String getType() {
        return this.func_70303_b();
    }

    public String[] getMethodNames() {
        return new String[]{"getStored", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getWater", "getWaterNeeded", "getHydrogen", "getHydrogenNeeded", "getOxygen", "getOxygenNeeded"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.MAX_ELECTRICITY};
            }
            case 3: {
                return new Object[]{this.MAX_ELECTRICITY - this.electricityStored};
            }
            case 4: {
                return new Object[]{this.waterTank.getLiquid() != null ? this.waterTank.getLiquid().amount : 0};
            }
            case 5: {
                return new Object[]{this.waterTank.getLiquid() != null ? this.waterTank.getCapacity() - this.waterTank.getLiquid().amount : 0};
            }
            case 6: {
                return new Object[]{this.hydrogenStored};
            }
            case 7: {
                return new Object[]{this.MAX_GAS - this.hydrogenStored};
            }
            case 8: {
                return new Object[]{this.oxygenStored};
            }
            case 9: {
                return new Object[]{this.MAX_GAS - this.oxygenStored};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
    }

    public void detach(IComputerAccess computer) {
    }

    public boolean canTubeConnect(ForgeDirection side) {
        return side == ForgeDirection.getOrientation((int)this.facing);
    }

    public void setLiquidStack(LiquidStack liquidStack, Object ... data) {
        this.waterTank.setLiquid(liquidStack);
    }

    public LiquidStack getLiquidStack(Object ... data) {
        return this.waterTank.getLiquid();
    }

    public boolean hasTank(Object ... data) {
        return true;
    }
}

