/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerProvider;
import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileSourceEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.tile.IEnergyStorage;
import java.util.ArrayList;
import java.util.EnumSet;
import mekanism.api.ICableOutputter;
import mekanism.api.Object3D;
import mekanism.client.IHasSound;
import mekanism.common.CableUtils;
import mekanism.common.IActiveState;
import mekanism.common.IUniversalCable;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import mekanism.common.PacketHandler;
import mekanism.common.TileEntityElectricBlock;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketTileEntity;
import mekanism.generators.common.MekanismGenerators;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.core.block.IConductor;
import universalelectricity.core.electricity.ElectricityNetworkHelper;
import universalelectricity.core.electricity.IElectricityNetwork;

public abstract class TileEntityGenerator
extends TileEntityElectricBlock
implements IEnergySource,
IEnergyStorage,
IPowerReceptor,
IPeripheral,
IActiveState,
IHasSound,
ICableOutputter {
    public double output;
    public boolean isActive;
    public boolean prevActive;

    public TileEntityGenerator(String name, double maxEnergy, double out) {
        super(name, maxEnergy);
        if (this.powerProvider != null) {
            this.powerProvider.configure(0, 0, 0, 0, (int)(maxEnergy * Mekanism.TO_BC));
        }
        this.output = out;
        this.isActive = false;
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.field_70331_k.field_72995_K) {
            Mekanism.proxy.registerSound((TileEntity)this);
        }
        if (!this.field_70331_k.field_72995_K) {
            ForgeDirection outputDirection;
            IElectricityNetwork outputNetwork;
            TileEntity tileEntity = Object3D.get((TileEntity)this).getFromSide(ForgeDirection.getOrientation((int)this.facing)).getTileEntity((IBlockAccess)this.field_70331_k);
            if (this.electricityStored > 0.0) {
                if (tileEntity instanceof IUniversalCable) {
                    this.setEnergy(this.electricityStored - (Math.min(this.electricityStored, this.output) - CableUtils.emitEnergyToNetwork((double)Math.min(this.electricityStored, this.output), (TileEntity)this, (ForgeDirection)ForgeDirection.getOrientation((int)this.facing))));
                }
                if (!this.field_70331_k.field_72995_K) {
                    if ((tileEntity instanceof IEnergyConductor || tileEntity instanceof IEnergyAcceptor) && Mekanism.hooks.IC2Loaded) {
                        if (this.electricityStored >= this.output) {
                            EnergyTileSourceEvent event = new EnergyTileSourceEvent((IEnergySource)this, (int)(this.output * Mekanism.TO_IC2));
                            MinecraftForge.EVENT_BUS.post((Event)event);
                            this.setEnergy(this.electricityStored - (this.output - (double)event.amount * Mekanism.FROM_IC2));
                        }
                    } else if (this.isPowerReceptor(tileEntity) && Mekanism.hooks.BuildCraftLoaded) {
                        IPowerReceptor receptor = (IPowerReceptor)tileEntity;
                        double electricityNeeded = (double)Math.min((float)receptor.powerRequest(ForgeDirection.getOrientation((int)this.facing).getOpposite()), (float)receptor.getPowerProvider().getMaxEnergyStored() - receptor.getPowerProvider().getEnergyStored()) * Mekanism.FROM_BC;
                        float transferEnergy = (float)Math.min(this.electricityStored, Math.min(electricityNeeded, this.output));
                        receptor.getPowerProvider().receiveEnergy((float)((double)transferEnergy * Mekanism.TO_BC), ForgeDirection.getOrientation((int)this.facing).getOpposite());
                        this.setEnergy(this.electricityStored - (double)transferEnergy);
                    }
                }
            }
            if (!this.field_70331_k.field_72995_K && tileEntity instanceof IConductor && (outputNetwork = ElectricityNetworkHelper.getNetworkFromTileEntity((TileEntity)tileEntity, (ForgeDirection)(outputDirection = ForgeDirection.getOrientation((int)this.facing)))) != null) {
                double outputWatts = Math.min(outputNetwork.getRequest(new TileEntity[0]).getWatts(), Math.min(this.getEnergy(), 10000.0));
                if (this.getEnergy() > 0.0 && outputWatts > 0.0 && this.getEnergy() - outputWatts >= 0.0) {
                    outputNetwork.startProducing((TileEntity)this, outputWatts / this.getVoltage(), this.getVoltage());
                    this.setEnergy(this.electricityStored - outputWatts);
                } else {
                    outputNetwork.stopProducing((TileEntity)this);
                }
            }
        }
    }

    protected EnumSet getConsumingSides() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    public boolean canConnect(ForgeDirection direction) {
        return direction == ForgeDirection.getOrientation((int)this.facing);
    }

    public void func_70313_j() {
        super.func_70313_j();
        if (this.field_70331_k.field_72995_K) {
            Mekanism.proxy.unregisterSound((TileEntity)this);
        }
    }

    public abstract double getEnvironmentBoost();

    public abstract boolean canOperate();

    public boolean isPowerReceptor(TileEntity tileEntity) {
        if (tileEntity instanceof IPowerReceptor) {
            IPowerReceptor receptor = (IPowerReceptor)tileEntity;
            IPowerProvider provider = receptor.getPowerProvider();
            return provider != null && provider.getClass().getSuperclass().equals(PowerProvider.class);
        }
        return false;
    }

    public int getScaledEnergyLevel(int i) {
        return (int)(this.electricityStored * (double)i / this.MAX_ELECTRICITY);
    }

    public boolean getActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
        if (this.prevActive != active) {
            PacketHandler.sendPacket((PacketHandler.Transmission)PacketHandler.Transmission.ALL_CLIENTS, (IMekanismPacket)new PacketTileEntity().setParams(new Object[]{Object3D.get((TileEntity)this), this.getNetworkedData(new ArrayList())}), (Object[])new Object[0]);
        }
        this.prevActive = active;
    }

    public String getType() {
        return this.func_70303_b();
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
    }

    public void detach(IComputerAccess computer) {
    }

    public int getMaxEnergyOutput() {
        return (int)(this.output * Mekanism.TO_IC2);
    }

    public void setFacing(short orientation) {
        super.setFacing(orientation);
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, MekanismGenerators.generatorID);
    }

    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    public boolean emitsEnergyTo(TileEntity receiver, Direction direction) {
        return direction.toForgeDirection() == ForgeDirection.getOrientation((int)this.facing);
    }

    public int getStored() {
        return (int)(this.electricityStored * Mekanism.TO_IC2);
    }

    public int getCapacity() {
        return (int)(this.MAX_ELECTRICITY * Mekanism.TO_IC2);
    }

    public int getOutput() {
        return (int)(this.output * Mekanism.TO_IC2);
    }

    public boolean isTeleporterCompatible(Direction side) {
        return side.toForgeDirection() == ForgeDirection.getOrientation((int)this.facing);
    }

    public int addEnergy(int amount) {
        this.setEnergy(this.electricityStored + (double)amount * Mekanism.FROM_IC2);
        return (int)this.electricityStored;
    }

    public void setStored(int energy) {
        this.setEnergy((double)energy * Mekanism.FROM_IC2);
    }

    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.isActive = dataStream.readBoolean();
        MekanismUtils.updateBlock((World)this.field_70331_k, (int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n);
    }

    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        return data;
    }

    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
    }

    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
    }

    public int powerRequest(ForgeDirection side) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public boolean canOutputTo(ForgeDirection side) {
        return side == ForgeDirection.getOrientation((int)this.facing);
    }

    public String getSoundPath() {
        return this.fullName.replace(" ", "").replace("-", "").replace("Advanced", "") + ".ogg";
    }

    public float getVolumeMultiplier() {
        return 1.0f;
    }

    public boolean hasVisual() {
        return true;
    }
}

