/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import com.google.common.io.ByteArrayDataInput;
import dan200.computer.api.IComputerAccess;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import mekanism.common.ChargeUtils;
import mekanism.common.MekanismUtils;
import mekanism.common.TileEntityElectricBlock;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.TileEntityGenerator;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import universalelectricity.core.item.IItemElectric;

public class TileEntityHeatGenerator
extends TileEntityGenerator
implements ITankContainer {
    public LiquidTank lavaTank = new LiquidTank(24000);

    public TileEntityHeatGenerator() {
        super("Heat Generator", 160000.0, MekanismGenerators.heatGeneration * 2.0);
        this.inventory = new ItemStack[2];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_70331_k.field_72995_K) {
            ChargeUtils.charge((int)1, (TileEntityElectricBlock)this);
            if (this.inventory[0] != null) {
                LiquidStack liquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)this.inventory[0]);
                if (liquid != null && liquid.itemID == Block.field_71938_D.field_71990_ca) {
                    if (this.lavaTank.getLiquid() == null || this.lavaTank.getLiquid().amount + liquid.amount <= this.lavaTank.getCapacity()) {
                        this.lavaTank.fill(liquid, true);
                        if (LiquidContainerRegistry.isBucket((ItemStack)this.inventory[0])) {
                            this.inventory[0] = new ItemStack(Item.field_77788_aw);
                        } else {
                            --this.inventory[0].field_77994_a;
                            if (this.inventory[0].field_77994_a == 0) {
                                this.inventory[0] = null;
                            }
                        }
                    }
                } else {
                    int fuel = this.getFuel(this.inventory[0]);
                    if (fuel > 0) {
                        int fuelNeeded = this.lavaTank.getCapacity() - (this.lavaTank.getLiquid() != null ? this.lavaTank.getLiquid().amount : 0);
                        if (fuel <= fuelNeeded) {
                            this.lavaTank.fill(new LiquidStack(Block.field_71938_D.field_71990_ca, fuel), true);
                            --this.inventory[0].field_77994_a;
                        }
                        if (this.inventory[0].field_77994_a == 0) {
                            this.inventory[0] = null;
                        }
                    }
                }
            }
            this.setEnergy(this.electricityStored + this.getEnvironmentBoost());
            if (this.canOperate()) {
                this.setActive(true);
                this.lavaTank.drain(10, true);
                this.setEnergy(this.electricityStored + MekanismGenerators.heatGeneration);
            } else {
                this.setActive(false);
            }
        }
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return this.getFuel(itemstack) > 0 || LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)itemstack) != null && LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)itemstack).itemID == Block.field_71938_D.field_71990_ca;
        }
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IElectricItem || itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getReceiveRequest((ItemStack)itemstack).amperes != 0.0;
        }
        return true;
    }

    @Override
    public boolean canOperate() {
        return this.electricityStored < this.MAX_ELECTRICITY && this.lavaTank.getLiquid() != null && this.lavaTank.getLiquid().amount >= 10;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        if (nbtTags.func_74764_b("lavaTank")) {
            this.lavaTank.readFromNBT(nbtTags.func_74775_l("lavaTank"));
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        if (this.lavaTank.getLiquid() != null) {
            nbtTags.func_74782_a("lavaTank", (NBTBase)this.lavaTank.writeToNBT(new NBTTagCompound()));
        }
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getReceiveRequest(itemstack).getWatts() == 0.0 || itemstack.func_77973_b() instanceof IElectricItem && (!(itemstack.func_77973_b() instanceof IItemElectric) || ((IItemElectric)itemstack.func_77973_b()).getReceiveRequest(itemstack).getWatts() == 0.0);
        }
        if (slotID == 0) {
            return LiquidContainerRegistry.isEmptyContainer((ItemStack)itemstack);
        }
        return false;
    }

    @Override
    public double getEnvironmentBoost() {
        int boost = 0;
        if (this.field_70331_k.func_72798_a(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n) == 10 || this.field_70331_k.func_72798_a(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n) == 11) {
            boost += 5;
        }
        if (this.field_70331_k.func_72798_a(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n) == 10 || this.field_70331_k.func_72798_a(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n) == 11) {
            boost += 5;
        }
        if (this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n) == 10 || this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n) == 11) {
            boost += 5;
        }
        if (this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) == 10 || this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) == 11) {
            boost += 5;
        }
        if (this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1) == 10 || this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1) == 11) {
            boost += 5;
        }
        if (this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1) == 10 || this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1) == 11) {
            boost += 5;
        }
        return boost;
    }

    public int getFuel(ItemStack itemstack) {
        if (itemstack.field_77993_c == Item.field_77775_ay.field_77779_bT) {
            return 1000;
        }
        return TileEntityFurnace.func_70398_a((ItemStack)itemstack);
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (ForgeDirection.getOrientation((int)side) == MekanismUtils.getRight((int)this.facing)) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        return nArray;
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == MekanismUtils.getRight((int)this.facing)) {
            return 1;
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    public int getScaledFuelLevel(int i) {
        return (this.lavaTank.getLiquid() != null ? this.lavaTank.getLiquid().amount : 0) * i / this.lavaTank.getCapacity();
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        int amount = dataStream.readInt();
        if (amount != 0) {
            this.lavaTank.setLiquid(new LiquidStack(Block.field_71938_D.field_71990_ca, amount, 0));
        } else {
            this.lavaTank.setLiquid(null);
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.lavaTank.getLiquid() != null) {
            data.add(this.lavaTank.getLiquid().amount);
        } else {
            data.add(0);
        }
        return data;
    }

    public String[] getMethodNames() {
        return new String[]{"getStored", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getFuel", "getFuelNeeded"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.MAX_ELECTRICITY};
            }
            case 3: {
                return new Object[]{this.MAX_ELECTRICITY - this.electricityStored};
            }
            case 4: {
                return new Object[]{this.lavaTank.getLiquid() != null ? this.lavaTank.getLiquid().amount : 0};
            }
            case 5: {
                return new Object[]{this.lavaTank.getCapacity() - (this.lavaTank.getLiquid() != null ? this.lavaTank.getLiquid().amount : 0)};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return null;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (from != ForgeDirection.getOrientation((int)this.facing)) {
            return this.fill(0, resource, doFill);
        }
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (resource.itemID == Block.field_71938_D.field_71990_ca && tankIndex == 0) {
            return this.lavaTank.fill(resource, doFill);
        }
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this.lavaTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.lavaTank;
    }
}

