/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import com.google.common.io.ByteArrayDataInput;
import dan200.computer.api.IComputerAccess;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import mekanism.api.EnumGas;
import mekanism.api.IGasAcceptor;
import mekanism.api.IGasStorage;
import mekanism.api.IStorageTank;
import mekanism.api.ITubeConnection;
import mekanism.common.ChargeUtils;
import mekanism.common.MekanismUtils;
import mekanism.common.TileEntityElectricBlock;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.TileEntityGenerator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.item.IItemElectric;

public class TileEntityHydrogenGenerator
extends TileEntityGenerator
implements IGasAcceptor,
IGasStorage,
ITubeConnection {
    public int MAX_HYDROGEN = 18000;
    public int hydrogenStored;

    public TileEntityHydrogenGenerator() {
        super("Hydrogen Generator", 40000.0, MekanismGenerators.hydrogenGeneration * 2.0);
        this.inventory = new ItemStack[2];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_70331_k.field_72995_K) {
            IStorageTank item;
            ChargeUtils.charge((int)1, (TileEntityElectricBlock)this);
            if (this.inventory[0] != null && this.hydrogenStored < this.MAX_HYDROGEN && this.inventory[0].func_77973_b() instanceof IStorageTank && (item = (IStorageTank)this.inventory[0].func_77973_b()).canProvideGas(this.inventory[0], EnumGas.HYDROGEN) && item.getGasType(this.inventory[0]) == EnumGas.HYDROGEN) {
                int received = 0;
                int hydrogenNeeded = this.MAX_HYDROGEN - this.hydrogenStored;
                if (item.getRate() <= hydrogenNeeded) {
                    received = item.removeGas(this.inventory[0], EnumGas.HYDROGEN, item.getRate());
                } else if (item.getRate() > hydrogenNeeded) {
                    received = item.removeGas(this.inventory[0], EnumGas.HYDROGEN, hydrogenNeeded);
                }
                this.setGas(EnumGas.HYDROGEN, this.hydrogenStored + received, new Object[0]);
            }
            if (this.canOperate()) {
                this.setActive(true);
                this.hydrogenStored -= 2;
                this.setEnergy(this.electricityStored + MekanismGenerators.hydrogenGeneration);
            } else {
                this.setActive(false);
            }
        }
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getReceiveRequest(itemstack).getWatts() == 0.0 || itemstack.func_77973_b() instanceof IElectricItem && (!(itemstack.func_77973_b() instanceof IItemElectric) || ((IItemElectric)itemstack.func_77973_b()).getReceiveRequest(itemstack).getWatts() == 0.0);
        }
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IStorageTank && ((IStorageTank)itemstack.func_77973_b()).getGas(EnumGas.NONE, new Object[]{itemstack}) == 0;
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IStorageTank && ((IStorageTank)itemstack.func_77973_b()).getGasType(itemstack) == EnumGas.HYDROGEN;
        }
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IElectricItem || itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getReceiveRequest((ItemStack)itemstack).amperes != 0.0;
        }
        return true;
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (ForgeDirection.getOrientation((int)side) == MekanismUtils.getRight((int)this.facing)) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        return nArray;
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == MekanismUtils.getRight((int)this.facing)) {
            return 1;
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    public void setGas(EnumGas type, int amount, Object ... data) {
        if (type == EnumGas.HYDROGEN) {
            this.hydrogenStored = Math.max(Math.min(amount, this.MAX_HYDROGEN), 0);
        }
    }

    public int getGas(EnumGas type, Object ... data) {
        if (type == EnumGas.HYDROGEN) {
            return this.hydrogenStored;
        }
        return 0;
    }

    @Override
    public boolean canOperate() {
        return this.electricityStored < this.MAX_ELECTRICITY && this.hydrogenStored - 2 > -1;
    }

    public int getScaledHydrogenLevel(int i) {
        return this.hydrogenStored * i / this.MAX_HYDROGEN;
    }

    public String[] getMethodNames() {
        return new String[]{"getStored", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getHydrogen", "getHydrogenNeeded"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.MAX_ELECTRICITY};
            }
            case 3: {
                return new Object[]{this.MAX_ELECTRICITY - this.electricityStored};
            }
            case 4: {
                return new Object[]{this.hydrogenStored};
            }
            case 5: {
                return new Object[]{this.MAX_HYDROGEN - this.hydrogenStored};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return null;
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.hydrogenStored = dataStream.readInt();
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.hydrogenStored);
        return data;
    }

    @Override
    public double getEnvironmentBoost() {
        int boost = 1;
        if (this.field_70330_m > 64 && this.field_70330_m < 80) {
            boost = 2;
        } else if (this.field_70330_m > 80 && this.field_70330_m < 96) {
            boost = 3;
        } else if (this.field_70330_m > 96) {
            boost = 4;
        }
        return boost;
    }

    public double getVoltage() {
        return 240.0;
    }

    public int transferGasToAcceptor(int amount, EnumGas type) {
        if (type == EnumGas.HYDROGEN) {
            int rejects = 0;
            int neededHydrogen = this.MAX_HYDROGEN - this.hydrogenStored;
            if (amount <= neededHydrogen) {
                this.hydrogenStored += amount;
            } else if (amount > neededHydrogen) {
                this.hydrogenStored += neededHydrogen;
                rejects = amount - neededHydrogen;
            }
            return rejects;
        }
        return amount;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.hydrogenStored = nbtTags.func_74762_e("hydrogenStored");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74768_a("hydrogenStored", this.hydrogenStored);
    }

    public boolean canReceiveGas(ForgeDirection side, EnumGas type) {
        return type == EnumGas.HYDROGEN && side != ForgeDirection.getOrientation((int)this.facing);
    }

    public boolean canTubeConnect(ForgeDirection side) {
        return side != ForgeDirection.getOrientation((int)this.facing);
    }

    public int getMaxGas(EnumGas type, Object ... data) {
        if (type == EnumGas.HYDROGEN) {
            return this.MAX_HYDROGEN;
        }
        return 0;
    }
}

