/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import com.google.common.io.ByteArrayDataInput;
import dan200.computer.api.IComputerAccess;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import mekanism.api.Object3D;
import mekanism.common.ChargeUtils;
import mekanism.common.TileEntityElectricBlock;
import mekanism.generators.common.BlockGenerator;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.TileEntityGenerator;
import micdoodle8.mods.galacticraft.API.ISolarLevel;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.item.IItemElectric;

public class TileEntitySolarGenerator
extends TileEntityGenerator {
    public boolean seesSun = false;
    public double GENERATION_RATE;

    public TileEntitySolarGenerator() {
        super("Solar Generator", 96000.0, MekanismGenerators.solarGeneration * 2.0);
        this.GENERATION_RATE = MekanismGenerators.solarGeneration;
        this.inventory = new ItemStack[1];
    }

    public TileEntitySolarGenerator(String name, double maxEnergy, double output, double generation) {
        super(name, maxEnergy, output);
        this.GENERATION_RATE = generation;
        this.inventory = new ItemStack[1];
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    @Override
    public float getVolumeMultiplier() {
        return 0.05f;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    public boolean canSetFacing(int facing) {
        return facing != 0 && facing != 1;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        ChargeUtils.charge((int)0, (TileEntityElectricBlock)this);
        if (!this.field_70331_k.field_72995_K) {
            this.seesSun = this.field_70331_k.func_72935_r() && !this.field_70331_k.func_72896_J() && !this.field_70331_k.func_72911_I() && !this.field_70331_k.field_73011_w.field_76576_e && this.field_70331_k.func_72937_j(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
            for (int y = this.field_70330_m + 1; y < 256; ++y) {
                Object3D obj = new Object3D(this.field_70329_l, y, this.field_70327_n);
                Block block = Block.field_71973_m[obj.getBlockId((IBlockAccess)this.field_70331_k)];
                if (block == null || !block.func_71926_d() && (block.field_71990_ca != MekanismGenerators.generatorID || obj.getMetadata((IBlockAccess)this.field_70331_k) != BlockGenerator.GeneratorType.SOLAR_GENERATOR.meta)) continue;
                this.seesSun = false;
                break;
            }
            if (this.canOperate()) {
                this.setActive(true);
                this.setEnergy(this.electricityStored + this.getEnvironmentBoost());
            } else {
                this.setActive(false);
            }
        }
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getReceiveRequest(itemstack).getWatts() == 0.0 || itemstack.func_77973_b() instanceof IElectricItem && (!(itemstack.func_77973_b() instanceof IItemElectric) || ((IItemElectric)itemstack.func_77973_b()).getReceiveRequest(itemstack).getWatts() == 0.0);
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IElectricItem || itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getReceiveRequest((ItemStack)itemstack).amperes != 0.0;
        }
        return true;
    }

    @Override
    public boolean canOperate() {
        return this.electricityStored < this.MAX_ELECTRICITY && this.seesSun;
    }

    @Override
    public double getEnvironmentBoost() {
        return this.seesSun ? this.GENERATION_RATE * (double)(this.field_70331_k.field_73011_w instanceof ISolarLevel ? (int)((ISolarLevel)this.field_70331_k.field_73011_w).getSolarEnergyMultiplier() : 1) : 0.0;
    }

    public String[] getMethodNames() {
        return new String[]{"getStored", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getSeesSun"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.MAX_ELECTRICITY};
            }
            case 3: {
                return new Object[]{this.MAX_ELECTRICITY - this.electricityStored};
            }
            case 4: {
                return new Object[]{this.seesSun};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return null;
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.seesSun = dataStream.readBoolean();
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.seesSun);
        return data;
    }

    @Override
    public boolean hasVisual() {
        return false;
    }
}

