/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.gui.MFRCreativeTab;
import powercrystals.minefactoryreloaded.setup.MFRConfig;

public class BlockRailPassengerDropoff
extends BlockRailBase {
    public BlockRailPassengerDropoff(int n) {
        super(n, true);
        this.func_71864_b("mfr.rail.passenger.dropoff");
        this.func_71848_c(0.5f);
        this.func_71884_a(Block.field_71977_i);
        this.func_71849_a(MFRCreativeTab.tab);
    }

    public void func_71869_a(World world, int n, int n2, int n3, Entity entity) {
        if (world.field_72995_K || !(entity instanceof EntityMinecartEmpty)) {
            return;
        }
        EntityMinecartEmpty entityMinecartEmpty = (EntityMinecartEmpty)entity;
        if (entityMinecartEmpty.field_70153_n == null || !(entityMinecartEmpty.field_70153_n instanceof EntityPlayer)) {
            return;
        }
        int[] nArray = this.findSpaceForPlayer(n, n2, n3, world);
        if (nArray[1] < 0) {
            return;
        }
        Entity entity2 = entityMinecartEmpty.field_70153_n;
        entity2.func_70078_a((Entity)entityMinecartEmpty);
        MineFactoryReloadedCore.proxy.movePlayerToCoordinates((EntityPlayer)entity2, (double)nArray[0] + 0.5, (double)nArray[1] + 0.5, (double)nArray[2] + 0.5);
    }

    private int[] findSpaceForPlayer(int n, int n2, int n3, World world) {
        int[] nArray = new int[3];
        nArray[1] = -1;
        for (int i = -MFRConfig.passengerRailSearchMaxHorizontal.getInt(); i < MFRConfig.passengerRailSearchMaxHorizontal.getInt(); ++i) {
            for (int j = -MFRConfig.passengerRailSearchMaxVertical.getInt(); j < MFRConfig.passengerRailSearchMaxVertical.getInt(); ++j) {
                for (int k = -MFRConfig.passengerRailSearchMaxHorizontal.getInt(); k < MFRConfig.passengerRailSearchMaxHorizontal.getInt(); ++k) {
                    int n4 = n + i;
                    int n5 = n2 + j;
                    int n6 = n3 + k;
                    if (world.func_72798_a(n4, n5, n6) != 0 || world.func_72798_a(n4, n5 + 1, n6) != 0 || this.isBadBlockToStandOn(world.func_72798_a(n4, n5 - 1, n6))) continue;
                    nArray[0] = n4;
                    nArray[1] = n5;
                    nArray[2] = n6;
                    return nArray;
                }
            }
        }
        return nArray;
    }

    private boolean isBadBlockToStandOn(int n) {
        return n == 0 || Block.field_71973_m[n].field_72018_cp == Material.field_76256_h || Block.field_71973_m[n].field_72018_cp == Material.field_76244_g || Block.field_71973_m[n].field_72018_cp == Material.field_76250_n || Block.field_71973_m[n] instanceof BlockRailBase;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.field_94336_cN = iconRegister.func_94245_a("powercrystals/minefactoryreloaded/" + this.func_71917_a());
    }
}

