/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.rednet.IConnectableRedNet;
import powercrystals.minefactoryreloaded.api.rednet.RedNetConnectionType;
import powercrystals.minefactoryreloaded.core.BlockNBTManager;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.gui.MFRCreativeTab;
import powercrystals.minefactoryreloaded.item.ItemLogicUpgradeCard;
import powercrystals.minefactoryreloaded.item.ItemRedNetMemoryCard;
import powercrystals.minefactoryreloaded.item.ItemRedNetMeter;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetLogic;

public class BlockRedNetLogic
extends BlockContainer
implements IConnectableRedNet {
    private int[] _sideRemap = new int[]{3, 1, 2, 0};

    public BlockRedNetLogic(int n) {
        super(n, Material.field_76267_y);
        this.func_71864_b("mfr.rednet.logic");
        this.func_71848_c(0.8f);
        this.func_71849_a(MFRCreativeTab.tab);
    }

    public void func_71860_a(World world, int n, int n2, int n3, EntityLiving entityLiving, ItemStack itemStack) {
        if (entityLiving == null) {
            return;
        }
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetLogic) {
            int n4 = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            if (n4 == 0) {
                world.func_72921_c(n, n2, n3, 3, 3);
            } else if (n4 == 1) {
                world.func_72921_c(n, n2, n3, 0, 3);
            } else if (n4 == 2) {
                world.func_72921_c(n, n2, n3, 1, 3);
            } else if (n4 == 3) {
                world.func_72921_c(n, n2, n3, 2, 3);
            }
            if (itemStack.func_77942_o()) {
                itemStack.func_77978_p().func_74768_a("x", n);
                itemStack.func_77978_p().func_74768_a("y", n2);
                itemStack.func_77978_p().func_74768_a("z", n3);
                tileEntity.func_70307_a(itemStack.func_77978_p());
            }
        }
    }

    public void func_71852_a(World world, int n, int n2, int n3, int n4, int n5) {
        BlockNBTManager.setForBlock(world.func_72796_p(n, n2, n3));
        super.func_71852_a(world, n, n2, n3, n4, n5);
    }

    public TileEntity func_72274_a(World world) {
        return new TileEntityRedNetLogic();
    }

    @Override
    public RedNetConnectionType getConnectionType(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        TileEntityRedNetLogic tileEntityRedNetLogic = (TileEntityRedNetLogic)world.func_72796_p(n, n2, n3);
        if (tileEntityRedNetLogic != null && forgeDirection.ordinal() > 1 && forgeDirection.ordinal() < 6 && world.func_72805_g(n, n2, n3) == this._sideRemap[forgeDirection.ordinal() - 2]) {
            return RedNetConnectionType.None;
        }
        return RedNetConnectionType.CableAll;
    }

    @Override
    public int getOutputValue(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int n4) {
        TileEntityRedNetLogic tileEntityRedNetLogic = (TileEntityRedNetLogic)world.func_72796_p(n, n2, n3);
        if (tileEntityRedNetLogic != null) {
            return tileEntityRedNetLogic.getOutputValue(forgeDirection, n4);
        }
        return 0;
    }

    @Override
    public int[] getOutputValues(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        TileEntityRedNetLogic tileEntityRedNetLogic = (TileEntityRedNetLogic)world.func_72796_p(n, n2, n3);
        if (tileEntityRedNetLogic != null) {
            return tileEntityRedNetLogic.getOutputValues(forgeDirection);
        }
        return new int[16];
    }

    @Override
    public void onInputsChanged(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int[] nArray) {
        TileEntityRedNetLogic tileEntityRedNetLogic = (TileEntityRedNetLogic)world.func_72796_p(n, n2, n3);
        if (tileEntityRedNetLogic != null) {
            tileEntityRedNetLogic.onInputsChanged(forgeDirection, nArray);
        }
    }

    @Override
    public void onInputChanged(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int n4) {
    }

    public boolean func_71903_a(World world, int n, int n2, int n3, EntityPlayer entityPlayer, int n4, float f, float f2, float f3) {
        PlayerInteractEvent playerInteractEvent = new PlayerInteractEvent(entityPlayer, PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, n, n2, n3, n4);
        if (MinecraftForge.EVENT_BUS.post((Event)playerInteractEvent) || playerInteractEvent.getResult() == Event.Result.DENY || playerInteractEvent.useBlock == Event.Result.DENY) {
            return false;
        }
        if (MFRUtil.isHoldingHammer(entityPlayer)) {
            int n5 = world.func_72805_g(n, n2, n3) + 1;
            if (n5 > 3) {
                n5 = 0;
            }
            world.func_72921_c(n, n2, n3, n5, 3);
            return true;
        }
        if (MFRUtil.isHolding(entityPlayer, ItemLogicUpgradeCard.class)) {
            TileEntityRedNetLogic tileEntityRedNetLogic = (TileEntityRedNetLogic)world.func_72796_p(n, n2, n3);
            if (tileEntityRedNetLogic != null) {
                if (tileEntityRedNetLogic.insertUpgrade(entityPlayer.field_71071_by.func_70448_g().func_77960_j() + 1)) {
                    // empty if block
                }
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                }
                return true;
            }
            return false;
        }
        if (!MFRUtil.isHolding(entityPlayer, ItemRedNetMeter.class) && !MFRUtil.isHolding(entityPlayer, ItemRedNetMemoryCard.class)) {
            entityPlayer.openGui((Object)MineFactoryReloadedCore.instance(), 0, world, n, n2, n3);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.field_94336_cN = iconRegister.func_94245_a("powercrystals/minefactoryreloaded/" + this.func_71917_a());
    }

    public int func_71857_b() {
        return MineFactoryReloadedCore.renderIdRedNetLogic;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean isBlockNormalCube(World world, int n, int n2, int n3) {
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return true;
    }

    public ArrayList getBlockDropped(World world, int n, int n2, int n3, int n4, int n5) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        ItemStack itemStack = new ItemStack(this.func_71885_a(this.field_71990_ca, world.field_73012_v, n5), 1, this.func_71899_b(0));
        itemStack.func_77982_d(BlockNBTManager.getForBlock(n, n2, n3));
        arrayList.add(itemStack);
        return arrayList;
    }
}

