/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

public class ArrayQueue {
    private Object[] _values;
    private int _positionRead;
    private int _positionWrite;

    public ArrayQueue(int n) {
        this._values = new Object[n];
        this._positionRead = 0;
        this._positionWrite = 0;
    }

    private void moveNextRead() {
        ++this._positionRead;
        if (this._positionRead >= this._values.length) {
            this._positionRead = 0;
        }
    }

    private void moveNextWrite() {
        ++this._positionWrite;
        if (this._positionWrite >= this._values.length) {
            this._positionWrite = 0;
        }
    }

    public Object peek() {
        return this._values[this._positionRead];
    }

    public Object pop() {
        Object object = this.peek();
        this.moveNextRead();
        return object;
    }

    public void push(Object object) {
        this._values[this._positionWrite] = object;
        this.moveNextWrite();
    }

    public int size() {
        return this._values.length;
    }

    public void clear() {
        this._positionRead = 0;
        this._positionWrite = 0;
        for (int i = 0; i < this._values.length; ++i) {
            this._values[i] = null;
        }
    }

    public void fill(Object object) {
        for (int i = 0; i < this._values.length; ++i) {
            this._values[i] = object;
        }
    }

    public Object[] toArray(Object[] objectArray) {
        int n = Math.min(objectArray.length, this._values.length);
        for (int i = 0; i < n; ++i) {
            int n2 = this._positionRead + i;
            if (n2 >= this._values.length) {
                n2 -= this._values.length;
            }
            objectArray[i] = this._values[n2];
        }
        return objectArray;
    }
}

