/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.gui.control;

import net.minecraft.client.gui.inventory.GuiContainer;
import powercrystals.core.gui.controls.ButtonOption;
import powercrystals.minefactoryreloaded.gui.client.GuiRedNetLogic;
import powercrystals.minefactoryreloaded.gui.control.LogicButtonType;

public class ButtonLogicBufferSelect
extends ButtonOption {
    private LogicButtonType _buttonType;
    private GuiRedNetLogic _logicScreen;
    private int _pinIndex;
    private boolean _ignoreChanges;

    public ButtonLogicBufferSelect(GuiRedNetLogic guiRedNetLogic, int n, int n2, int n3, LogicButtonType logicButtonType, int n4) {
        super((GuiContainer)guiRedNetLogic, n, n2, 30, 14);
        this._logicScreen = guiRedNetLogic;
        this._buttonType = logicButtonType;
        this._pinIndex = n3;
        char[] cArray = new char[]{'L', 'B', 'R', 'F'};
        char[] cArray2 = new char[4];
        for (int i = 0; i < 4; ++i) {
            cArray2[i + n4 & 3] = cArray[i];
        }
        this._ignoreChanges = true;
        if (this._buttonType == LogicButtonType.Input) {
            this.setValue(0, "I/O D");
            this.setValue(1, "I/O U");
            this.setValue(2, "I/O " + cArray2[2]);
            this.setValue(3, "I/O " + cArray2[0]);
            this.setValue(4, "I/O " + cArray2[1]);
            this.setValue(5, "I/O " + cArray2[3]);
            this.setValue(12, "CNST");
            this.setValue(13, "VARS");
            this.setSelectedIndex(0);
        } else {
            this.setValue(6, "I/O D");
            this.setValue(7, "I/O U");
            this.setValue(8, "I/O " + cArray2[2]);
            this.setValue(9, "I/O " + cArray2[0]);
            this.setValue(10, "I/O " + cArray2[1]);
            this.setValue(11, "I/O " + cArray2[3]);
            this.setValue(13, "VARS");
            this.setValue(14, "NULL");
            this.setSelectedIndex(6);
        }
        this._ignoreChanges = false;
        this.setVisible(false);
    }

    public int getBuffer() {
        return this.getSelectedIndex();
    }

    public void setBuffer(int n) {
        this._ignoreChanges = true;
        this.setSelectedIndex(n);
        this._ignoreChanges = false;
    }

    public void onValueChanged(int n, String string) {
        if (this._ignoreChanges) {
            return;
        }
        if (this._buttonType == LogicButtonType.Input) {
            this._logicScreen.setInputPinMapping(this._pinIndex, n, 0);
        } else {
            this._logicScreen.setOutputPinMapping(this._pinIndex, n, 0);
        }
    }

    public void drawForeground(int n, int n2) {
        if (this.getValue() == null) {
            System.out.println("Buffer selection of " + this.getSelectedIndex() + " on " + (Object)((Object)this._buttonType) + " has null value!");
        }
        super.drawForeground(n, n2);
    }
}

