/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.chococraft;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableCropPlant;
import powercrystals.minefactoryreloaded.modhelpers.chococraft.FertilizableChococraft;
import powercrystals.minefactoryreloaded.modhelpers.chococraft.GrindableChocobo;
import powercrystals.minefactoryreloaded.modhelpers.chococraft.HarvestableChococraft;

@Mod(modid="MineFactoryReloaded|CompatChococraft", name="MFR Compat: Chococraft", version="1.5.1R2.6.4", dependencies="required-after:MineFactoryReloaded;after:chococraft")
@NetworkMod(clientSideRequired=false, serverSideRequired=false)
public class Chococraft {
    @Mod.Init
    public void load(FMLInitializationEvent fMLInitializationEvent) {
        if (!Loader.isModLoaded((String)"chococraft")) {
            FMLLog.info((String)"Chococraft is not available; MFR Chococraft Compat not loaded", (Object[])new Object[0]);
            return;
        }
        try {
            Class<?> clazz = Class.forName("chococraft.common.ModChocoCraft");
            FMLLog.info((String)"Registering Gysahls for Planter/Harvester/Fertilizer", (Object[])new Object[0]);
            int n = ((Block)clazz.getField((String)"gysahlStemBlock").get(null)).field_71990_ca;
            int n2 = ((Item)clazz.getField((String)"gysahlSeedsItem").get(null)).field_77779_bT;
            MFRRegistry.registerPlantable(new PlantableCropPlant(n2, n));
            MFRRegistry.registerHarvestable(new HarvestableChococraft(n));
            MFRRegistry.registerFertilizable(new FertilizableChococraft(n));
            FMLLog.info((String)"Registering Chocobos for Grinder...", (Object[])new Object[0]);
            String[] stringArray = new String[]{"Black", "Blue", "Gold", "Green", "Pink", "Purple", "Red", "White", "Yellow"};
            int n3 = ((Item)clazz.getField((String)"chocoboLegRawItem").get(null)).field_77779_bT;
            int n4 = ((Item)clazz.getField((String)"chocoboFeatherItem").get(null)).field_77779_bT;
            for (String string : stringArray) {
                try {
                    Class<?> clazz2 = Class.forName(String.format("chococraft.common.entities.colours.EntityChocobo%s", string));
                    MFRRegistry.registerGrindable(new GrindableChocobo(clazz2, n3, n4));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FMLLog.warning((String)String.format("Entity class for the %s Chocobo could not be found", string), (Object[])new Object[0]);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            FMLLog.warning((String)"Unable to load support for Chococraft", (Object[])new Object[0]);
            classNotFoundException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

