/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.base;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.core.util.Util;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityGenerator;

public abstract class TileEntityLiquidGenerator
extends TileEntityGenerator
implements ITankContainerBucketable {
    private int _liquidConsumedPerTick;
    private int _powerProducedPerConsumption;
    private int _ticksBetweenConsumption;
    private int _outputPulseSize;
    private int _ticksSinceLastConsumption = 0;
    private int _bufferMax = 1000;
    private int _buffer;
    private LiquidTank _tank;

    public TileEntityLiquidGenerator(int n, int n2, int n3) {
        this._liquidConsumedPerTick = n;
        this._powerProducedPerConsumption = n2;
        this._ticksBetweenConsumption = n3;
        this._outputPulseSize = Machine.BioFuelGenerator.getActivationEnergyMJ() * 10;
        this._tank = new LiquidTank(4000);
    }

    protected abstract LiquidStack getLiquidType();

    public int getBuffer() {
        return this._buffer;
    }

    public void setBuffer(int n) {
        this._buffer = n;
    }

    public int getBufferMax() {
        return this._bufferMax;
    }

    @Override
    public ILiquidTank getTank() {
        return this._tank;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            this.setIsActive(this._buffer > this._outputPulseSize * 2);
            int n = Math.min(this._buffer, this._outputPulseSize);
            this._buffer -= n;
            this._buffer += this.producePower(n);
            if (this._ticksSinceLastConsumption < this._ticksBetweenConsumption) {
                ++this._ticksSinceLastConsumption;
                return;
            }
            this._ticksSinceLastConsumption = 0;
            if (Util.isRedstonePowered((TileEntity)this)) {
                return;
            }
            if (this._tank.getLiquid() == null || this._tank.getLiquid().amount < this._liquidConsumedPerTick || this._bufferMax - this._buffer < this._powerProducedPerConsumption) {
                return;
            }
            this._tank.drain(this._liquidConsumedPerTick, true);
            this._buffer += this._powerProducedPerConsumption;
        }
    }

    @Override
    public boolean allowBucketFill() {
        return true;
    }

    public int fill(ForgeDirection forgeDirection, LiquidStack liquidStack, boolean bl) {
        if (liquidStack == null || liquidStack.itemID != this.getLiquidType().itemID || liquidStack.itemMeta != this.getLiquidType().itemMeta) {
            return 0;
        }
        return this._tank.fill(liquidStack, bl);
    }

    public int fill(int n, LiquidStack liquidStack, boolean bl) {
        return this.fill(ForgeDirection.UNKNOWN, liquidStack, bl);
    }

    public LiquidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public LiquidStack drain(int n, int n2, boolean bl) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection forgeDirection) {
        return new ILiquidTank[]{this._tank};
    }

    public ILiquidTank getTank(ForgeDirection forgeDirection, LiquidStack liquidStack) {
        return this._tank;
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("ticksSinceLastConsumption", this._ticksSinceLastConsumption);
        nBTTagCompound.func_74768_a("buffer", this._buffer);
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        this._ticksSinceLastConsumption = nBTTagCompound.func_74762_e("ticksSinceLastConsumption");
        this._buffer = nBTTagCompound.func_74762_e("buffer");
    }
}

