/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.core.inventory.InventoryManager;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiBlockSmasher;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerBlockSmasher;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityBlockSmasher
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    private LiquidTank _tank = new LiquidTank(4000);
    private int _fortune = 0;
    private ItemStack _lastInput;
    private ItemStack _lastOutput;

    public TileEntityBlockSmasher() {
        super(Machine.BlockSmasher);
    }

    public int func_70302_i_() {
        return 2;
    }

    @Override
    public String func_70303_b() {
        return "Block Smasher";
    }

    @Override
    public String getGuiBackground() {
        return "blocksmasher.png";
    }

    @Override
    public ContainerBlockSmasher getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerBlockSmasher(this, inventoryPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiBlockSmasher(this.getContainer(inventoryPlayer), this);
    }

    @Override
    protected boolean activateMachine() {
        if (this._inventory[0] == null) {
            this.setWorkDone(0);
            return false;
        }
        if (this._lastInput == null || !InventoryManager.stacksEqual((ItemStack)this._lastInput, (ItemStack)this._inventory[0])) {
            this._lastInput = this._inventory[0];
            this._lastOutput = this.getOutput(this._lastInput);
        }
        if (this._lastOutput == null) {
            this.setWorkDone(0);
            return false;
        }
        if (this._fortune > 0 && (this._tank.getLiquid() == null || this._tank.getLiquid().amount < this._fortune)) {
            return false;
        }
        if (this._inventory[1] != null && !InventoryManager.stacksEqual((ItemStack)this._lastOutput, (ItemStack)this._inventory[1])) {
            this.setWorkDone(0);
            return false;
        }
        if (this._inventory[1] != null && this._inventory[1].func_77976_d() - this._inventory[1].field_77994_a < this._lastOutput.field_77994_a) {
            return false;
        }
        this.setWorkDone(this.getWorkDone() + 1);
        this._tank.drain(this._fortune, true);
        if (this.getWorkDone() >= this.getWorkMax()) {
            this.setWorkDone(0);
            this._lastInput = null;
            if (this._inventory[1] == null) {
                this._inventory[1] = this._lastOutput.func_77946_l();
            } else {
                this._inventory[1].field_77994_a += this._lastOutput.field_77994_a;
            }
            --this._inventory[0].field_77994_a;
            if (this._inventory[0].field_77994_a == 0) {
                this._inventory[0] = null;
            }
        }
        return true;
    }

    private ItemStack getOutput(ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ItemBlock)) {
            return null;
        }
        Block block = Block.field_71973_m[itemStack.field_77993_c];
        if (block == null) {
            return null;
        }
        int n = block.func_71885_a(itemStack.func_77960_j(), this.field_70331_k.field_73012_v, this._fortune);
        int n2 = block.func_71899_b(itemStack.func_77960_j());
        int n3 = block.quantityDropped(itemStack.func_77960_j(), this._fortune, this.field_70331_k.field_73012_v);
        if (n3 > 0 && n > 0) {
            return new ItemStack(n, n3, n2);
        }
        return null;
    }

    public int getFortune() {
        return this._fortune;
    }

    public void setFortune(int n) {
        if (n >= 0 && n <= 3) {
            if (this._fortune < n) {
                this.setWorkDone(0);
            }
            this._fortune = n;
        }
    }

    @Override
    public int getEnergyStoredMax() {
        return 16000;
    }

    @Override
    public int getWorkMax() {
        return 60;
    }

    @Override
    public int getIdleTicksMax() {
        return 1;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return n == 0;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return n == 1;
    }

    @Override
    public boolean allowBucketFill() {
        return true;
    }

    public int fill(ForgeDirection forgeDirection, LiquidStack liquidStack, boolean bl) {
        if (liquidStack == null || liquidStack.itemID != LiquidDictionary.getCanonicalLiquid((String)"mobEssence").itemID) {
            return 0;
        }
        return this._tank.fill(liquidStack, bl);
    }

    public int fill(int n, LiquidStack liquidStack, boolean bl) {
        return this.fill(ForgeDirection.UNKNOWN, liquidStack, bl);
    }

    public LiquidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public LiquidStack drain(int n, int n2, boolean bl) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection forgeDirection) {
        return new ILiquidTank[]{this._tank};
    }

    public ILiquidTank getTank(ForgeDirection forgeDirection, LiquidStack liquidStack) {
        if (liquidStack != null && liquidStack.itemID == LiquidDictionary.getCanonicalLiquid((String)"mobEssence").itemID) {
            return this._tank;
        }
        return null;
    }

    @Override
    public ILiquidTank getTank() {
        return this._tank;
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("fortune", this._fortune);
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        this._fortune = nBTTagCompound.func_74762_e("fortune");
    }
}

