/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.core.util.UtilInventory;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryGrindable;
import powercrystals.minefactoryreloaded.api.MobDrop;
import powercrystals.minefactoryreloaded.core.GrinderDamageSource;
import powercrystals.minefactoryreloaded.core.HarvestAreaManager;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryPowered;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryPowered;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityGrinder
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    private HarvestAreaManager _areaManager;
    private LiquidTank _tank;
    private Random _rand;
    private DamageSource _damageSource = new GrinderDamageSource("grinder");

    @Override
    public String getGuiBackground() {
        return "grinder.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiFactoryPowered(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryPowered getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerFactoryPowered(this, inventoryPlayer);
    }

    public TileEntityGrinder() {
        super(Machine.Grinder);
        this._areaManager = new HarvestAreaManager(this, 2, 2, 1);
        this._tank = new LiquidTank(4000);
        this._rand = new Random();
    }

    public Random getRandom() {
        return this._rand;
    }

    @Override
    protected boolean shouldPumpLiquid() {
        return true;
    }

    @Override
    public int getEnergyStoredMax() {
        return 32000;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 200;
    }

    @Override
    public ILiquidTank getTank() {
        return this._tank;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean activateMachine() {
        boolean bl = false;
        List list = this.field_70331_k.func_72872_a(EntityLiving.class, this._areaManager.getHarvestArea().toAxisAlignedBB());
        for (Object e : list) {
            Object object;
            EntityLiving entityLiving;
            if (e instanceof EntityPlayer || e instanceof EntityAgeable && ((EntityAgeable)e).func_70874_b() < 0 || (entityLiving = (EntityLiving)e).func_70630_aN() <= 0) continue;
            for (int i = 0; i < 5; ++i) {
                object = entityLiving.func_71124_b(i);
                if (object == null || !object.func_77942_o()) continue;
                UtilInventory.dropStack((TileEntity)this, (ItemStack)object, (ForgeDirection)this.getDropDirection());
                bl = true;
            }
            if (MFRRegistry.getGrindables().containsKey(entityLiving.getClass())) {
                IFactoryGrindable iFactoryGrindable = (IFactoryGrindable)MFRRegistry.getGrindables().get(entityLiving.getClass());
                object = iFactoryGrindable.grind(this.field_70331_k, entityLiving, this.getRandom());
                if (object != null && object.size() > 0 && WeightedRandom.func_76272_a((Collection)object) > 0) {
                    ItemStack itemStack = ((MobDrop)WeightedRandom.func_76271_a((Random)this._rand, (Collection)object)).getStack();
                    UtilInventory.dropStack((TileEntity)this, (ItemStack)itemStack, (ForgeDirection)this.getDropDirection());
                }
                bl = true;
            }
            if (!bl) continue;
            if (this.field_70331_k.func_82736_K().func_82766_b("doMobLoot")) {
                try {
                    this.field_70331_k.func_82736_K().func_82764_b("doMobLoot", "false");
                    entityLiving.func_70097_a(this._damageSource, 500000);
                }
                finally {
                    this.field_70331_k.func_82736_K().func_82764_b("doMobLoot", "true");
                }
            } else {
                entityLiving.func_70097_a(this._damageSource, 500000);
            }
            this._tank.fill(LiquidDictionary.getLiquid((String)"mobEssence", (int)100), true);
            this.setIdleTicks(20);
            return true;
        }
        this.setIdleTicks(this.getIdleTicksMax());
        return false;
    }

    @Override
    public String func_70303_b() {
        return "Mob Grinder";
    }

    public int func_70302_i_() {
        return 0;
    }

    public int fill(ForgeDirection forgeDirection, LiquidStack liquidStack, boolean bl) {
        return 0;
    }

    public int fill(int n, LiquidStack liquidStack, boolean bl) {
        return 0;
    }

    @Override
    public boolean allowBucketDrain() {
        return true;
    }

    public LiquidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public LiquidStack drain(int n, int n2, boolean bl) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection forgeDirection) {
        return new ILiquidTank[]{this._tank};
    }

    public ILiquidTank getTank(ForgeDirection forgeDirection, LiquidStack liquidStack) {
        return this._tank;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }

    @Override
    public boolean canRotate() {
        return true;
    }
}

