/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.core.position.Area;
import powercrystals.core.position.BlockPosition;
import powercrystals.core.util.UtilInventory;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;
import powercrystals.minefactoryreloaded.core.HarvestAreaManager;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.core.TreeHarvestManager;
import powercrystals.minefactoryreloaded.core.TreeHarvestMode;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiHarvester;
import powercrystals.minefactoryreloaded.gui.container.ContainerHarvester;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityHarvester
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    private Map _settings;
    private Random _rand;
    private HarvestAreaManager _areaManager = new HarvestAreaManager(this, 1, 0, 0);
    private TreeHarvestManager _treeManager;
    private BlockPosition _lastTree;
    private LiquidTank _tank = new LiquidTank(4000);

    public TileEntityHarvester() {
        super(Machine.Harvester);
        this._settings = new HashMap();
        this._settings.put("silkTouch", false);
        this._settings.put("harvestSmallMushrooms", false);
        this._settings.put("harvestJungleWood", false);
        this._rand = new Random();
    }

    @Override
    public String getGuiBackground() {
        return "harvester.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiHarvester(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerHarvester getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerHarvester(this, inventoryPlayer);
    }

    public Map getSettings() {
        return this._settings;
    }

    @Override
    protected boolean shouldPumpLiquid() {
        return true;
    }

    @Override
    public ILiquidTank getTank() {
        return this._tank;
    }

    @Override
    public int getEnergyStoredMax() {
        return 16000;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 5;
    }

    @Override
    protected void onFactoryInventoryChanged() {
        this._areaManager.updateUpgradeLevel(this._inventory[0]);
    }

    @Override
    public boolean activateMachine() {
        int n = 0;
        int n2 = 0;
        BlockPosition blockPosition = this.getNextHarvest();
        if (blockPosition == null) {
            this.setIdleTicks(this.getIdleTicksMax());
            return false;
        }
        n = this.field_70331_k.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z);
        n2 = this.field_70331_k.func_72805_g(blockPosition.x, blockPosition.y, blockPosition.z);
        IFactoryHarvestable iFactoryHarvestable = (IFactoryHarvestable)MFRRegistry.getHarvestables().get(new Integer(n));
        List list = iFactoryHarvestable.getDrops(this.field_70331_k, this._rand, (Map)ImmutableMap.copyOf((Map)this._settings), blockPosition.x, blockPosition.y, blockPosition.z);
        iFactoryHarvestable.preHarvest(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z);
        if (list != null) {
            for (ItemStack itemStack : list) {
                UtilInventory.dropStack((TileEntity)this, (ItemStack)itemStack, (ForgeDirection)this.getDropDirection());
            }
        }
        if (iFactoryHarvestable.breakBlock()) {
            if (MFRConfig.playSounds.getBoolean(true)) {
                this.field_70331_k.func_72889_a(null, 2001, blockPosition.x, blockPosition.y, blockPosition.z, n + (n2 << 12));
            }
            this.field_70331_k.func_94571_i(blockPosition.x, blockPosition.y, blockPosition.z);
        }
        iFactoryHarvestable.postHarvest(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z);
        this._tank.fill(LiquidDictionary.getLiquid((String)"sludge", (int)10), true);
        return true;
    }

    private BlockPosition getNextHarvest() {
        BlockPosition blockPosition = this._areaManager.getNextBlock();
        int n = this.field_70331_k.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z);
        if (!MFRRegistry.getHarvestables().containsKey(new Integer(n))) {
            this._lastTree = null;
            return null;
        }
        IFactoryHarvestable iFactoryHarvestable = (IFactoryHarvestable)MFRRegistry.getHarvestables().get(new Integer(n));
        if (iFactoryHarvestable.canBeHarvested(this.field_70331_k, this._settings, blockPosition.x, blockPosition.y, blockPosition.z)) {
            if (iFactoryHarvestable.getHarvestType() == HarvestType.Normal) {
                this._lastTree = null;
                return blockPosition;
            }
            if (iFactoryHarvestable.getHarvestType() == HarvestType.Column) {
                this._lastTree = null;
                return this.getNextVertical(blockPosition.x, blockPosition.y, blockPosition.z, 0);
            }
            if (iFactoryHarvestable.getHarvestType() == HarvestType.LeaveBottom) {
                this._lastTree = null;
                return this.getNextVertical(blockPosition.x, blockPosition.y, blockPosition.z, 1);
            }
            if (iFactoryHarvestable.getHarvestType() == HarvestType.Tree) {
                BlockPosition blockPosition2 = this.getNextTreeSegment(blockPosition.x, blockPosition.y, blockPosition.z, false);
                if (blockPosition2 != null) {
                    this._areaManager.rewindBlock();
                }
                return blockPosition2;
            }
            if (iFactoryHarvestable.getHarvestType() == HarvestType.TreeFlipped) {
                BlockPosition blockPosition3 = this.getNextTreeSegment(blockPosition.x, blockPosition.y, blockPosition.z, true);
                if (blockPosition3 != null) {
                    this._areaManager.rewindBlock();
                }
                return blockPosition3;
            }
        }
        this._lastTree = null;
        return null;
    }

    private BlockPosition getNextVertical(int n, int n2, int n3, int n4) {
        int n5 = -1;
        int n6 = n4;
        while (n6 < MFRConfig.verticalHarvestSearchMaxVertical.getInt()) {
            int n7 = this.field_70331_k.func_72798_a(n, n2 + n6, n3);
            if (!MFRRegistry.getHarvestables().containsKey(new Integer(n7)) || !((IFactoryHarvestable)MFRRegistry.getHarvestables().get(new Integer(n7))).canBeHarvested(this.field_70331_k, this._settings, n, n2 + n6, n3)) break;
            n5 = n6++;
        }
        if (n5 < 0) {
            return null;
        }
        return new BlockPosition(n, n2 + n5, n3);
    }

    private BlockPosition getNextTreeSegment(int n, int n2, int n3, boolean bl) {
        if (this._lastTree == null || this._lastTree.x != n || this._lastTree.y != n2 || this._lastTree.z != n3) {
            int n4 = bl ? n2 - MFRConfig.treeSearchMaxVertical.getInt() : n2;
            int n5 = bl ? n2 : n2 + MFRConfig.treeSearchMaxVertical.getInt();
            Area area = new Area(n - MFRConfig.treeSearchMaxHorizontal.getInt(), n + MFRConfig.treeSearchMaxHorizontal.getInt(), n4, n5, n3 - MFRConfig.treeSearchMaxHorizontal.getInt(), n3 + MFRConfig.treeSearchMaxHorizontal.getInt());
            this._treeManager = new TreeHarvestManager(area, bl ? TreeHarvestMode.HarvestInverted : TreeHarvestMode.Harvest);
            this._lastTree = new BlockPosition(n, n2, n3);
        } else if (this._treeManager.getIsDone()) {
            this._treeManager.reset();
        }
        while (!this._treeManager.getIsDone()) {
            BlockPosition blockPosition = this._treeManager.getNextBlock();
            int n6 = this.field_70331_k.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z);
            if (MFRRegistry.getHarvestables().containsKey(new Integer(n6)) && ((IFactoryHarvestable)MFRRegistry.getHarvestables().get(new Integer(n6))).canBeHarvested(this.field_70331_k, this._settings, blockPosition.x, blockPosition.y, blockPosition.z)) {
                if (this._treeManager.getIsLeafPass() && ((IFactoryHarvestable)MFRRegistry.getHarvestables().get(new Integer(n6))).getHarvestType() == HarvestType.TreeLeaf) {
                    return blockPosition;
                }
                if (!(this._treeManager.getIsLeafPass() || ((IFactoryHarvestable)MFRRegistry.getHarvestables().get(new Integer(n6))).getHarvestType() != HarvestType.Tree && ((IFactoryHarvestable)MFRRegistry.getHarvestables().get(new Integer(n6))).getHarvestType() != HarvestType.TreeFlipped)) {
                    return blockPosition;
                }
                if (!this._treeManager.getIsLeafPass() && ((IFactoryHarvestable)MFRRegistry.getHarvestables().get(new Integer(n6))).getHarvestType() == HarvestType.TreeLeaf) {
                    this._treeManager.reset();
                    continue;
                }
            }
            this._treeManager.moveNext();
        }
        return null;
    }

    public int fill(ForgeDirection forgeDirection, LiquidStack liquidStack, boolean bl) {
        return 0;
    }

    @Override
    public boolean allowBucketDrain() {
        return true;
    }

    public int fill(int n, LiquidStack liquidStack, boolean bl) {
        return 0;
    }

    public LiquidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public LiquidStack drain(int n, int n2, boolean bl) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection forgeDirection) {
        return new ILiquidTank[]{this._tank};
    }

    public ILiquidTank getTank(ForgeDirection forgeDirection, LiquidStack liquidStack) {
        return this._tank;
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        for (Map.Entry entry : this._settings.entrySet()) {
            nBTTagCompound2.func_74774_a((String)entry.getKey(), (byte)((Boolean)entry.getValue() != false ? 1 : 0));
        }
        nBTTagCompound.func_74782_a("harvesterSettings", (NBTBase)nBTTagCompound2);
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        NBTTagCompound nBTTagCompound2 = (NBTTagCompound)nBTTagCompound.func_74781_a("harvesterSettings");
        if (nBTTagCompound2 != null) {
            for (String string : this._settings.keySet()) {
                byte by = nBTTagCompound2.func_74771_c(string);
                if (by != 1) continue;
                this._settings.put(string, true);
            }
        }
    }

    @Override
    public String func_70303_b() {
        return "Harvester";
    }

    public int func_70302_i_() {
        return 1;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }

    @Override
    public int getStartInventorySide(ForgeDirection forgeDirection) {
        return 0;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return 0;
    }

    @Override
    public boolean canRotate() {
        return true;
    }
}

