/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.util.UtilInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiItemRouter;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerItemRouter;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntityItemRouter
extends TileEntityFactoryInventory {
    protected static final int[] _invOffsets = new int[]{0, 0, 9, 18, 36, 27};
    protected static final ForgeDirection[] _outputDirections = new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};
    private int[] _defaultRoutes = new int[_outputDirections.length];
    private boolean _rejectUnmapped;

    public boolean getRejectUnmapped() {
        return this._rejectUnmapped;
    }

    public void setRejectUnmapped(boolean bl) {
        this._rejectUnmapped = bl;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            for (int i = 45; i < this.func_70302_i_(); ++i) {
                if (this._inventory[i] == null) continue;
                this._inventory[i] = this.routeItem(this._inventory[i]);
            }
        }
    }

    public ItemStack routeItem(ItemStack itemStack) {
        int[] nArray = this.getRoutesForItem(itemStack);
        if (this.hasRoutes(nArray)) {
            return (itemStack = this.weightedRouteItem(itemStack, nArray)) == null || itemStack.field_77994_a == 0 ? null : itemStack;
        }
        if (this.hasRoutes(this._defaultRoutes) && !this._rejectUnmapped) {
            return (itemStack = this.weightedRouteItem(itemStack, this._defaultRoutes)) == null || itemStack.field_77994_a == 0 ? null : itemStack;
        }
        return itemStack;
    }

    private ItemStack weightedRouteItem(ItemStack itemStack, int[] nArray) {
        int n;
        ItemStack itemStack2 = itemStack.func_77946_l();
        if (itemStack.field_77994_a >= this.totalWeight(nArray)) {
            n = itemStack.field_77994_a;
            for (int i = 0; i < nArray.length; ++i) {
                ItemStack itemStack3 = itemStack.func_77946_l();
                itemStack3.field_77994_a = n * nArray[i] / this.totalWeight(nArray);
                if (itemStack3.field_77994_a <= 0) continue;
                ItemStack itemStack4 = UtilInventory.dropStack((TileEntity)this, (ItemStack)itemStack3, (ForgeDirection)_outputDirections[i], (ForgeDirection)_outputDirections[i]);
                itemStack2.field_77994_a = itemStack4 == null ? (itemStack2.field_77994_a -= itemStack3.field_77994_a) : (itemStack2.field_77994_a -= itemStack3.field_77994_a - itemStack4.field_77994_a);
                if (itemStack2.field_77994_a <= 0) break;
            }
        }
        if (0 < itemStack2.field_77994_a && itemStack2.field_77994_a < this.totalWeight(nArray)) {
            n = this.weightedRandomSide(nArray);
            itemStack2 = UtilInventory.dropStack((TileEntity)this, (ItemStack)itemStack2, (ForgeDirection)_outputDirections[n], (ForgeDirection)_outputDirections[n]);
        }
        return itemStack2;
    }

    private int weightedRandomSide(int[] nArray) {
        int n = this.field_70331_k.field_73012_v.nextInt(this.totalWeight(nArray));
        for (int i = 0; i < nArray.length; ++i) {
            if ((n -= nArray[i]) >= 0) continue;
            return i;
        }
        return -1;
    }

    private int totalWeight(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            n += n2;
        }
        return n;
    }

    private boolean hasRoutes(int[] nArray) {
        for (int n : nArray) {
            if (n <= 0) continue;
            return true;
        }
        return false;
    }

    protected int[] getRoutesForItem(ItemStack itemStack) {
        int[] nArray = new int[_outputDirections.length];
        for (int i = 0; i < _outputDirections.length; ++i) {
            int n = _invOffsets[_outputDirections[i].ordinal()];
            nArray[i] = 0;
            for (int j = n; j < n + 9; ++j) {
                if (this._inventory[j] == null || (this._inventory[j].field_77993_c != itemStack.field_77993_c || this._inventory[j].func_77960_j() != itemStack.func_77960_j()) && !itemStack.func_77973_b().func_77645_m()) continue;
                int n2 = i;
                nArray[n2] = nArray[n2] + this._inventory[j].field_77994_a;
            }
        }
        return nArray;
    }

    private void recalculateDefaultRoutes() {
        for (int i = 0; i < _outputDirections.length; ++i) {
            this._defaultRoutes[i] = this.isSideEmpty(_outputDirections[i]) ? 1 : 0;
        }
    }

    public boolean hasRouteForItem(ItemStack itemStack) {
        return this.hasRoutes(this.getRoutesForItem(itemStack));
    }

    private boolean isSideEmpty(ForgeDirection forgeDirection) {
        int n;
        if (forgeDirection == ForgeDirection.UNKNOWN || forgeDirection == ForgeDirection.UP) {
            return false;
        }
        for (int i = n = _invOffsets[forgeDirection.ordinal()]; i < n + 9; ++i) {
            if (this._inventory[i] == null) continue;
            return false;
        }
        return true;
    }

    public int func_70302_i_() {
        return 48;
    }

    @Override
    public boolean shouldDropSlotWhenBroken(int n) {
        return n >= 45;
    }

    public String func_70303_b() {
        return "Item Router";
    }

    @Override
    public String getGuiBackground() {
        return "itemrouter.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiItemRouter((ContainerFactoryInventory)((ContainerItemRouter)this.getContainer(inventoryPlayer)), this);
    }

    @Override
    public ContainerFactoryInventory getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerItemRouter(this, inventoryPlayer);
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public int getStartInventorySide(ForgeDirection forgeDirection) {
        return 45;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return 3;
    }

    @Override
    protected void onFactoryInventoryChanged() {
        this.recalculateDefaultRoutes();
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        this._rejectUnmapped = nBTTagCompound.func_74767_n("rejectUnmapped");
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("rejectUnmapped", this._rejectUnmapped);
    }
}

