/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.core.util.UtilInventory;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.core.MFRLiquidMover;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryPowered;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryPowered;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityWeather
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    private LiquidTank _tank = new LiquidTank(4000);

    public TileEntityWeather() {
        super(Machine.WeatherCollector);
    }

    @Override
    public String getGuiBackground() {
        return "weathercollector.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiFactoryPowered(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryPowered getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerFactoryPowered(this, inventoryPlayer);
    }

    @Override
    public ILiquidTank getTank() {
        return this._tank;
    }

    @Override
    public int getEnergyStoredMax() {
        return 16000;
    }

    @Override
    public int getWorkMax() {
        return 50;
    }

    @Override
    public int getIdleTicksMax() {
        return 600;
    }

    @Override
    public boolean activateMachine() {
        MFRLiquidMover.pumpLiquid((ILiquidTank)this._tank, this);
        if (this.field_70331_k.func_72912_H().func_76059_o() && this.canSeeSky()) {
            BiomeGenBase biomeGenBase = this.field_70331_k.func_72807_a(this.field_70329_l, this.field_70327_n);
            if (!biomeGenBase.func_76738_d() && !biomeGenBase.func_76746_c()) {
                this.setIdleTicks(this.getIdleTicksMax());
                return false;
            }
            this.setWorkDone(this.getWorkDone() + 1);
            if (this.getWorkDone() >= this.getWorkMax()) {
                if (biomeGenBase.func_76743_j() >= 0.15f) {
                    if (this._tank.fill(new LiquidStack(Block.field_71943_B.field_71990_ca, 1000), true) > 0) {
                        this.setWorkDone(0);
                        return true;
                    }
                    this.setWorkDone(this.getWorkMax());
                    return false;
                }
                UtilInventory.dropStack((TileEntity)this, (ItemStack)new ItemStack(Item.field_77768_aD), (ForgeDirection)this.getDropDirection());
                this.setWorkDone(0);
            }
            return true;
        }
        this.setIdleTicks(this.getIdleTicksMax());
        return false;
    }

    @Override
    public ForgeDirection getDropDirection() {
        return ForgeDirection.DOWN;
    }

    private boolean canSeeSky() {
        for (int i = this.field_70330_m + 1; i <= 256; ++i) {
            int n = this.field_70331_k.func_72798_a(this.field_70329_l, i, this.field_70327_n);
            if (Block.field_71973_m[n] == null || Block.field_71973_m[n].isAirBlock(this.field_70331_k, this.field_70329_l, i, this.field_70327_n)) continue;
            return false;
        }
        return true;
    }

    public int fill(ForgeDirection forgeDirection, LiquidStack liquidStack, boolean bl) {
        return 0;
    }

    public int fill(int n, LiquidStack liquidStack, boolean bl) {
        return 0;
    }

    @Override
    public boolean allowBucketDrain() {
        return true;
    }

    public LiquidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public LiquidStack drain(int n, int n2, boolean bl) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection forgeDirection) {
        return new ILiquidTank[]{this._tank};
    }

    public ILiquidTank getTank(ForgeDirection forgeDirection, LiquidStack liquidStack) {
        return this._tank;
    }

    @Override
    public String func_70303_b() {
        return "Weather Collector";
    }

    public int func_70302_i_() {
        return 0;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }
}

