/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.electricity;

public class ElectricityPack
implements Cloneable {
    public double amperes;
    public double voltage;

    public ElectricityPack(double d, double d2) {
        this.amperes = d;
        this.voltage = d2;
    }

    public ElectricityPack() {
        this(0.0, 0.0);
    }

    public static ElectricityPack getFromWatts(double d, double d2) {
        return new ElectricityPack(d / d2, d2);
    }

    public double getWatts() {
        return ElectricityPack.getWatts(this.amperes, this.voltage);
    }

    public double getConductance() {
        return ElectricityPack.getConductance(this.amperes, this.voltage);
    }

    public double getResistance() {
        return ElectricityPack.getResistance(this.amperes, this.voltage);
    }

    public static double getJoules(double d, double d2) {
        return d * d2;
    }

    public static double getJoules(double d, double d2, double d3) {
        return d * d2 * d3;
    }

    public static double getWattsFromJoules(double d, double d2) {
        return d / d2;
    }

    public static double getAmps(double d, double d2) {
        return d / d2;
    }

    public static double getAmps(double d) {
        return d * 3600.0;
    }

    public static double getAmpsFromWattHours(double d, double d2) {
        return ElectricityPack.getWatts(d) / d2;
    }

    public static double getWattHoursFromAmpHours(double d, double d2) {
        return d * d2;
    }

    public static double getAmpHours(double d) {
        return d / 3600.0;
    }

    public static double getWatts(double d, double d2) {
        return d * d2;
    }

    public static double getWatts(double d) {
        return d * 3600.0;
    }

    public static double getWattHours(double d) {
        return d / 3600.0;
    }

    public static double getWattHours(double d, double d2) {
        return ElectricityPack.getWattHours(ElectricityPack.getWatts(d, d2));
    }

    public static double getResistance(double d, double d2) {
        return d2 / d;
    }

    public static double getConductance(double d, double d2) {
        return d / d2;
    }

    public String toString() {
        return "ElectricityPack [Amps:" + this.amperes + " Volts:" + this.voltage + "]";
    }

    public ElectricityPack clone() {
        return new ElectricityPack(this.amperes, this.voltage);
    }

    public boolean isEqual(ElectricityPack electricityPack) {
        return this.amperes == electricityPack.amperes && this.voltage == electricityPack.voltage;
    }
}

