/*
 * Decompiled with CFR 0.152.
 */
package basiccomponents.common.tileentity;

import basiccomponents.common.BasicComponents;
import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.item.ElectricItemHelper;
import universalelectricity.core.item.IItemElectric;
import universalelectricity.prefab.network.IPacketReceiver;
import universalelectricity.prefab.network.PacketManager;
import universalelectricity.prefab.tile.TileEntityElectricityRunnable;

public class TileEntityElectricFurnace
extends TileEntityElectricityRunnable
implements IInventory,
ISidedInventory,
IPacketReceiver {
    public static final double WATTS_PER_TICK = 500.0;
    public static final int PROCESS_TIME_REQUIRED = 130;
    public int processTicks = 0;
    private ItemStack[] containingItems = new ItemStack[3];
    public final Set playersUsing = new HashSet();

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        this.wattsReceived += ElectricItemHelper.dechargeItem(this.containingItems[0], 500.0, this.getVoltage());
        if (!this.field_70331_k.field_72995_K) {
            if (this.canProcess()) {
                if (this.wattsReceived >= 500.0) {
                    if (this.processTicks == 0) {
                        this.processTicks = 130;
                    } else if (this.processTicks > 0) {
                        --this.processTicks;
                        if (this.processTicks < 1) {
                            this.smeltItem();
                            this.processTicks = 0;
                        }
                    } else {
                        this.processTicks = 0;
                    }
                } else {
                    this.processTicks = 0;
                }
                this.wattsReceived = Math.max(this.wattsReceived - 125.0, 0.0);
            } else {
                this.processTicks = 0;
            }
            if (this.ticks % 3L == 0L) {
                for (EntityPlayer player : this.playersUsing) {
                    PacketDispatcher.sendPacketToPlayer((Packet)this.func_70319_e(), (Player)((Player)player));
                }
            }
        }
    }

    @Override
    public boolean canConnect(ForgeDirection direction) {
        return direction == ForgeDirection.getOrientation((int)(this.func_70322_n() - 8 + 2));
    }

    @Override
    public ElectricityPack getRequest() {
        if (this.canProcess()) {
            return new ElectricityPack(500.0 / this.getVoltage(), this.getVoltage());
        }
        return new ElectricityPack();
    }

    public Packet func_70319_e() {
        return PacketManager.getPacket(BasicComponents.CHANNEL, this, new Object[]{this.processTicks, this.disabledTicks});
    }

    @Override
    public void handlePacketData(INetworkManager network, int type, Packet250CustomPayload packet, EntityPlayer player, ByteArrayDataInput dataStream) {
        try {
            this.processTicks = dataStream.readInt();
            this.disabledTicks = dataStream.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean canProcess() {
        if (FurnaceRecipes.func_77602_a().getSmeltingResult(this.containingItems[1]) == null) {
            return false;
        }
        if (this.containingItems[1] == null) {
            return false;
        }
        if (this.containingItems[2] != null) {
            if (!this.containingItems[2].func_77969_a(FurnaceRecipes.func_77602_a().getSmeltingResult(this.containingItems[1]))) {
                return false;
            }
            if (this.containingItems[2].field_77994_a + 1 > 64) {
                return false;
            }
        }
        return true;
    }

    public void smeltItem() {
        if (this.canProcess()) {
            ItemStack resultItemStack = FurnaceRecipes.func_77602_a().getSmeltingResult(this.containingItems[1]);
            if (this.containingItems[2] == null) {
                this.containingItems[2] = resultItemStack.func_77946_l();
            } else if (this.containingItems[2].func_77969_a(resultItemStack)) {
                ++this.containingItems[2].field_77994_a;
            }
            --this.containingItems[1].field_77994_a;
            if (this.containingItems[1].field_77994_a <= 0) {
                this.containingItems[1] = null;
            }
        }
    }

    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70307_a(par1NBTTagCompound);
        this.processTicks = par1NBTTagCompound.func_74762_e("smeltingTicks");
        NBTTagList var2 = par1NBTTagCompound.func_74761_m("Items");
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = (NBTTagCompound)var2.func_74743_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70310_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("smeltingTicks", this.processTicks);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)var2);
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return LanguageRegistry.instance().getStringLocalization("tile.basiccomponents:bcMachine.2.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        return slotID == 1 ? FurnaceRecipes.func_77602_a().getSmeltingResult(itemStack) != null : (slotID == 0 ? itemStack.func_77973_b() instanceof IItemElectric : false);
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 2;
        } else if (side == 1) {
            int[] nArray3 = new int[2];
            nArray3[0] = 0;
            nArray = nArray3;
            nArray3[1] = 1;
        } else {
            int[] nArray4 = new int[1];
            nArray = nArray4;
            nArray4[0] = 0;
        }
        return nArray;
    }

    public boolean func_102007_a(int slotID, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_102008_b(int slotID, ItemStack par2ItemStack, int par3) {
        return slotID == 2;
    }
}

