/*
 * Decompiled with CFR 0.152.
 */
package icbm.core;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.ore.OreGenReplace;

public class GenLiu
extends OreGenReplace {
    public GenLiu(String name, String oreDiectionaryName, ItemStack stack, int replaceID, int minGenerateLevel, int maxGenerateLevel, int amountPerChunk, int amountPerBranch, String harvestTool, int harvestLevel) {
        super(name, oreDiectionaryName, stack, 0, replaceID, maxGenerateLevel, amountPerChunk, amountPerBranch, "pickaxe", 1);
    }

    public GenLiu(String name, String oreDiectionaryName, ItemStack stack, int replaceID, int maxGenerateLevel, int amountPerChunk, int amountPerBranch) {
        this(name, oreDiectionaryName, stack, 0, replaceID, maxGenerateLevel, amountPerChunk, amountPerBranch, "pickaxe", 1);
    }

    @Override
    public void generate(World world, Random random, int varX, int varZ) {
        for (int y = this.minGenerateLevel; y < this.maxGenerateLevel; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    this.generateReplace(world, random, varX + x, y, varZ + z);
                }
            }
        }
    }

    @Override
    public boolean generateReplace(World world, Random rand, int x, int y, int z) {
        if (this.nearLava(world, x, y, z)) {
            this.placeOre(world, rand, x, y, z);
            return true;
        }
        return false;
    }

    private void placeOre(World world, Random rand, int x, int y, int z) {
        Vector3 position = new Vector3(x, y, z);
        for (int amount = 0; amount < this.amountPerBranch; ++amount) {
            Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
            if (block != null && block.isGenMineableReplaceable(world, x, y, z, Block.field_71981_t.field_71990_ca)) {
                world.func_72832_d(x, y, z, this.oreID, this.oreMeta, 2);
            }
            ForgeDirection dir = ForgeDirection.values()[rand.nextInt(6)];
            position.modifyPositionFromSide(dir);
        }
    }

    private boolean nearLava(World world, int x, int y, int z) {
        for (int side = 2; side < 6; ++side) {
            int id;
            Vector3 position = new Vector3(x, y, z);
            ForgeDirection s = ForgeDirection.values()[side];
            position.modifyPositionFromSide(s);
            if (!world.func_72899_e(position.intX(), position.intY(), position.intZ()) || (id = world.func_72798_a(position.intX(), position.intY(), position.intZ())) != Block.field_71938_D.field_71990_ca && id != Block.field_71944_C.field_71990_ca) continue;
            return true;
        }
        for (int j = 0; j < 4; ++j) {
            int id = world.func_72798_a(x, y - j, z);
            if (id == Block.field_71938_D.field_71990_ca || id == Block.field_71944_C.field_71990_ca) {
                return true;
            }
            if (id == 0) continue;
            return false;
        }
        return false;
    }
}

