/*
 * Decompiled with CFR 0.152.
 */
package cofh.util;

import cofh.util.MathHelper;
import cofh.util.inventory.TinyItemStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class ItemUtils {
    public static ItemStack consumeItem(ItemStack theStack) {
        if (theStack.field_77994_a == 1) {
            if (theStack.func_77973_b().func_77634_r()) {
                return theStack.func_77973_b().getContainerItemStack(theStack);
            }
            return null;
        }
        theStack.func_77979_a(1);
        return theStack;
    }

    public static ItemStack findMatchingRecipe(InventoryCrafting inv, World world) {
        ItemStack[] dmgItems = new ItemStack[2];
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null) continue;
            if (dmgItems[0] == null) {
                dmgItems[0] = inv.func_70301_a(i);
                continue;
            }
            dmgItems[1] = inv.func_70301_a(i);
            break;
        }
        if (dmgItems[1] != null && dmgItems[0].field_77993_c == dmgItems[1].field_77993_c && dmgItems[0].field_77994_a == 1 && dmgItems[1].field_77994_a == 1 && Item.field_77698_e[dmgItems[0].field_77993_c].isRepairable()) {
            Item theItem = Item.field_77698_e[dmgItems[0].field_77993_c];
            int var13 = theItem.func_77612_l() - dmgItems[0].func_77952_i();
            int var8 = theItem.func_77612_l() - dmgItems[1].func_77952_i();
            int var9 = var13 + var8 + theItem.func_77612_l() * 5 / 100;
            int var10 = MathHelper.maxI(0, theItem.func_77612_l() - var9);
            return new ItemStack(dmgItems[0].field_77993_c, 1, var10);
        }
        for (int i = 0; i < CraftingManager.func_77594_a().func_77592_b().size(); ++i) {
            IRecipe recipe = (IRecipe)CraftingManager.func_77594_a().func_77592_b().get(i);
            if (!recipe.func_77569_a(inv, world)) continue;
            return recipe.func_77572_b(inv);
        }
        return null;
    }

    public static ItemStack splitStack(IInventory inv, int SlotIndex, int count) {
        ItemStack theStack = inv.func_70301_a(SlotIndex);
        ItemStack returnStack = theStack.func_77979_a(count);
        if (theStack.field_77994_a <= 0) {
            inv.func_70299_a(SlotIndex, null);
        }
        return returnStack;
    }

    public static ItemStack[] cloneInv(ItemStack[] inv) {
        ItemStack[] returnStack = new ItemStack[inv.length];
        for (int i = 0; i < inv.length; ++i) {
            returnStack[i] = inv[i] == null ? null : inv[i].func_77946_l();
        }
        return returnStack;
    }

    public static List cloneInvIntoList(ItemStack[] inv) {
        ArrayList<TinyItemStack> returnList = new ArrayList<TinyItemStack>();
        for (int i = 0; i < inv.length; ++i) {
            returnList.add(new TinyItemStack(inv[i]));
        }
        return returnList;
    }

    public static boolean addItemStackToInventory(ItemStack[] theInv, ItemStack theStack, int startIndex) {
        if (theStack == null) {
            return true;
        }
        int openSlot = -1;
        for (int i = startIndex; i < theInv.length; ++i) {
            if (ItemUtils.isItemEqual(theStack, theInv[i]) && theInv[i].func_77976_d() > theInv[i].field_77994_a) {
                int hold = theInv[i].func_77976_d() - theInv[i].field_77994_a;
                if (hold >= theStack.field_77994_a) {
                    theInv[i].field_77994_a += theStack.field_77994_a;
                    theStack = null;
                    return true;
                }
                theStack.field_77994_a -= hold;
                theInv[i].field_77994_a += hold;
                continue;
            }
            if (theInv[i] != null || openSlot != -1) continue;
            openSlot = i;
        }
        if (theStack != null) {
            if (openSlot > -1) {
                theInv[openSlot] = theStack;
            } else {
                return false;
            }
        }
        return true;
    }

    public static boolean addItemStackToInventory(ItemStack[] theInv, ItemStack theStack) {
        return ItemUtils.addItemStackToInventory(theInv, theStack, 0);
    }

    public static boolean isHoldingContainer(EntityPlayer player) {
        ItemStack theContainer = player.func_71045_bC();
        return LiquidContainerRegistry.isContainer((ItemStack)theContainer);
    }

    public static boolean isHoldingItem(Item theItem, EntityPlayer player) {
        Item equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        return theItem.equals(equipped);
    }

    public static boolean isHoldingItemStack(ItemStack theStack, EntityPlayer player) {
        ItemStack equipped = player.func_71045_bC() != null ? player.func_71045_bC() : null;
        return equipped != null && theStack.func_77969_a(equipped) && ItemStack.func_77970_a((ItemStack)theStack, (ItemStack)equipped);
    }

    public static boolean isItemEqual(ItemStack item1, ItemStack item2) {
        if (item2 == null) {
            return false;
        }
        return item1.field_77993_c == item2.field_77993_c && (item1.func_77960_j() == Short.MAX_VALUE || item2.func_77960_j() == Short.MAX_VALUE || !item1.func_77981_g() || item2.func_77960_j() == item1.func_77960_j());
    }

    public static boolean isItemEqualOre(ItemStack checked, ItemStack source, String oreDict) {
        return ItemUtils.isItemEqual(checked, source) ? true : (oreDict == null ? false : ItemUtils.getOreDictName(checked).equalsIgnoreCase(oreDict));
    }

    public static String getOreDictName(ItemStack stackInSlot) {
        int ID = OreDictionary.getOreID((ItemStack)stackInSlot);
        if (ID == -1) {
            return "";
        }
        return OreDictionary.getOreName((int)ID);
    }

    public static boolean isItemEqual(TinyItemStack item1, TinyItemStack item2) {
        return item1.itemID == item2.itemID && (item1.metadata == Short.MAX_VALUE || item2.metadata == Short.MAX_VALUE || item2.metadata == item1.metadata);
    }

    public static boolean isOreClass(ItemStack theStack, String id) {
        return OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)theStack)).equals(id);
    }

    public static String getOreDictionaryNameForItem(ItemStack theStack) {
        return OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)theStack));
    }

    public static ItemStack getStackFromNBT(NBTTagCompound theTag) {
        if (theTag != null && theTag.func_74764_b("ID")) {
            return new ItemStack(theTag.func_74762_e("ID"), theTag.func_74762_e("StackSize"), theTag.func_74762_e("Damage"));
        }
        return null;
    }

    public static NBTTagCompound getNBTFromStack(ItemStack theStack) {
        if (theStack != null && theStack.field_77994_a > 0) {
            NBTTagCompound newTag = new NBTTagCompound();
            newTag.func_74768_a("ID", theStack.field_77993_c);
            newTag.func_74768_a("StackSize", theStack.field_77994_a);
            newTag.func_74768_a("Damage", theStack.func_77960_j());
            return newTag;
        }
        return null;
    }

    public static void setBoolean(ItemStack theStack, String tag, boolean b) {
        if (theStack.field_77990_d == null) {
            theStack.field_77990_d = new NBTTagCompound();
        }
        theStack.field_77990_d.func_74757_a(tag, b);
    }

    public static boolean getBoolean(ItemStack theStack, String tag, boolean b) {
        if (theStack.field_77990_d == null) {
            theStack.field_77990_d = new NBTTagCompound();
            theStack.field_77990_d.func_74757_a(tag, false);
        }
        return theStack.field_77990_d.func_74767_n(tag);
    }

    public static void setByte(ItemStack theStack, String tag, byte b) {
        if (theStack.field_77990_d == null) {
            theStack.field_77990_d = new NBTTagCompound();
        }
        theStack.field_77990_d.func_74774_a(tag, b);
    }

    public static byte getByte(ItemStack theStack, String tag, byte b) {
        if (theStack.field_77990_d == null) {
            theStack.field_77990_d = new NBTTagCompound();
            theStack.field_77990_d.func_74774_a(tag, (byte)0);
        }
        return theStack.field_77990_d.func_74771_c(tag);
    }

    public static void setInteger(ItemStack theStack, String tag, int i) {
        if (theStack.field_77990_d == null) {
            theStack.field_77990_d = new NBTTagCompound();
        }
        theStack.field_77990_d.func_74768_a(tag, i);
    }

    public static int getInteger(ItemStack theStack, String tag, int i) {
        if (theStack.field_77990_d == null) {
            theStack.field_77990_d = new NBTTagCompound();
            theStack.field_77990_d.func_74768_a(tag, 0);
        }
        return theStack.field_77990_d.func_74762_e(tag);
    }
}

