/*
 * Decompiled with CFR 0.152.
 */
package cofh.util.liquid;

import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;

public class LiquidTankAdv
implements ILiquidTank {
    private LiquidStack liquid;
    private int capacity;
    private int pressure;
    private boolean locked;

    public LiquidTankAdv(int capacity) {
        this(new LiquidStack(0, 0), capacity);
    }

    public LiquidTankAdv(int liquidId, int quantity, int capacity) {
        this(new LiquidStack(liquidId, quantity), capacity);
    }

    public LiquidTankAdv(LiquidStack liquid, int capacity) {
        this.liquid = liquid;
        this.capacity = capacity;
    }

    public void setLiquid(LiquidStack liquid) {
        if (liquid == null || liquid.amount <= 0) {
            this.liquid = new LiquidStack(0, 0, 0);
            return;
        }
        this.liquid = liquid;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setTankPressure(int pressure) {
        this.pressure = pressure;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setLiquidID(int itemID) {
        this.liquid = new LiquidStack(itemID, this.liquid.amount, this.liquid.itemMeta);
    }

    public void setLiquidAmount(int amount) {
        this.liquid.amount = amount;
    }

    public void setLiquidMeta(int itemMeta) {
        this.liquid = new LiquidStack(this.liquid.itemID, this.liquid.amount, itemMeta);
    }

    public LiquidStack getLiquidNoCopy() {
        return this.liquid;
    }

    public void adjustLiquid(int quantity) {
        this.liquid.amount += quantity;
    }

    public int getLiquidID() {
        return this.liquid.itemID;
    }

    public int getLiquidAmount() {
        return this.liquid.amount;
    }

    public int getLiquidMeta() {
        return this.liquid.itemMeta;
    }

    public LiquidStack getLiquid() {
        return this.liquid.copy();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getTankPressure() {
        return this.pressure;
    }

    public int fill(LiquidStack resource, boolean doFill) {
        if (resource == null || resource.itemID <= 0) {
            return 0;
        }
        if (this.liquid.itemID <= 0) {
            if (resource.amount <= this.capacity) {
                if (doFill) {
                    this.liquid = resource.copy();
                }
                return resource.amount;
            }
            if (doFill) {
                this.liquid = resource.copy();
                this.liquid.amount = this.capacity;
            }
            return this.capacity;
        }
        if (!this.liquid.isLiquidEqual(resource)) {
            return 0;
        }
        int space = this.capacity - this.liquid.amount;
        if (resource.amount <= space) {
            if (doFill) {
                this.liquid.amount += resource.amount;
            }
            return resource.amount;
        }
        if (doFill) {
            this.liquid.amount = this.capacity;
        }
        return space;
    }

    public LiquidStack drain(int maxDrain, boolean doDrain) {
        if (this.liquid.itemID <= 0 || this.liquid.amount <= 0) {
            return null;
        }
        int used = maxDrain;
        if (this.liquid.amount < used) {
            used = this.liquid.amount;
        }
        if (doDrain) {
            this.liquid.amount -= used;
        }
        LiquidStack drained = new LiquidStack(this.liquid.itemID, used, this.liquid.itemMeta);
        if (this.liquid.amount <= 0) {
            if (this.locked) {
                this.liquid.amount = 0;
            } else {
                this.liquid = new LiquidStack(0, 0);
            }
        }
        return drained;
    }
}

