/*
 * Decompiled with CFR 0.152.
 */
package cofh.world.feature;

import cofh.api.world.WeightedRandomBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenMinableCluster
extends WorldGenerator {
    private List cluster;
    private int genClusterSize;
    private int genBlockID;

    public WorldGenMinableCluster(ItemStack ore, int clusterSize) {
        this.genBlockID = Block.field_71981_t.field_71990_ca;
        this.cluster = new ArrayList();
        this.cluster.add(new WeightedRandomBlock(ore));
        this.genClusterSize = clusterSize;
    }

    public WorldGenMinableCluster(WeightedRandomBlock resource, int clusterSize) {
        this.genBlockID = Block.field_71981_t.field_71990_ca;
        this.cluster = new ArrayList();
        this.cluster.add(resource);
        this.genClusterSize = clusterSize;
    }

    public WorldGenMinableCluster(List resource, int clusterSize) {
        this.genBlockID = Block.field_71981_t.field_71990_ca;
        this.cluster = resource;
        this.genClusterSize = clusterSize;
    }

    public WorldGenMinableCluster(ItemStack ore, int clusterSize, int blockID) {
        this.genBlockID = Block.field_71981_t.field_71990_ca;
        this.cluster = new ArrayList();
        this.cluster.add(new WeightedRandomBlock(ore, 1));
        this.genClusterSize = clusterSize;
        this.genBlockID = blockID;
    }

    public WorldGenMinableCluster(WeightedRandomBlock resource, int clusterSize, int blockID) {
        this.genBlockID = Block.field_71981_t.field_71990_ca;
        this.cluster = new ArrayList();
        this.cluster.add(resource);
        this.genClusterSize = clusterSize;
        this.genBlockID = blockID;
    }

    public WorldGenMinableCluster(List resource, int clusterSize, int blockID) {
        this.genBlockID = Block.field_71981_t.field_71990_ca;
        this.cluster = resource;
        this.genClusterSize = clusterSize;
        this.genBlockID = blockID;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        float f = rand.nextFloat() * (float)Math.PI;
        double d0 = (float)(x + 8) + MathHelper.func_76126_a((float)f) * (float)this.genClusterSize / 8.0f;
        double d1 = (float)(x + 8) - MathHelper.func_76126_a((float)f) * (float)this.genClusterSize / 8.0f;
        double d2 = (float)(z + 8) + MathHelper.func_76134_b((float)f) * (float)this.genClusterSize / 8.0f;
        double d3 = (float)(z + 8) - MathHelper.func_76134_b((float)f) * (float)this.genClusterSize / 8.0f;
        double d4 = y + rand.nextInt(3) - 2;
        double d5 = y + rand.nextInt(3) - 2;
        for (int l = 0; l <= this.genClusterSize; ++l) {
            double d6 = d0 + (d1 - d0) * (double)l / (double)this.genClusterSize;
            double d7 = d4 + (d5 - d4) * (double)l / (double)this.genClusterSize;
            double d8 = d2 + (d3 - d2) * (double)l / (double)this.genClusterSize;
            double d9 = rand.nextDouble() * (double)this.genClusterSize / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)this.genClusterSize)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)this.genClusterSize)) + 1.0f) * d9 + 1.0;
            int i1 = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
            int j1 = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int k1 = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
            int l1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
            int i2 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int j2 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
            for (int k2 = i1; k2 <= l1; ++k2) {
                double d12 = ((double)k2 + 0.5 - d6) / (d10 / 2.0);
                if (!(d12 * d12 < 1.0)) continue;
                for (int l2 = j1; l2 <= i2; ++l2) {
                    double d13 = ((double)l2 + 0.5 - d7) / (d11 / 2.0);
                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                    for (int i3 = k1; i3 <= j2; ++i3) {
                        double d14 = ((double)i3 + 0.5 - d8) / (d10 / 2.0);
                        Block block = Block.field_71973_m[world.func_72798_a(k2, l2, i3)];
                        if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0) || block == null || !block.isGenMineableReplaceable(world, k2, l2, i3, this.genBlockID)) continue;
                        WeightedRandomBlock ore = (WeightedRandomBlock)WeightedRandom.func_76271_a((Random)world.field_73012_v, (Collection)this.cluster);
                        world.func_72832_d(k2, l2, i3, ore.blockId, ore.metadata, 1);
                    }
                }
            }
        }
        return true;
    }
}

