/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.gates;

import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IActionProvider;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerProvider;
import buildcraft.api.transport.IPipe;
import java.util.LinkedList;

public class ActionManager {
    public static ITrigger[] triggers = new ITrigger[1024];
    public static IAction[] actions = new IAction[1024];
    private static LinkedList triggerProviders = new LinkedList();
    private static LinkedList actionProviders = new LinkedList();

    public static void registerTriggerProvider(ITriggerProvider provider) {
        if (provider != null && !triggerProviders.contains(provider)) {
            triggerProviders.add(provider);
        }
    }

    public static LinkedList getNeighborTriggers(apa block, aqp entity) {
        LinkedList<ITrigger> triggers = new LinkedList<ITrigger>();
        for (ITriggerProvider provider : triggerProviders) {
            LinkedList toAdd = provider.getNeighborTriggers(block, entity);
            if (toAdd == null) continue;
            for (ITrigger t2 : toAdd) {
                if (triggers.contains(t2)) continue;
                triggers.add(t2);
            }
        }
        return triggers;
    }

    public static void registerActionProvider(IActionProvider provider) {
        if (provider != null && !actionProviders.contains(provider)) {
            actionProviders.add(provider);
        }
    }

    public static LinkedList getNeighborActions(apa block, aqp entity) {
        LinkedList<IAction> actions = new LinkedList<IAction>();
        for (IActionProvider provider : actionProviders) {
            LinkedList toAdd = provider.getNeighborActions(block, entity);
            if (toAdd == null) continue;
            for (IAction t2 : toAdd) {
                if (actions.contains(t2)) continue;
                actions.add(t2);
            }
        }
        return actions;
    }

    public static LinkedList getPipeTriggers(IPipe pipe) {
        LinkedList<ITrigger> triggers = new LinkedList<ITrigger>();
        for (ITriggerProvider provider : triggerProviders) {
            LinkedList toAdd = provider.getPipeTriggers(pipe);
            if (toAdd == null) continue;
            for (ITrigger t2 : toAdd) {
                if (triggers.contains(t2)) continue;
                triggers.add(t2);
            }
        }
        return triggers;
    }
}

