/*
 * Decompiled with CFR 0.152.
 */
package com.overminddl1.mods.NMT;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class NMTMaterial {
    protected FloatBuffer ambient;
    protected FloatBuffer diffuse;
    protected FloatBuffer specular;
    protected FloatBuffer emission;
    protected float shininess;
    protected String mapAmbient;
    public String name;
    protected static NMTMaterial defaultMaterial = new NMTMaterial("");

    public NMTMaterial(String matName) {
        this.name = matName;
        this.ambient = null;
        this.diffuse = null;
        this.specular = null;
        this.emission = null;
        this.shininess = 0.0f;
        this.mapAmbient = null;
    }

    public void setAmbient(float r, float g, float b, float a) {
        this.ambient = this.toFloatBuffer(new float[]{r, g, b, a});
    }

    public void setDiffuse(float r, float g, float b, float a) {
        this.diffuse = this.toFloatBuffer(new float[]{r, g, b, a});
    }

    public void setSpecular(float r, float g, float b, float a) {
        this.specular = this.toFloatBuffer(new float[]{r, g, b, a});
    }

    public void setEmission(float r, float g, float b, float a) {
        this.emission = this.toFloatBuffer(new float[]{r, g, b, a});
    }

    public void setShininess(float s) {
        this.shininess = s;
    }

    protected FloatBuffer toFloatBuffer(float[] flt) {
        FloatBuffer fltBuf = BufferUtils.createFloatBuffer((int)flt.length);
        fltBuf.put(flt);
        fltBuf.flip();
        return fltBuf;
    }

    public void setMaterial() {
        if (this.ambient != null) {
            GL11.glMaterial((int)1032, (int)4608, (FloatBuffer)this.ambient);
        }
        if (this.diffuse != null) {
            GL11.glMaterial((int)1032, (int)4609, (FloatBuffer)this.diffuse);
        }
        if (this.specular != null) {
            GL11.glMaterial((int)1032, (int)4610, (FloatBuffer)this.specular);
        }
        if (this.emission != null) {
            GL11.glMaterialf((int)1032, (int)5633, (float)this.shininess);
        }
    }

    public void resetMaterial() {
        defaultMaterial.setMaterial();
    }

    static {
        defaultMaterial.setAmbient(0.2f, 0.2f, 0.2f, 1.0f);
        defaultMaterial.setDiffuse(0.8f, 0.8f, 0.8f, 1.0f);
        defaultMaterial.setSpecular(0.0f, 0.0f, 0.0f, 1.0f);
        defaultMaterial.setEmission(0.0f, 0.0f, 0.0f, 1.0f);
        defaultMaterial.setShininess(0.0f);
    }
}

