/*
 * Decompiled with CFR 0.152.
 */
package com.overminddl1.mods.NMT;

import com.overminddl1.mods.NMT.NMTModelBase;
import com.overminddl1.mods.NMT.NMTModelRenderer;
import com.overminddl1.mods.NMT.NMTPolygon;
import com.overminddl1.mods.NMT.NMTVertex;

public class NMTModelSphere
extends NMTModelBase {
    private float xPos;
    private float yPos;
    private float zPos;
    private float radius;
    private int slice;
    private int stack;
    private int textureW;
    private int textureH;
    private boolean calcNormals;
    private int mapping;
    private float texW;
    private float texH;
    private float segW;
    private float segH;
    private float startU;
    private float startV;
    private static float pi = (float)Math.PI;

    public NMTModelSphere(NMTModelRenderer nmtmodelrenderer, float x, float y, float z, float r, int slices, int stacks, int tW, int tH) {
        this(nmtmodelrenderer, x, y, z, r, slices, stacks, tW, tH, false);
    }

    public NMTModelSphere(NMTModelRenderer nmtmodelrenderer, float x, float y, float z, float r, int slices, int stacks, int tW, int tH, int mappingUsed) {
        this(nmtmodelrenderer, x, y, z, r, slices, stacks, tW, tH, false, mappingUsed);
    }

    public NMTModelSphere(NMTModelRenderer nmtmodelrenderer, float x, float y, float z, float r, int slices, int stacks, int tW, int tH, boolean cN) {
        this(nmtmodelrenderer, x, y, z, r, slices, stacks, tW, tH, cN, 0);
    }

    public NMTModelSphere(NMTModelRenderer nmtmodelrenderer, float x, float y, float z, float r, int slices, int stacks, int tW, int tH, boolean cN, int mappingUsed) {
        super(nmtmodelrenderer);
        this.xPos = x;
        this.yPos = y;
        this.zPos = z;
        this.radius = r;
        this.slice = slices;
        if (this.slice < 3) {
            this.slice = 3;
        }
        this.stack = stacks;
        if (this.stack < 1) {
            this.stack = 1;
        }
        this.textureW = tW;
        this.textureH = tH;
        this.calcNormals = cN;
        this.mapping = mappingUsed;
        this.texW = (float)this.textureW / this.renderer.a - 0.03125f;
        this.texH = (float)this.textureH / this.renderer.b - 0.03125f;
        this.segW = this.texW / (float)this.slice;
        this.segH = this.texH / (float)(this.stack + 1);
        this.startU = (float)this.renderer.textureU / this.renderer.a + 0.015625f;
        this.startV = (float)this.renderer.textureV / this.renderer.b + 0.015625f;
    }

    @Override
    public NMTModelBase create() {
        int i;
        int[] verts;
        int j;
        NMTVertex vert = new NMTVertex(this.xPos, this.yPos - this.radius, this.zPos);
        if (this.calcNormals) {
            vert.setNormals(arc.a((double)0.0, (double)-1.0, (double)0.0));
        }
        this.vertices.add(vert);
        for (j = 0; j < this.stack; ++j) {
            for (int i2 = 0; i2 < this.slice; ++i2) {
                float yWidth = kx.b((float)(-pi / 2.0f + pi / (float)(this.stack + 1) * (float)(j + 1)));
                float yHeight = kx.a((float)(-pi / 2.0f + pi / (float)(this.stack + 1) * (float)(j + 1)));
                float xSize = kx.a((float)(pi / (float)this.slice * (float)i2 * 2.0f + pi)) * yWidth;
                float zSize = -kx.b((float)(pi / (float)this.slice * (float)i2 * 2.0f + pi)) * yWidth;
                vert = new NMTVertex(this.xPos + xSize * this.radius * (float)(this.renderer.i ? -1 : 1), this.yPos + yHeight * this.radius, this.zPos + zSize * this.radius);
                if (this.calcNormals) {
                    vert.setNormals(arc.a((double)(xSize * (float)(this.renderer.i ? -1 : 1)), (double)yHeight, (double)zSize));
                }
                this.vertices.add(vert);
                if (i2 <= 0) continue;
                verts = new int[4];
                verts[2] = i2 + j * this.slice;
                verts[3] = verts[2] + 1;
                verts[0] = verts[2] - this.slice;
                verts[1] = verts[0] + 1;
                if (j == 0) {
                    verts[0] = 0;
                    verts[1] = 0;
                }
                float[] uv = this.getTexCoords(i2, j);
                this.addQuad(verts[1], verts[0], verts[2], verts[3], uv[0], uv[1], uv[2], uv[3]);
            }
            verts = new int[4];
            verts[0] = this.slice * j;
            verts[2] = verts[0] + this.slice;
            verts[3] = verts[0] + 1;
            verts[1] = verts[3] - this.slice;
            if (j == 0) {
                verts[0] = 0;
                verts[1] = 0;
            }
            float[] uv = this.getTexCoords(this.slice, j);
            this.addQuad(verts[1], verts[0], verts[2], verts[3], uv[0], uv[1], uv[2], uv[3]);
        }
        vert = new NMTVertex(this.xPos, this.yPos + this.radius, this.zPos);
        if (this.calcNormals) {
            vert.setNormals(arc.a((double)0.0, (double)1.0, (double)0.0));
        }
        this.vertices.add(vert);
        j = this.vertices.size() - 1;
        for (i = 0; i < this.slice; ++i) {
            verts = new int[]{j - this.slice + i, j - this.slice + (i + 1) % this.slice, j, j};
            float[] uv = this.getTexCoords(i + 1, this.stack);
            this.addQuad(verts[1], verts[0], verts[2], verts[3], uv[0], uv[1], uv[2], uv[3]);
        }
        if (this.renderer.i) {
            this.flipFaces();
        }
        if (this.calcNormals) {
            for (i = 0; i < this.polygons.size(); ++i) {
                ((NMTPolygon)this.polygons.get((int)i)).indivNormal = true;
            }
        }
        return this;
    }

    protected float[] getTexCoords(int cSlice, int cStack) {
        float[] coords = new float[4];
        switch (this.mapping) {
            case 1: {
                int tSt = this.stack + 1;
                int center = (int)Math.ceil((double)this.stack / 2.0);
                int poles = (int)Math.floor((double)(tSt - center) / 2.0);
                center += tSt - center - 2 * poles;
                if (cStack < poles) {
                    float xC = this.texW * 0.375f;
                    float yC = this.texH / 4.0f;
                    float tW = this.texW / 8.0f;
                    float tH = yC;
                    float x1 = -((float)Math.sin(pi / (float)this.slice * 2.0f * (float)(cSlice - 1)));
                    float y1 = (float)Math.cos(pi / (float)this.slice * 2.0f * (float)(cSlice - 1));
                    float x2 = -((float)Math.sin(pi / (float)this.slice * 2.0f * (float)(cSlice % this.slice)));
                    float y2 = (float)Math.cos(pi / (float)this.slice * 2.0f * (float)(cSlice % this.slice));
                    float s1 = (float)cStack / (float)poles;
                    float s2 = (float)(cStack + 1) / (float)poles;
                    float l1 = Math.abs(y1);
                    float l2 = Math.abs(y2);
                    if (Math.abs(x1) > l1) {
                        l1 = Math.abs(x1);
                    }
                    if (Math.abs(x2) > l2) {
                        l2 = Math.abs(x2);
                    }
                    x1 = x1 / l1 * s1;
                    y1 = y1 / l1 * s1;
                    x2 = x2 / l2 * s2;
                    y2 = y2 / l2 * s2;
                    coords[0] = this.startU + xC + x1 * tW;
                    coords[1] = this.startV + yC + y1 * tH;
                    coords[2] = this.startU + xC + x2 * tW;
                    coords[3] = this.startV + yC + y2 * tH;
                    break;
                }
                if (cStack < center + poles) {
                    float x2;
                    float x1;
                    float tS = this.texH / 2.0f;
                    float tW = this.texW;
                    float tH = tS;
                    int sBr = (int)Math.floor((double)this.slice / 8.0);
                    if (this.slice < 8) {
                        tW = (float)((double)tW * 0.75);
                        x1 = tW * (float)(cSlice - 1) / (float)this.slice;
                        x2 = tW * (float)cSlice / (float)this.slice;
                    } else if (cSlice > sBr) {
                        x1 = (tW *= 0.875f) * (float)(cSlice - sBr - 1) / (float)(this.slice - sBr);
                        x2 = tW * (float)(cSlice - sBr) / (float)(this.slice - sBr);
                    } else {
                        x1 = tW * 0.875f + tW * 0.125f * (float)(cSlice - 1) / (float)sBr;
                        x2 = tW * 0.875f + tW * 0.125f * (float)cSlice / (float)sBr;
                    }
                    float s1 = (float)(cStack - poles) / (float)center;
                    float s2 = (float)(cStack + 1 - poles) / (float)center;
                    coords[0] = this.startU + x1;
                    coords[1] = this.startV + tS + tH * s1;
                    coords[2] = this.startU + x2;
                    coords[3] = this.startV + tS + tH * s2;
                    break;
                }
                float xC = this.texW * 0.625f;
                float yC = this.texH / 4.0f;
                float tW = this.texW / 8.0f;
                float tH = yC;
                float x1 = -((float)Math.sin(pi / (float)this.slice * 2.0f * (float)(cSlice - 1)));
                float y1 = (float)Math.cos(pi / (float)this.slice * 2.0f * (float)(cSlice - 1));
                float x2 = -((float)Math.sin(pi / (float)this.slice * 2.0f * (float)(cSlice % this.slice)));
                float y2 = (float)Math.cos(pi / (float)this.slice * 2.0f * (float)(cSlice % this.slice));
                float s1 = (float)(this.stack - cStack + 1) / (float)poles;
                float s2 = (float)(this.stack - cStack) / (float)poles;
                float l1 = Math.abs(y1);
                float l2 = Math.abs(y2);
                if (Math.abs(x1) > l1) {
                    l1 = Math.abs(x1);
                }
                if (Math.abs(x2) > l2) {
                    l2 = Math.abs(x2);
                }
                x1 = x1 / l1 * s1;
                y1 = y1 / l1 * s1;
                x2 = x2 / l2 * s2;
                y2 = y2 / l2 * s2;
                coords[0] = this.startU + xC + x1 * tW;
                coords[1] = this.startV + yC + y1 * tH;
                coords[2] = this.startU + xC + x2 * tW;
                coords[3] = this.startV + yC + y2 * tH;
                break;
            }
            case 2: {
                float yH1 = kx.a((float)(-pi / 2.0f + pi / (float)(this.stack + 1) * (float)cStack));
                float yH2 = kx.a((float)(-pi / 2.0f + pi / (float)(this.stack + 1) * (float)(cStack + 1)));
                yH1 = (yH1 + 1.0f) / 2.0f;
                yH2 = (yH2 + 1.0f) / 2.0f;
                coords[0] = this.startU + (float)(cSlice - 1) * this.segW;
                coords[1] = this.startV + yH1 * this.texH;
                coords[2] = this.startU + (float)cSlice * this.segW;
                coords[3] = this.startV + yH2 * this.texH;
                break;
            }
            case 3: {
                float yW1 = kx.b((float)(-pi / 2.0f + pi / (float)(this.stack + 1) * (float)cStack));
                float yW2 = kx.b((float)(-pi / 2.0f + pi / (float)(this.stack + 1) * (float)(cStack + 1)));
                float s1 = (1.0f - yW1) * this.texW / 2.0f;
                float s2 = (1.0f - yW2) * this.texW / 2.0f;
                coords[0] = this.startU + s1 + (float)(cSlice - 1) * this.segW * yW1;
                coords[1] = this.startV + (float)cStack * this.segH;
                coords[2] = this.startU + s2 + (float)cSlice * this.segW * yW2;
                coords[3] = this.startV + (float)(cStack + 1) * this.segH;
                break;
            }
            default: {
                coords[0] = this.startU + (float)(cSlice - 1) * this.segW;
                coords[1] = this.startV + (float)cStack * this.segH;
                coords[2] = this.startU + (float)cSlice * this.segW;
                coords[3] = this.startV + (float)(cStack + 1) * this.segH;
            }
        }
        return coords;
    }
}

