/*
 * Decompiled with CFR 0.152.
 */
package com.overminddl1.mods.NMT;

import com.overminddl1.mods.NMT.NMTModelBase;
import com.overminddl1.mods.NMT.NMTModelRenderer;
import com.overminddl1.mods.NMT.NMTVertex;

public class NMTModelVoxel
extends NMTModelBase {
    protected float xPos;
    protected float yPos;
    protected float zPos;
    protected float width;
    protected float height;
    protected float depth;
    protected int relativeU;
    protected int relativeV;

    public NMTModelVoxel(NMTModelRenderer nmtmodelrenderer, float x, float y, float z, float w, float h, float d) {
        this(nmtmodelrenderer, x, y, z, w, h, d, 0, 0);
    }

    public NMTModelVoxel(NMTModelRenderer nmtmodelrenderer, float x, float y, float z, float w, float h, float d, int u, int v) {
        super(nmtmodelrenderer);
        this.xPos = x;
        this.yPos = y;
        this.zPos = z;
        this.width = w;
        this.height = h;
        this.depth = d;
        this.relativeU = u;
        this.relativeV = v;
    }

    @Override
    public NMTModelVoxel create() {
        float x1 = this.xPos;
        float y1 = this.yPos;
        float z1 = this.zPos;
        float x2 = x1 + this.width;
        float y2 = y1 + this.height;
        float z2 = z1 + this.depth;
        this.vertices.add(new NMTVertex(x1, y1, z1));
        this.vertices.add(new NMTVertex(x2, y1, z1));
        this.vertices.add(new NMTVertex(x2, y2, z1));
        this.vertices.add(new NMTVertex(x1, y2, z1));
        this.vertices.add(new NMTVertex(x1, y1, z2));
        this.vertices.add(new NMTVertex(x2, y1, z2));
        this.vertices.add(new NMTVertex(x2, y2, z2));
        this.vertices.add(new NMTVertex(x1, y2, z2));
        this.createVoxel(new int[]{0, 1, 2, 3, 4, 5, 6, 7}, this.relativeU, this.relativeV);
        return this;
    }

    protected void createVoxel(int[] vert, int relU, int relV) {
        float u = (float)this.renderer.textureU + (float)relU;
        float v = (float)this.renderer.textureV + (float)relV;
        float texW = this.renderer.a;
        float texH = this.renderer.b;
        float u1 = u / (texW + 0.015625f);
        float v1 = v / (texH + 0.015625f);
        float u2 = (u + 1.0f) / (texW - 0.015625f);
        float v2 = (v + 1.0f) / (texH - 0.015625f);
        this.addQuad(vert[5], vert[1], vert[2], vert[6], u1, v1, u2, v2);
        this.addQuad(vert[0], vert[4], vert[7], vert[3], u1, v1, u2, v2);
        this.addQuad(vert[5], vert[4], vert[0], vert[1], u1, v1, u2, v2);
        this.addQuad(vert[2], vert[3], vert[7], vert[6], u1, v1, u2, v2);
        this.addQuad(vert[1], vert[0], vert[3], vert[2], u1, v1, u2, v2);
        this.addQuad(vert[4], vert[5], vert[6], vert[7], u1, v1, u2, v2);
    }
}

