/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.EnumGas;
import mekanism.api.GasTransmission;
import mekanism.api.IGasAcceptor;
import mekanism.api.IGasStorage;
import mekanism.api.IPressurizedTube;
import mekanism.api.Object3D;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.ChunkEvent;

public class GasNetwork {
    public Set tubes = new HashSet();
    public Set possibleAcceptors = new HashSet();
    public Map acceptorDirections = new HashMap();

    public GasNetwork(IPressurizedTube ... varPipes) {
        this.tubes.addAll(Arrays.asList(varPipes));
    }

    public int emit(int gasToSend, EnumGas transferType, aqp emitter) {
        List<Object> availableAcceptors = Arrays.asList(this.getGasAcceptors(transferType).toArray());
        Collections.shuffle(availableAcceptors);
        int prevSending = gasToSend;
        if (!availableAcceptors.isEmpty()) {
            int divider = availableAcceptors.size();
            int remaining = gasToSend % divider;
            int sending = (gasToSend - remaining) / divider;
            for (Object obj : availableAcceptors) {
                if (!(obj instanceof IGasAcceptor) || obj == emitter) continue;
                IGasAcceptor acceptor = (IGasAcceptor)obj;
                int currentSending = sending;
                if (remaining > 0) {
                    ++currentSending;
                    --remaining;
                }
                gasToSend -= currentSending - acceptor.transferGasToAcceptor(currentSending, transferType);
            }
        }
        if (prevSending > gasToSend && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            MinecraftForge.EVENT_BUS.post((Event)new GasTransferEvent(this, transferType));
        }
        return gasToSend;
    }

    public Set getGasAcceptors(EnumGas transferType) {
        HashSet<IGasAcceptor> toReturn = new HashSet<IGasAcceptor>();
        for (IGasAcceptor acceptor : this.possibleAcceptors) {
            if (!acceptor.canReceiveGas(((ForgeDirection)this.acceptorDirections.get(acceptor)).getOpposite(), transferType) || acceptor instanceof IGasStorage && (!(acceptor instanceof IGasStorage) || ((IGasStorage)((Object)acceptor)).getMaxGas(transferType, new Object[0]) - ((IGasStorage)((Object)acceptor)).getGas(transferType, new Object[0]) <= 0)) continue;
            toReturn.add(acceptor);
        }
        return toReturn;
    }

    public void refresh() {
        Iterator it = this.tubes.iterator();
        this.possibleAcceptors.clear();
        this.acceptorDirections.clear();
        while (it.hasNext()) {
            IPressurizedTube conductor = (IPressurizedTube)it.next();
            if (conductor == null) {
                it.remove();
                continue;
            }
            if (((aqp)conductor).r()) {
                it.remove();
                continue;
            }
            conductor.setNetwork(this);
        }
        for (IPressurizedTube pipe : this.tubes) {
            IGasAcceptor[] acceptors;
            for (IGasAcceptor acceptor : acceptors = GasTransmission.getConnectedAcceptors((aqp)pipe)) {
                if (acceptor == null || acceptor instanceof IPressurizedTube) continue;
                this.possibleAcceptors.add(acceptor);
                this.acceptorDirections.put(acceptor, ForgeDirection.getOrientation((int)Arrays.asList(acceptors).indexOf(acceptor)));
            }
        }
    }

    public void merge(GasNetwork network) {
        if (network != null && network != this) {
            GasNetwork newNetwork = new GasNetwork(new IPressurizedTube[0]);
            newNetwork.tubes.addAll(this.tubes);
            newNetwork.tubes.addAll(network.tubes);
            newNetwork.refresh();
        }
    }

    public void split(IPressurizedTube splitPoint) {
        if (splitPoint instanceof aqp) {
            this.tubes.remove(splitPoint);
            aqp[] connectedBlocks = new aqp[6];
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                aqp sideTile = Object3D.get((aqp)splitPoint).getFromSide(direction).getTileEntity((aak)((aqp)splitPoint).k);
                if (sideTile == null) continue;
                connectedBlocks[Arrays.asList(ForgeDirection.values()).indexOf((Object)direction)] = sideTile;
            }
            for (int countOne = 0; countOne < connectedBlocks.length; ++countOne) {
                aqp connectedBlockA = connectedBlocks[countOne];
                if (!(connectedBlockA instanceof IPressurizedTube)) continue;
                for (int countTwo = 0; countTwo < connectedBlocks.length; ++countTwo) {
                    aqp connectedBlockB = connectedBlocks[countTwo];
                    if (connectedBlockA == connectedBlockB || !(connectedBlockB instanceof IPressurizedTube)) continue;
                    NetworkFinder finder = new NetworkFinder(((aqp)splitPoint).k, Object3D.get(connectedBlockB), Object3D.get((aqp)splitPoint));
                    if (finder.foundTarget(Object3D.get(connectedBlockA))) {
                        for (Object3D node : finder.iterated) {
                            aqp nodeTile = node.getTileEntity((aak)((aqp)splitPoint).k);
                            if (!(nodeTile instanceof IPressurizedTube) || nodeTile == splitPoint) continue;
                            ((IPressurizedTube)nodeTile).setNetwork(this);
                        }
                        continue;
                    }
                    GasNetwork newNetwork = new GasNetwork(new IPressurizedTube[0]);
                    for (Object3D node : finder.iterated) {
                        aqp nodeTile = node.getTileEntity((aak)((aqp)splitPoint).k);
                        if (!(nodeTile instanceof IPressurizedTube) || nodeTile == splitPoint) continue;
                        newNetwork.tubes.add((IPressurizedTube)nodeTile);
                    }
                    newNetwork.refresh();
                }
            }
        }
    }

    public String toString() {
        return "[GasNetwork] " + this.tubes.size() + " pipes, " + this.possibleAcceptors.size() + " acceptors.";
    }

    public static class NetworkLoader {
        @ForgeSubscribe
        public void onChunkLoad(ChunkEvent.Load event) {
            if (event.getChunk() != null) {
                for (Object obj : event.getChunk().i.values()) {
                    aqp tileEntity;
                    if (!(obj instanceof aqp) || !((tileEntity = (aqp)obj) instanceof IPressurizedTube)) continue;
                    ((IPressurizedTube)tileEntity).refreshNetwork();
                }
            }
        }
    }

    public static class GasTransferEvent
    extends Event {
        public final GasNetwork gasNetwork;
        public final EnumGas transferType;

        public GasTransferEvent(GasNetwork network, EnumGas type) {
            this.gasNetwork = network;
            this.transferType = type;
        }
    }

    public static class NetworkFinder {
        public aab worldObj;
        public Object3D toFind;
        public List iterated = new ArrayList();
        public List toIgnore = new ArrayList();

        public NetworkFinder(aab world, Object3D target, Object3D ... ignore) {
            this.worldObj = world;
            this.toFind = target;
            if (ignore != null) {
                this.toIgnore = Arrays.asList(ignore);
            }
        }

        public void loopThrough(Object3D location) {
            this.iterated.add(location);
            if (this.iterated.contains(this.toFind)) {
                return;
            }
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                aqp tileEntity;
                Object3D obj = location.getFromSide(direction);
                if (this.iterated.contains(obj) || this.toIgnore.contains(obj) || !((tileEntity = obj.getTileEntity((aak)this.worldObj)) instanceof IPressurizedTube) || !((IPressurizedTube)tileEntity).canTransferGas()) continue;
                this.loopThrough(obj);
            }
        }

        public boolean foundTarget(Object3D start) {
            this.loopThrough(start);
            return this.iterated.contains(this.toFind);
        }
    }
}

