/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import java.util.HashSet;
import mekanism.api.EnumGas;
import mekanism.api.GasNetwork;
import mekanism.api.IGasAcceptor;
import mekanism.api.IPressurizedTube;
import mekanism.api.ITubeConnection;
import mekanism.api.Object3D;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;

public final class GasTransmission {
    private static boolean networkLoader_loaded = false;

    public static void register() {
        if (!networkLoader_loaded) {
            MinecraftForge.EVENT_BUS.register((Object)new GasNetwork.NetworkLoader());
            networkLoader_loaded = true;
            System.out.println("[Mekanism] Successfully loaded gas transmission NetworkLoader.");
        }
    }

    public static aqp[] getConnectedTubes(aqp tileEntity) {
        aqp[] tubes = new aqp[]{null, null, null, null, null, null};
        if (!(tileEntity instanceof IPressurizedTube) || ((IPressurizedTube)tileEntity).canTransferGas()) {
            for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
                aqp tube = Object3D.get(tileEntity).getFromSide(orientation).getTileEntity((aak)tileEntity.k);
                if (tileEntity instanceof IPressurizedTube) {
                    if (!((IPressurizedTube)tileEntity).canTransferGasToTube(tube)) continue;
                    tubes[orientation.ordinal()] = tube;
                    continue;
                }
                if (!(tube instanceof IPressurizedTube) || !((IPressurizedTube)tube).canTransferGas()) continue;
                tubes[orientation.ordinal()] = tube;
            }
        }
        return tubes;
    }

    public static IGasAcceptor[] getConnectedAcceptors(aqp tileEntity) {
        IGasAcceptor[] acceptors = new IGasAcceptor[]{null, null, null, null, null, null};
        if (!(tileEntity instanceof IPressurizedTube) || ((IPressurizedTube)tileEntity).canTransferGas()) {
            for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
                aqp acceptor = Object3D.get(tileEntity).getFromSide(orientation).getTileEntity((aak)tileEntity.k);
                if (!(acceptor instanceof IGasAcceptor)) continue;
                acceptors[orientation.ordinal()] = (IGasAcceptor)acceptor;
            }
        }
        return acceptors;
    }

    public static ITubeConnection[] getConnections(aqp tileEntity) {
        ITubeConnection[] connections = new ITubeConnection[]{null, null, null, null, null, null};
        if (!(tileEntity instanceof IPressurizedTube) || ((IPressurizedTube)tileEntity).canTransferGas()) {
            for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
                aqp connection = Object3D.get(tileEntity).getFromSide(orientation).getTileEntity((aak)tileEntity.k);
                if (!(connection instanceof ITubeConnection)) continue;
                connections[orientation.ordinal()] = (ITubeConnection)connection;
            }
        }
        return connections;
    }

    public static int emitGasToNetwork(EnumGas type, int amount, aqp sender, ForgeDirection facing) {
        aqp pointer = Object3D.get(sender).getFromSide(facing).getTileEntity((aak)sender.k);
        if (pointer instanceof IPressurizedTube) {
            return ((IPressurizedTube)pointer).getNetwork().emit(amount, type, sender);
        }
        return amount;
    }

    public static int emitGasFromAllSides(EnumGas type, int amount, aqp pointer) {
        if (pointer != null) {
            HashSet<GasNetwork> networks = new HashSet<GasNetwork>();
            int totalRemaining = 0;
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                aqp sideTile = Object3D.get(pointer).getFromSide(side).getTileEntity((aak)pointer.k);
                if (!(sideTile instanceof IPressurizedTube)) continue;
                networks.add(((IPressurizedTube)sideTile).getNetwork());
            }
            int remaining = amount % networks.size();
            int splitGas = (amount - remaining) / networks.size();
            for (GasNetwork network : networks) {
                totalRemaining += network.emit(splitGas + remaining, type, pointer);
                remaining = 0;
            }
            return totalRemaining;
        }
        return amount;
    }
}

