/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import net.minecraftforge.common.ForgeDirection;

public class Object3D {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public int dimensionId;

    public Object3D(int x, int y, int z) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.dimensionId = 0;
    }

    public Object3D(int x, int y, int z, int dimension) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.dimensionId = dimension;
    }

    public int getMetadata(aak world) {
        return world.h(this.xCoord, this.yCoord, this.zCoord);
    }

    public int getBlockId(aak world) {
        return world.a(this.xCoord, this.yCoord, this.zCoord);
    }

    public aqp getTileEntity(aak world) {
        return world.r(this.xCoord, this.yCoord, this.zCoord);
    }

    public void write(bs nbtTags) {
        nbtTags.a("x", this.xCoord);
        nbtTags.a("y", this.yCoord);
        nbtTags.a("z", this.zCoord);
        nbtTags.a("dimensionId", this.dimensionId);
    }

    public Object3D translate(int x, int y, int z) {
        this.xCoord += x;
        this.yCoord += y;
        this.zCoord += z;
        return this;
    }

    public Object3D getFromSide(ForgeDirection side) {
        return new Object3D(this.xCoord + side.offsetX, this.yCoord + side.offsetY, this.zCoord + side.offsetZ, this.dimensionId);
    }

    public static Object3D get(aqp tileEntity) {
        return new Object3D(tileEntity.l, tileEntity.m, tileEntity.n, tileEntity.k.t.h);
    }

    public static Object3D read(bs nbtTags) {
        return new Object3D(nbtTags.e("x"), nbtTags.e("y"), nbtTags.e("z"), nbtTags.e("dimensionId"));
    }

    public int distanceTo(Object3D obj) {
        int subX = this.xCoord - obj.xCoord;
        int subY = this.yCoord - obj.yCoord;
        int subZ = this.zCoord - obj.zCoord;
        return (int)kx.a((double)(subX * subX + subY * subY + subZ * subZ));
    }

    public boolean sideVisible(ForgeDirection side, aak world) {
        return world.a(this.xCoord + side.offsetX, this.yCoord + side.offsetY, this.zCoord + side.offsetZ) == 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof Object3D && ((Object3D)obj).xCoord == this.xCoord && ((Object3D)obj).yCoord == this.yCoord && ((Object3D)obj).zCoord == this.zCoord && ((Object3D)obj).dimensionId == this.dimensionId;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.xCoord;
        code = 31 * code + this.yCoord;
        code = 31 * code + this.zCoord;
        code = 31 * code + this.dimensionId;
        return code;
    }
}

