/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.API;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import micdoodle8.mods.galacticraft.API.ICelestialBody;
import micdoodle8.mods.galacticraft.API.IGalaxy;
import micdoodle8.mods.galacticraft.API.ITeleportType;
import micdoodle8.mods.galacticraft.API.SpaceStationType;

public class GalacticraftRegistry {
    private static Map teleportTypeMap = new HashMap();
    private static Map spaceStationRecipes = new HashMap();
    private static Map spaceStations = new HashMap();
    private static ArrayList celestialBodies = new ArrayList();
    private static ArrayList galaxies = new ArrayList();

    public static void registerTeleportType(Class clazz, ITeleportType type) {
        if (!teleportTypeMap.containsKey(clazz)) {
            teleportTypeMap.put(clazz, type);
        }
    }

    public static void registerCelestialBody(ICelestialBody body) {
        if (!celestialBodies.contains(body)) {
            celestialBodies.add(body);
        }
    }

    public static void registerGalaxy(IGalaxy galaxy) {
        if (!galaxies.contains(galaxy)) {
            galaxies.add(galaxy);
        }
    }

    public static ITeleportType getTeleportTypeForDimension(Class clazz) {
        return (ITeleportType)teleportTypeMap.get(clazz);
    }

    public static void registerSpaceStation(SpaceStationType type) {
        spaceStations.put(type.getWorldToOrbitID(), type);
    }

    public SpaceStationType getTypeFromPlanetID(int planetID) {
        return (SpaceStationType)spaceStations.get(planetID);
    }

    public static Map getSpaceStationData() {
        return spaceStations;
    }

    public static ArrayList getCelestialBodies() {
        return celestialBodies;
    }

    public static ArrayList getGalaxyList() {
        return galaxies;
    }
}

