/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core;

import basiccomponents.common.BasicComponents;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import mekanism.api.GasTransmission;
import micdoodle8.mods.galacticraft.API.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.API.ICelestialBody;
import micdoodle8.mods.galacticraft.API.IGalaxy;
import micdoodle8.mods.galacticraft.API.SchematicRegistry;
import micdoodle8.mods.galacticraft.core.CommonProxyCore;
import micdoodle8.mods.galacticraft.core.GCCoreCompatibilityManager;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.GCCoreCreativeTab;
import micdoodle8.mods.galacticraft.core.GCCoreEvents;
import micdoodle8.mods.galacticraft.core.GCCoreGalaxyBlockyWay;
import micdoodle8.mods.galacticraft.core.GCCorePlanetOverworld;
import micdoodle8.mods.galacticraft.core.GCCorePlanetSun;
import micdoodle8.mods.galacticraft.core.GCCoreThreadRequirementMissing;
import micdoodle8.mods.galacticraft.core.GCLog;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.command.GCCoreCommandSpaceStationAddOwner;
import micdoodle8.mods.galacticraft.core.command.GCCoreCommandSpaceStationRemoveOwner;
import micdoodle8.mods.galacticraft.core.dimension.GCCoreOrbitTeleportType;
import micdoodle8.mods.galacticraft.core.dimension.GCCoreOverworldTeleportType;
import micdoodle8.mods.galacticraft.core.dimension.GCCoreWorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityAlienVillager;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityArrow;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityBuggy;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityCreeper;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityFlag;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityLander;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityMeteor;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityOxygenBubble;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityParaChest;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityRocketT1;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntitySkeleton;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntitySkeletonBoss;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntitySpider;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityZombie;
import micdoodle8.mods.galacticraft.core.items.GCCoreItems;
import micdoodle8.mods.galacticraft.core.network.GCCoreConnectionHandler;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketHandlerServer;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketManager;
import micdoodle8.mods.galacticraft.core.recipe.GCCoreRecipeManager;
import micdoodle8.mods.galacticraft.core.schematic.GCCoreSchematicAdd;
import micdoodle8.mods.galacticraft.core.schematic.GCCoreSchematicMoonBuggy;
import micdoodle8.mods.galacticraft.core.schematic.GCCoreSchematicRocketT1;
import micdoodle8.mods.galacticraft.core.tick.GCCoreTickHandlerCommon;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityAdvancedCraftingTable;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityAirLock;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityBuggyFueler;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityBuggyFuelerSingle;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityCargoLoader;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityCargoPad;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityCargoPadSingle;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityCargoUnloader;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityDungeonSpawner;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityFuelLoader;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityLandingPadSingle;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenCollector;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenCompressor;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenDetector;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenDistributor;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenPipe;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityParachest;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityRefinery;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntitySpaceStationBase;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityTreasureChest;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityUnlitTorch;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.moon.GalacticraftMoon;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import universalelectricity.prefab.TranslationHelper;
import universalelectricity.prefab.multiblock.TileEntityMulti;
import universalelectricity.prefab.ore.OreGenerator;

@Mod(name="Galacticraft Core", version="0.1.36", useMetadata=true, modid="GalacticraftCore", dependencies="required-after:Forge@[7.8.0.685,)")
@NetworkMod(channels={"GalacticraftCore"}, clientSideRequired=true, serverSideRequired=false, connectionHandler=GCCoreConnectionHandler.class, packetHandler=GCCorePacketManager.class)
public class GalacticraftCore {
    public static final String NAME = "Galacticraft Core";
    public static final String MODID = "GalacticraftCore";
    public static final String CHANNEL = "GalacticraftCore";
    public static final String CHANNELENTITIES = "GCCoreEntities";
    public static final int LOCALMAJVERSION = 0;
    public static final int LOCALMINVERSION = 1;
    public static final int LOCALBUILDVERSION = 36;
    public static int remoteMajVer;
    public static int remoteMinVer;
    public static int remoteBuildVer;
    @SidedProxy(clientSide="micdoodle8.mods.galacticraft.core.client.ClientProxyCore", serverSide="micdoodle8.mods.galacticraft.core.CommonProxyCore")
    public static CommonProxyCore proxy;
    @Mod.Instance(value="GalacticraftCore")
    public static GalacticraftCore instance;
    public static GalacticraftMoon moon;
    public static Map playersClient;
    public static Map playersServer;
    public static List mapPlanets;
    public static HashMap mapMoons;
    public static ve galacticraftTab;
    public static final IGalaxy galaxyMilkyWay;
    public static final String FILE_PATH = "/micdoodle8/mods/galacticraft/core/";
    public static final String CLIENT_PATH = "client/";
    public static final String LANGUAGE_PATH = "/micdoodle8/mods/galacticraft/core/client/lang/";
    public static final String BLOCK_TEXTURE_FILE = "/micdoodle8/mods/galacticraft/core/client/blocks/core.png";
    public static final String ITEM_TEXTURE_FILE = "/micdoodle8/mods/galacticraft/core/client/items/core.png";
    public static final String CONFIG_FILE = "Galacticraft/core.conf";
    private static final String[] LANGUAGES_SUPPORTED;
    public static double toBuildcraftEnergyScalar;
    public static double fromBuildcraftEnergyScalar;
    public static String TEXTURE_SUFFIX;
    public static boolean setSpaceStationRecipe;
    public static GCCorePlanetOverworld overworld;
    public static GCCorePlanetSun sun;
    public static File minecraftDir;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        if (!this.checkForCoremod()) {
            String err = "Galacticraft Core is not placed in the coremods folder!";
            System.err.println("Galacticraft Core is not placed in the coremods folder!");
            JEditorPane ep = new JEditorPane("text/html", "<html>Galacticraft Core is not placed in the coremods folder!</html>");
            ep.setEditable(false);
            ep.setOpaque(false);
            JOptionPane.showMessageDialog(null, ep, "Fatal error", 0);
            System.exit(1);
        }
        moon.preLoad(event);
        new GCCoreConfigManager(new File(event.getModConfigurationDirectory(), CONFIG_FILE));
        TEXTURE_SUFFIX = GCCoreConfigManager.hiresTextures ? "_32" : "";
        GCCoreBlocks.initBlocks();
        GCCoreBlocks.registerBlocks();
        GCCoreBlocks.setHarvestLevels();
        GCCoreItems.initItems();
        GCCoreItems.registerHarvestLevels();
        proxy.preInit(event);
    }

    @Mod.Init
    public void init(FMLInitializationEvent event) {
        float f1;
        int i;
        galacticraftTab = new GCCoreCreativeTab(ve.getNextID(), "GalacticraftCore", GCCoreItems.spaceship.cp, 0);
        overworld = new GCCorePlanetOverworld();
        GalacticraftRegistry.registerCelestialBody(overworld);
        sun = new GCCorePlanetSun();
        GalacticraftRegistry.registerCelestialBody(sun);
        GalacticraftRegistry.registerGalaxy(galaxyMilkyWay);
        DimensionManager.registerProviderType((int)GCCoreConfigManager.idDimensionOverworldOrbit, GCCoreWorldProviderSpaceStation.class, (boolean)false);
        proxy.init(event);
        GalacticraftRegistry.registerTeleportType(acp.class, new GCCoreOverworldTeleportType());
        GalacticraftRegistry.registerTeleportType(GCCoreWorldProviderSpaceStation.class, new GCCoreOrbitTeleportType());
        GCLog.info("Galacticraft Loaded: " + TranslationHelper.loadLanguages(LANGUAGE_PATH, LANGUAGES_SUPPORTED) + " Languages.");
        moon.load(event);
        LiquidDictionary.getOrCreateLiquid((String)"Oil", (LiquidStack)new LiquidStack((apa)GCCoreBlocks.crudeOilStill, 1));
        LiquidDictionary.getOrCreateLiquid((String)"Fuel", (LiquidStack)new LiquidStack(GCCoreItems.fuel, 1));
        float f = 2000.0f / (float)GCCoreItems.fuelCanister.n();
        for (i = GCCoreItems.fuelCanister.n() - 1; i > 0; --i) {
            f1 = GCCoreItems.fuelCanister.n() - i;
            LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(LiquidDictionary.getLiquid((String)"Fuel", (int)(i == 1 ? 2000 : kx.d((float)(f * f1 * 1.017f)))), new wm(GCCoreItems.fuelCanister, 1, i), new wm(GCCoreItems.oilCanister, 1, GCCoreItems.fuelCanister.n())));
        }
        f = 2000.0f / (float)GCCoreItems.oilCanister.n();
        for (i = GCCoreItems.oilCanister.n() - 1; i > 0; --i) {
            f1 = GCCoreItems.oilCanister.n() - i;
            LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(LiquidDictionary.getLiquid((String)"Oil", (int)kx.d((float)(f * f1 * 1.017f))), new wm(GCCoreItems.oilCanister, 1, i), new wm(GCCoreItems.oilCanister, 1, GCCoreItems.oilCanister.n())));
        }
        SchematicRegistry.registerSchematicRecipe(new GCCoreSchematicRocketT1());
        SchematicRegistry.registerSchematicRecipe(new GCCoreSchematicMoonBuggy());
        SchematicRegistry.registerSchematicRecipe(new GCCoreSchematicAdd());
        GasTransmission.register();
        this.registerCreatures();
        this.registerOtherEntities();
        MinecraftForge.EVENT_BUS.register((Object)new GCCoreEvents());
        NetworkRegistry.instance().registerChannel((IPacketHandler)new GCCorePacketManager(), CHANNELENTITIES, Side.CLIENT);
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent event) {
        moon.postLoad(event);
        for (ICelestialBody celestialBody : GalacticraftRegistry.getCelestialBodies()) {
            if (!celestialBody.autoRegister()) continue;
            DimensionManager.registerProviderType((int)celestialBody.getDimensionID(), (Class)celestialBody.getWorldProvider(), (boolean)false);
        }
        GCCoreCompatibilityManager.checkForCompatibleMods();
        this.registerTileEntities();
        if (GCCoreConfigManager.loadBC.getBoolean(false)) {
            BasicComponents.registerTileEntities();
            BasicComponents.requestAll(instance);
            BasicComponents.register(CHANNELENTITIES);
            if (GCCoreConfigManager.disableOreGenTin && BasicComponents.generationOreTin != null) {
                OreGenerator.removeOre(BasicComponents.generationOreTin);
            }
            if (GCCoreConfigManager.disableOreGenCopper && BasicComponents.generationOreCopper != null) {
                OreGenerator.removeOre(BasicComponents.generationOreCopper);
            }
        }
        GCCoreRecipeManager.loadRecipes();
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)proxy);
        proxy.postInit(event);
        proxy.registerRenderInformation();
        GCCoreThreadRequirementMissing.startCheck();
    }

    @Mod.ServerStarted
    public void serverInit(FMLServerStartedEvent event) {
        moon.serverInit(event);
        GCCoreUtil.checkVersion(Side.SERVER);
        TickRegistry.registerTickHandler((ITickHandler)new GCCoreTickHandlerCommon(), (Side)Side.SERVER);
        NetworkRegistry.instance().registerChannel((IPacketHandler)new GCCorePacketHandlerServer(), "GalacticraftCore", Side.SERVER);
    }

    @Mod.ServerStarting
    public void serverStarting(FMLServerStartingEvent event) {
        moon.serverStarting(event);
        event.registerServerCommand((z)new GCCoreCommandSpaceStationAddOwner());
        event.registerServerCommand((z)new GCCoreCommandSpaceStationRemoveOwner());
        WorldUtil.registerSpaceStations(event.getServer().a(0).L().b("dummy").getParentFile());
        for (ICelestialBody celestialBody : GalacticraftRegistry.getCelestialBodies()) {
            if (!celestialBody.autoRegister()) continue;
            WorldUtil.registerPlanet(celestialBody.getDimensionID(), true);
        }
    }

    @Mod.ServerStopped
    public void unregisterDims(FMLServerStoppedEvent var1) {
        WorldUtil.unregisterPlanets();
        WorldUtil.unregisterSpaceStations();
    }

    public void registerTileEntities() {
        GameRegistry.registerTileEntity(GCCoreTileEntityTreasureChest.class, (String)(GCCoreCompatibilityManager.isAIILoaded() ? "Space Treasure Chest" : "Treasure Chest"));
        GameRegistry.registerTileEntity(GCCoreTileEntityOxygenDistributor.class, (String)"Air Distributor");
        GameRegistry.registerTileEntity(GCCoreTileEntityOxygenCollector.class, (String)"Air Collector");
        GameRegistry.registerTileEntity(GCCoreTileEntityOxygenPipe.class, (String)"Oxygen Pipe");
        GameRegistry.registerTileEntity(GCCoreTileEntityAirLock.class, (String)"Air Lock Frame");
        GameRegistry.registerTileEntity(GCCoreTileEntityRefinery.class, (String)"Refinery");
        GameRegistry.registerTileEntity(GCCoreTileEntityAdvancedCraftingTable.class, (String)"NASA Workbench");
        GameRegistry.registerTileEntity(GCCoreTileEntityOxygenCompressor.class, (String)"Air Compressor");
        GameRegistry.registerTileEntity(GCCoreTileEntityFuelLoader.class, (String)"Fuel Loader");
        GameRegistry.registerTileEntity(GCCoreTileEntityLandingPadSingle.class, (String)"Landing Pad");
        GameRegistry.registerTileEntity(GCCoreTileEntityLandingPad.class, (String)"Landing Pad Full");
        GameRegistry.registerTileEntity(GCCoreTileEntityUnlitTorch.class, (String)"Unlit Torch");
        GameRegistry.registerTileEntity(GCCoreTileEntitySpaceStationBase.class, (String)"Space Station");
        GameRegistry.registerTileEntity(TileEntityMulti.class, (String)"Dummy Block");
        GameRegistry.registerTileEntity(GCCoreTileEntityOxygenSealer.class, (String)"Air Sealer");
        GameRegistry.registerTileEntity(GCCoreTileEntityDungeonSpawner.class, (String)"Dungeon Boss Spawner");
        GameRegistry.registerTileEntity(GCCoreTileEntityOxygenDetector.class, (String)"Oxygen Detector");
        GameRegistry.registerTileEntity(GCCoreTileEntityBuggyFueler.class, (String)"Buggy Fueler");
        GameRegistry.registerTileEntity(GCCoreTileEntityBuggyFuelerSingle.class, (String)"Buggy Fueler Single");
        GameRegistry.registerTileEntity(GCCoreTileEntityCargoPad.class, (String)"Cargo Pad Full");
        GameRegistry.registerTileEntity(GCCoreTileEntityCargoPadSingle.class, (String)"Cargo Pad");
        GameRegistry.registerTileEntity(GCCoreTileEntityCargoLoader.class, (String)"Cargo Loader");
        GameRegistry.registerTileEntity(GCCoreTileEntityCargoUnloader.class, (String)"Cargo Unloader");
        GameRegistry.registerTileEntity(GCCoreTileEntityParachest.class, (String)"Parachest Tile");
    }

    public void registerCreatures() {
        GCCoreUtil.registerGalacticraftCreature(GCCoreEntitySpider.class, "EvolvedSpider", GCCoreConfigManager.idEntityEvolvedSpider, 3419431, 11013646);
        GCCoreUtil.registerGalacticraftCreature(GCCoreEntityZombie.class, "EvolvedZombie", GCCoreConfigManager.idEntityEvolvedZombie, 44975, 7969893);
        GCCoreUtil.registerGalacticraftCreature(GCCoreEntityCreeper.class, "EvolvedCreeper", GCCoreConfigManager.idEntityEvolvedCreeper, 894731, 0);
        GCCoreUtil.registerGalacticraftCreature(GCCoreEntitySkeleton.class, "EvolvedSkeleton", GCCoreConfigManager.idEntityEvolvedSkeleton, 0xC1C1C1, 0x494949);
        GCCoreUtil.registerGalacticraftCreature(GCCoreEntitySkeletonBoss.class, "EvolvedSkeletonBoss", GCCoreConfigManager.idEntityEvolvedSkeletonBoss, 0xC1C1C1, 0x494949);
        GCCoreUtil.registerGalacticraftCreature(GCCoreEntityAlienVillager.class, "AlienVillager", GCCoreConfigManager.idEntityAlienVillager, GCCoreUtil.convertTo32BitColor(255, 103, 181, 145), 12422002);
    }

    public void registerOtherEntities() {
        GCCoreUtil.registerGalacticraftNonMobEntity(GCCoreEntityRocketT1.class, "Spaceship", GCCoreConfigManager.idEntitySpaceship, 150, 1, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(GCCoreEntityArrow.class, "GravityArrow", GCCoreConfigManager.idEntityAntiGravityArrow, 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(GCCoreEntityMeteor.class, "Meteor", GCCoreConfigManager.idEntityMeteor, 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(GCCoreEntityBuggy.class, "Buggy", GCCoreConfigManager.idEntityBuggy, 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(GCCoreEntityFlag.class, "Flag", GCCoreConfigManager.idEntityFlag, 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(GCCoreEntityParaChest.class, "ParaChest", GCCoreConfigManager.idEntityParaChest, 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(GCCoreEntityOxygenBubble.class, "OxygenBubble", GCCoreConfigManager.idEntityOxygenBubble, 150, 20, false);
        GCCoreUtil.registerGalacticraftNonMobEntity(GCCoreEntityLander.class, "Lander", GCCoreConfigManager.idEntityLander, 150, 5, true);
    }

    private boolean checkForCoremod() {
        if (minecraftDir != null) {
            File modsDir = new File(minecraftDir, "coremods");
            if (!modsDir.exists()) {
                return false;
            }
            for (File file : modsDir.listFiles()) {
                if (!file.getName().endsWith(".jar") || !file.getName().toLowerCase().contains("galacticraft")) continue;
                return true;
            }
        }
        return false;
    }

    static {
        moon = new GalacticraftMoon();
        playersClient = new HashMap();
        playersServer = new HashMap();
        mapPlanets = new ArrayList();
        mapMoons = new HashMap();
        galaxyMilkyWay = new GCCoreGalaxyBlockyWay();
        LANGUAGES_SUPPORTED = new String[]{"cz_CZE", "de_DE", "en_GB", "en_US", "es_ES", "fi_FI", "fr_CA", "fr_FR", "nl_NL", "pl_PL", "ru_RU", "zh_CN"};
        toBuildcraftEnergyScalar = 0.04;
        fromBuildcraftEnergyScalar = 25.0;
        setSpaceStationRecipe = false;
    }
}

