/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.blocks.BlockFluidRoot;

public class BlockFluidClassic
extends BlockFluidRoot {
    protected boolean[] isOptimalFlowDirection = new boolean[4];
    protected int[] flowCost = new int[4];

    public BlockFluidClassic(int id, aif material) {
        super(id, material);
    }

    @Override
    public boolean canDisplace(aak world, int x, int y, int z) {
        int bId = world.a(x, y, z);
        if (bId == 0) {
            return true;
        }
        if (bId == this.cz) {
            return false;
        }
        if (BlockFluidRoot.displacementIds.containsKey(bId)) {
            return (Boolean)BlockFluidRoot.displacementIds.get(bId);
        }
        aif material = apa.r[bId].cO;
        return !material.c() && material != aif.h && material != aif.i && material != aif.C;
    }

    @Override
    public boolean displaceIfPossible(aab world, int x, int y, int z) {
        int bId = world.a(x, y, z);
        if (bId == 0) {
            return true;
        }
        if (bId == this.cz) {
            return false;
        }
        if (BlockFluidRoot.displacementIds.containsKey(bId)) {
            if (((Boolean)BlockFluidRoot.displacementIds.get(bId)).booleanValue()) {
                apa.r[bId].c(world, x, y, z, world.h(x, y, z), 0);
                return true;
            }
            return false;
        }
        aif material = apa.r[bId].cO;
        if (material.c() || material == aif.h || material == aif.i || material == aif.C) {
            return false;
        }
        apa.r[bId].c(world, x, y, z, world.h(x, y, z), 0);
        return true;
    }

    public boolean isFlowingVertically(aak world, int x, int y, int z) {
        return world.a(x, y + this.densityDir, z) == this.cz || world.a(x, y, z) == this.cz && this.canFlowInto(world, x, y + this.densityDir, z);
    }

    public boolean isSourceBlock(aab world, int x, int y, int z) {
        return world.a(x, y, z) == this.cz && world.h(x, y, z) + 1 == this.quantaPerBlock;
    }

    protected void updateFlowLevel(aab world, int x, int y, int z, int quantaRemaining) {
    }

    public void a(aab world, int x, int y, int z, ng living, wm theItem) {
        world.f(x, y, z, this.cz, this.quantaPerBlock - 1, 3);
    }

    public void a(aab world, int x, int y, int z, Random rand) {
        int quantaRemaining = world.h(x, y, z) + 1;
        int expQuanta = -101;
        if (quantaRemaining < this.quantaPerBlock) {
            int y2 = y - this.densityDir;
            if (world.a(x, y2, z) == this.cz || world.a(x - 1, y2, z) == this.cz || world.a(x + 1, y2, z) == this.cz || world.a(x, y2, z - 1) == this.cz || world.a(x, y2, z + 1) == this.cz) {
                expQuanta = this.quantaPerBlock - 1;
            } else {
                int maxQuanta = -100;
                maxQuanta = this.getLargerQuanta((aak)world, x - 1, y, z, maxQuanta);
                maxQuanta = this.getLargerQuanta((aak)world, x + 1, y, z, maxQuanta);
                maxQuanta = this.getLargerQuanta((aak)world, x, y, z - 1, maxQuanta);
                maxQuanta = this.getLargerQuanta((aak)world, x, y, z + 1, maxQuanta);
                expQuanta = maxQuanta - 1;
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                if (expQuanta <= 0) {
                    world.i(x, y, z);
                } else {
                    world.b(x, y, z, expQuanta - 1, 3);
                    world.a(x, y, z, this.cz, this.tickRate);
                    world.f(x, y, z, this.cz);
                }
            }
        } else if (quantaRemaining > this.quantaPerBlock) {
            world.b(x, y, z, this.quantaPerBlock - 1, 3);
        }
        if (this.canDisplace((aak)world, x, y + this.densityDir, z)) {
            this.flowIntoBlock(world, x, y + this.densityDir, z, this.quantaPerBlock - 2);
            return;
        }
        int flowMeta = quantaRemaining - 2;
        if (flowMeta < 0) {
            return;
        }
        if (this.isSourceBlock(world, x, y, z) || !this.isFlowingVertically((aak)world, x, y, z)) {
            boolean[] flowTo;
            if (world.a(x, y - this.densityDir, z) == this.cz) {
                flowMeta = this.quantaPerBlock - 2;
            }
            if ((flowTo = this.getOptimalFlowDirections(world, x, y, z))[0]) {
                this.flowIntoBlock(world, x - 1, y, z, flowMeta);
            }
            if (flowTo[1]) {
                this.flowIntoBlock(world, x + 1, y, z, flowMeta);
            }
            if (flowTo[2]) {
                this.flowIntoBlock(world, x, y, z - 1, flowMeta);
            }
            if (flowTo[3]) {
                this.flowIntoBlock(world, x, y, z + 1, flowMeta);
            }
        }
    }

    protected boolean[] getOptimalFlowDirections(aab world, int x, int y, int z) {
        int side;
        for (int side2 = 0; side2 < 4; ++side2) {
            this.flowCost[side2] = 1000;
            int x2 = x;
            int y2 = y;
            int z2 = z;
            switch (side2) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    ++x2;
                    break;
                }
                case 2: {
                    --z2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            if (!this.canFlowInto((aak)world, x2, y2, z2) || this.isSourceBlock(world, x2, y2, z2)) continue;
            this.flowCost[side2] = this.canFlowInto((aak)world, x2, y2 + this.densityDir, z2) ? 0 : this.calculateFlowCost(world, x2, y2, z2, 1, side2);
        }
        int min = this.flowCost[0];
        for (side = 1; side < 4; ++side) {
            if (this.flowCost[side] >= min) continue;
            min = this.flowCost[side];
        }
        for (side = 0; side < 4; ++side) {
            this.isOptimalFlowDirection[side] = this.flowCost[side] == min;
        }
        return this.isOptimalFlowDirection;
    }

    protected int calculateFlowCost(aab world, int x, int y, int z, int recurseDepth, int side) {
        int cost = 1000;
        for (int adjSide = 0; adjSide < 4; ++adjSide) {
            int min;
            if (adjSide == 0 && side == 1 || adjSide == 1 && side == 0 || adjSide == 2 && side == 3 || adjSide == 3 && side == 2) continue;
            int x2 = x;
            int y2 = y;
            int z2 = z;
            switch (adjSide) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    ++x2;
                    break;
                }
                case 2: {
                    --z2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            if (!this.canFlowInto((aak)world, x2, y2, z2) || this.isSourceBlock(world, x2, y2, z2)) continue;
            if (this.canFlowInto((aak)world, x2, y2 + this.densityDir, z2)) {
                return recurseDepth;
            }
            if (recurseDepth >= 4 || (min = this.calculateFlowCost(world, x2, y2, z2, recurseDepth + 1, adjSide)) >= cost) continue;
            cost = min;
        }
        return cost;
    }

    protected void flowIntoBlock(aab world, int x, int y, int z, int meta) {
        if (this.displaceIfPossible(world, x, y, z)) {
            world.f(x, y, z, this.cz, meta, 3);
        }
    }

    protected boolean canFlowInto(aak world, int x, int y, int z) {
        int bId = world.a(x, y, z);
        if (bId == 0) {
            return true;
        }
        if (bId == this.cz) {
            return true;
        }
        if (BlockFluidRoot.displacementIds.containsKey(bId)) {
            return (Boolean)BlockFluidRoot.displacementIds.get(bId);
        }
        aif material = apa.r[bId].cO;
        return !material.c() && material != aif.h && material != aif.i && material != aif.C;
    }

    protected int getLargerQuanta(aak world, int x, int y, int z, int compare) {
        int quantaRemaining = this.getQuantaValue(world, x, y, z);
        if (quantaRemaining <= 0) {
            return compare;
        }
        return quantaRemaining >= compare ? quantaRemaining : compare;
    }
}

