/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;

public class BlockFluidRoot
extends apa {
    public static final Map displacementIds = new HashMap();
    public int quantaPerBlock = 8;
    public float quantaPerBlockFloat = 8.0f;
    public int density = 1;
    public int densityDir = -1;
    public int tickRate = 20;
    public int renderPass = 1;
    public int maxScaledLight = 0;

    public BlockFluidRoot(int id, aif material) {
        super(id, material);
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.b(true);
        this.D();
    }

    public BlockFluidRoot setQuantaPerBlock(int quantaPerBlock) {
        if (quantaPerBlock > 16 || quantaPerBlock < 1) {
            quantaPerBlock = 8;
        }
        this.quantaPerBlock = quantaPerBlock;
        this.quantaPerBlockFloat = quantaPerBlock;
        return this;
    }

    public BlockFluidRoot setDensity(int density) {
        if (density == 0) {
            density = 1;
        }
        this.density = density;
        this.densityDir = density > 0 ? -1 : 1;
        return this;
    }

    public BlockFluidRoot setTickRate(int tickRate) {
        if (tickRate <= 0) {
            tickRate = 20;
        }
        this.tickRate = tickRate;
        return this;
    }

    public BlockFluidRoot setRenderPass(int renderPass) {
        this.renderPass = renderPass;
        return this;
    }

    public BlockFluidRoot setMaxScaledLight(int maxScaledLight) {
        this.maxScaledLight = maxScaledLight;
        return this;
    }

    public boolean canDisplace(aak world, int x, int y, int z) {
        int bId = world.a(x, y, z);
        if (bId == 0) {
            return true;
        }
        if (bId == this.cz) {
            return false;
        }
        if (displacementIds.containsKey(bId)) {
            return (Boolean)displacementIds.get(bId);
        }
        aif material = apa.r[bId].cO;
        return !material.c() && material != aif.C;
    }

    public boolean displaceIfPossible(aab world, int x, int y, int z) {
        int bId = world.a(x, y, z);
        if (bId == 0) {
            return true;
        }
        if (bId == this.cz) {
            return false;
        }
        if (displacementIds.containsKey(bId)) {
            if (((Boolean)displacementIds.get(bId)).booleanValue()) {
                apa.r[bId].c(world, x, y, z, world.h(x, y, z), 0);
                return true;
            }
            return false;
        }
        aif material = apa.r[bId].cO;
        if (material.c() || material == aif.C) {
            return false;
        }
        apa.r[bId].c(world, x, y, z, world.h(x, y, z), 0);
        return true;
    }

    public void a(aab world, int x, int y, int z) {
        world.a(x, y, z, this.cz, this.tickRate);
    }

    public void a(aab world, int x, int y, int z, int blockId) {
        world.a(x, y, z, this.cz, this.tickRate);
    }

    public boolean l() {
        return false;
    }

    public boolean a(int meta, boolean fullHit) {
        return fullHit && meta == this.quantaPerBlock - 1;
    }

    public boolean b(aak world, int x, int y, int z) {
        return false;
    }

    public aqx b(aab world, int x, int y, int z) {
        return null;
    }

    public int a(int par1, Random par2Random, int par3) {
        return 0;
    }

    public int a(Random par1Random) {
        return 0;
    }

    public int a(aab world) {
        return this.tickRate;
    }

    public void a(aab world, int x, int y, int z, mp entity, arc vec) {
        if (this.densityDir > 0) {
            return;
        }
        arc vec_flow = this.getFlowVector((aak)world, x, y, z);
        vec.c += vec_flow.c * (double)(this.quantaPerBlock * 4);
        vec.d += vec_flow.d * (double)(this.quantaPerBlock * 4);
        vec.e += vec_flow.e * (double)(this.quantaPerBlock * 4);
    }

    public int getLightValue(aak world, int x, int y, int z) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(world, x, y, z);
        }
        int data = world.h(x, y, z);
        return (int)((float)data / this.quantaPerBlockFloat * (float)this.maxScaledLight);
    }

    public boolean c() {
        return false;
    }

    public boolean b() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float f(aak world, int x, int y, int z) {
        float lightUp;
        float lightThis = world.q(x, y, z);
        return lightThis > (lightUp = world.q(x, y + 1, z)) ? lightThis : lightUp;
    }

    @SideOnly(value=Side.CLIENT)
    public int e(aak world, int x, int y, int z) {
        int lightThis = world.h(x, y, z, 0);
        int lightUp = world.h(x, y + 1, z, 0);
        int lightThisBase = lightThis & 0xFF;
        int lightUpBase = lightUp & 0xFF;
        int lightThisExt = lightThis >> 16 & 0xFF;
        int lightUpExt = lightUp >> 16 & 0xFF;
        return (lightThisBase > lightUpBase ? lightThisBase : lightUpBase) | (lightThisExt > lightUpExt ? lightThisExt : lightUpExt) << 16;
    }

    @SideOnly(value=Side.CLIENT)
    public int n() {
        return this.renderPass;
    }

    public int d() {
        return GalacticraftCore.proxy.getGCCrudeOilRenderID();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean a(aak world, int x, int y, int z, int side) {
        if (world.a(x, y, z) != this.cz) {
            return !world.t(x, y, z);
        }
        aif mat = world.g(x, y, z);
        return mat == this.cO ? false : super.a(world, x, y, z, side);
    }

    public static final int getDensity(aak world, int x, int y, int z) {
        apa block = apa.r[world.a(x, y, z)];
        if (!(block instanceof BlockFluidRoot)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidRoot)block).density;
    }

    @SideOnly(value=Side.CLIENT)
    public static double getFlowDirection(aak world, int x, int y, int z) {
        apa block = apa.r[world.a(x, y, z)];
        if (!(apa.r[world.a(x, y, z)] instanceof BlockFluidRoot)) {
            return -1000.0;
        }
        arc vec = ((BlockFluidRoot)block).getFlowVector(world, x, y, z);
        return vec.c == 0.0 && vec.e == 0.0 ? -1000.0 : Math.atan2(vec.e, vec.c) - 1.5707963267948966;
    }

    public final int getQuantaValue(aak world, int x, int y, int z) {
        if (world.a(x, y, z) == 0) {
            return 0;
        }
        if (world.a(x, y, z) != this.cz) {
            return -1;
        }
        int quantaRemaining = world.h(x, y, z) + 1;
        return quantaRemaining;
    }

    public final int getQuantaValueBelow(aak world, int x, int y, int z, int belowThis) {
        int quantaRemaining = this.getQuantaValue(world, x, y, z);
        if (quantaRemaining >= belowThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final int getQuantaValueAbove(aak world, int x, int y, int z, int aboveThis) {
        int quantaRemaining = this.getQuantaValue(world, x, y, z);
        if (quantaRemaining <= aboveThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final float getQuantaPercentage(aak world, int x, int y, int z) {
        int quantaRemaining = this.getQuantaValue(world, x, y, z);
        return (float)quantaRemaining / this.quantaPerBlockFloat;
    }

    public arc getFlowVector(aak world, int x, int y, int z) {
        arc vec = world.U().a(0.0, 0.0, 0.0);
        int decay = this.quantaPerBlock - this.getQuantaValue(world, x, y, z);
        for (int side = 0; side < 4; ++side) {
            int power;
            int x2 = x;
            int z2 = z;
            switch (side) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    --z2;
                    break;
                }
                case 2: {
                    ++x2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            int otherDecay = this.quantaPerBlock - this.getQuantaValue(world, x2, y, z2);
            if (otherDecay >= this.quantaPerBlock) {
                if (world.g(x2, y, z2).c() || (otherDecay = this.quantaPerBlock - this.getQuantaValue(world, x2, y - 1, z2)) < 0) continue;
                power = otherDecay - (decay - this.quantaPerBlock);
                vec = vec.c((double)((x2 - x) * power), (double)((y - y) * power), (double)((z2 - z) * power));
                continue;
            }
            if (otherDecay < 0) continue;
            power = otherDecay - decay;
            vec = vec.c((double)((x2 - x) * power), (double)((y - y) * power), (double)((z2 - z) * power));
        }
        if (world.a(x, y + 1, z) == this.cz) {
            boolean flag = false;
            if (this.a_(world, x, y, z - 1, 2)) {
                flag = true;
            } else if (this.a_(world, x, y, z + 1, 3)) {
                flag = true;
            } else if (this.a_(world, x - 1, y, z, 4)) {
                flag = true;
            } else if (this.a_(world, x + 1, y, z, 5)) {
                flag = true;
            } else if (this.a_(world, x, y + 1, z - 1, 2)) {
                flag = true;
            } else if (this.a_(world, x, y + 1, z + 1, 3)) {
                flag = true;
            } else if (this.a_(world, x - 1, y + 1, z, 4)) {
                flag = true;
            } else if (this.a_(world, x + 1, y + 1, z, 5)) {
                flag = true;
            }
            if (flag) {
                vec = vec.a().c(0.0, -6.0, 0.0);
            }
        }
        vec = vec.a();
        return vec;
    }

    static {
        displacementIds.put(apa.aI.cz, false);
        displacementIds.put(apa.aP.cz, false);
        displacementIds.put(apa.aH.cz, false);
        displacementIds.put(apa.aM.cz, false);
        displacementIds.put(apa.bb.cz, false);
    }
}

