/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import icbm.api.IMissile;
import icbm.api.IMissileLockable;
import icbm.api.RadarRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import micdoodle8.mods.galacticraft.API.ICargoEntity;
import micdoodle8.mods.galacticraft.API.IFuelDock;
import micdoodle8.mods.galacticraft.API.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.core.entities.GCCorePlayerMP;
import micdoodle8.mods.galacticraft.core.items.GCCoreItems;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityCargoPad;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.moon.GCMoonConfigManager;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import universalelectricity.core.vector.Vector3;

public class GCCoreEntityRocketT1
extends EntitySpaceshipBase
implements lt,
IMissileLockable {
    private final int tankCapacity = 2000;
    public LiquidTank spaceshipFuelTank = new LiquidTank(this.tankCapacity);
    protected wm[] cargoItems;
    public gy rocketSoundUpdater;
    private IFuelDock landingPad;
    public int canisterToTankRatio = this.tankCapacity / GCCoreItems.fuelCanister.n();
    public double canisterToLiquidStackRatio = 2000.0 / (double)GCCoreItems.fuelCanister.n();

    public GCCoreEntityRocketT1(aab par1World) {
        super(par1World);
    }

    @Override
    public int getScaledFuelLevel(int i) {
        double fuelLevel = this.spaceshipFuelTank.getLiquid() == null ? 0.0 : (double)this.spaceshipFuelTank.getLiquid().amount;
        return (int)(fuelLevel * (double)i / 2000.0);
    }

    public GCCoreEntityRocketT1(aab par1World, double par2, double par4, double par6, EntitySpaceshipBase.EnumRocketType rocketType) {
        super(par1World);
        this.b(par2, par4 + (double)this.N, par6);
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.r = par2;
        this.s = par4;
        this.t = par6;
        this.rocketType = rocketType;
        this.cargoItems = new wm[this.j_()];
    }

    @Override
    protected void a() {
        super.a();
        RadarRegistry.register(this);
    }

    @Override
    public void w() {
        super.w();
        RadarRegistry.unregister(this);
        if (this.rocketSoundUpdater != null) {
            this.rocketSoundUpdater.a();
        }
    }

    @Override
    public void l_() {
        super.l_();
        int i = this.timeUntilLaunch >= 100 ? Math.abs(this.timeUntilLaunch / 100) : 1;
        if ((this.getLaunched() || this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.getPhase() && this.ab.nextInt(i) == 0) && !GCCoreConfigManager.disableSpaceshipParticles && this.hasValidFuel() && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.spawnParticles(this.getLaunched());
        }
        if (this.rocketSoundUpdater != null && (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.getPhase() || this.getLaunched())) {
            this.rocketSoundUpdater.a();
        }
        if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.getPhase() && this.hasValidFuel()) {
            double d = this.timeSinceLaunch / 250.0f;
            if ((d = Math.min(d, 1.0)) != 0.0) {
                this.y = -d * Math.cos((double)(this.B - 180.0f) * Math.PI / 180.0);
            }
            double multiplier = 1.0;
            if (this.q.t instanceof IGalacticraftWorldProvider && (multiplier = ((IGalacticraftWorldProvider)this.q.t).getFuelUsageMultiplier()) <= 0.0) {
                multiplier = 1.0;
            }
            if (this.timeSinceLaunch % (float)kx.c((double)(3.0 * (1.0 / multiplier))) == 0.0f) {
                this.removeFuel(null, 1);
            }
        } else if (!this.hasValidFuel() && this.getLaunched() && !this.q.I && Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 10.0 != 0.0) {
            this.y -= Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 20.0;
        }
    }

    @Override
    public ArrayList getListOfPossibleDimension(ArrayList list) {
        super.getListOfPossibleDimension(list);
        list.add(GCMoonConfigManager.dimensionIDMoon);
        return list;
    }

    @Override
    public void readNetworkedData(ByteArrayDataInput dataStream) {
        super.readNetworkedData(dataStream);
        this.spaceshipFuelTank.setLiquid(new LiquidStack(GCCoreItems.fuel.cp, dataStream.readInt(), 0));
        if (this.cargoItems == null) {
            this.cargoItems = new wm[this.j_()];
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList list) {
        super.getNetworkedData(list);
        list.add(this.spaceshipFuelTank.getLiquid() == null ? 0 : this.spaceshipFuelTank.getLiquid().amount);
        return list;
    }

    @Override
    public boolean hasValidFuel() {
        return this.spaceshipFuelTank.getLiquid() != null && this.spaceshipFuelTank.getLiquid().amount != 0;
    }

    @Override
    public void onLaunch() {
    }

    @Override
    public void onTeleport(jc player) {
        GCCorePlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((sq)player);
        player.a.b((ei)PacketUtil.createPacket("GalacticraftCore", 22, new Object[]{0}));
        if (playerBase != null) {
            playerBase.rocketStacks = this.cargoItems == null || this.cargoItems.length == 0 ? new wm[9] : this.cargoItems;
            playerBase.rocketType = this.rocketType.getIndex();
            int liquid = this.spaceshipFuelTank.getLiquid() == null ? 0 : this.spaceshipFuelTank.getLiquid().amount / kx.c((double)(this.canisterToLiquidStackRatio == 0.0 ? 1.0 : this.canisterToLiquidStackRatio));
            playerBase.fuelDamage = Math.max(Math.min(GCCoreItems.fuelCanister.n() - liquid, GCCoreItems.fuelCanister.n()), 1);
        }
    }

    protected void spawnParticles(boolean launched) {
        double x1 = 2.0 * Math.cos((double)this.A * Math.PI / 180.0) * Math.sin((double)this.B * Math.PI / 180.0);
        double z1 = 2.0 * Math.sin((double)this.A * Math.PI / 180.0) * Math.sin((double)this.B * Math.PI / 180.0);
        double y1 = 2.0 * Math.cos((double)(this.B - 180.0f) * Math.PI / 180.0);
        double y = this.s + (this.v - this.s);
        if (!this.M) {
            GalacticraftCore.proxy.spawnParticle("launchflame", this.u + 0.4 - this.ab.nextDouble() / 10.0 + x1, y - 0.0 + y1, this.w + 0.4 - this.ab.nextDouble() / 10.0 + z1, x1, y1, z1, this.getLaunched());
            GalacticraftCore.proxy.spawnParticle("launchflame", this.u - 0.4 + this.ab.nextDouble() / 10.0 + x1, y - 0.0 + y1, this.w + 0.4 - this.ab.nextDouble() / 10.0 + z1, x1, y1, z1, this.getLaunched());
            GalacticraftCore.proxy.spawnParticle("launchflame", this.u - 0.4 + this.ab.nextDouble() / 10.0 + x1, y - 0.0 + y1, this.w - 0.4 + this.ab.nextDouble() / 10.0 + z1, x1, y1, z1, this.getLaunched());
            GalacticraftCore.proxy.spawnParticle("launchflame", this.u + 0.4 - this.ab.nextDouble() / 10.0 + x1, y - 0.0 + y1, this.w - 0.4 + this.ab.nextDouble() / 10.0 + z1, x1, y1, z1, this.getLaunched());
            GalacticraftCore.proxy.spawnParticle("launchflame", this.u + x1, y - 0.0 + y1, this.w + z1, x1, y1, z1, this.getLaunched());
            GalacticraftCore.proxy.spawnParticle("launchflame", this.u + 0.4 + x1, y - 0.0 + y1, this.w + z1, x1, y1, z1, this.getLaunched());
            GalacticraftCore.proxy.spawnParticle("launchflame", this.u - 0.4 + x1, y - 0.0 + y1, this.w + z1, x1, y1, z1, this.getLaunched());
            GalacticraftCore.proxy.spawnParticle("launchflame", this.u + x1, y - 0.0 + y1, this.w + 0.4 + z1, x1, y1, z1, this.getLaunched());
            GalacticraftCore.proxy.spawnParticle("launchflame", this.u + x1, y - 0.0 + y1, this.w - 0.4 + z1, x1, y1, z1, this.getLaunched());
        }
    }

    public boolean a(sq par1EntityPlayer) {
        return this.M ? false : par1EntityPlayer.e((mp)this) <= 64.0;
    }

    public int j_() {
        return this.rocketType.getInventorySpace();
    }

    @Override
    protected void b(bs par1NBTTagCompound) {
        super.b(par1NBTTagCompound);
        if (this.j_() > 0) {
            ca var2 = new ca();
            for (int var3 = 0; var3 < this.cargoItems.length; ++var3) {
                if (this.cargoItems[var3] == null) continue;
                bs var4 = new bs();
                var4.a("Slot", (byte)var3);
                this.cargoItems[var3].b(var4);
                var2.a((cf)var4);
            }
            par1NBTTagCompound.a("Items", (cf)var2);
        }
        if (this.spaceshipFuelTank.getLiquid() != null) {
            par1NBTTagCompound.a("fuelTank", (cf)this.spaceshipFuelTank.writeToNBT(new bs()));
        }
    }

    @Override
    protected void a(bs par1NBTTagCompound) {
        super.a(par1NBTTagCompound);
        if (this.j_() > 0) {
            ca var2 = par1NBTTagCompound.m("Items");
            this.cargoItems = new wm[this.j_()];
            for (int var3 = 0; var3 < var2.c(); ++var3) {
                bs var4 = (bs)var2.b(var3);
                int var5 = var4.c("Slot") & 0xFF;
                if (var5 < 0 || var5 >= this.cargoItems.length) continue;
                this.cargoItems[var5] = wm.a((bs)var4);
            }
        }
        if (par1NBTTagCompound.b("fuelTank")) {
            this.spaceshipFuelTank.readFromNBT(par1NBTTagCompound.l("fuelTank"));
        }
    }

    public wm a(int par1) {
        return this.cargoItems[par1];
    }

    public wm a(int par1, int par2) {
        if (this.cargoItems[par1] != null) {
            if (this.cargoItems[par1].a <= par2) {
                wm var3 = this.cargoItems[par1];
                this.cargoItems[par1] = null;
                return var3;
            }
            wm var3 = this.cargoItems[par1].a(par2);
            if (this.cargoItems[par1].a == 0) {
                this.cargoItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public wm b(int par1) {
        if (this.cargoItems[par1] != null) {
            wm var2 = this.cargoItems[par1];
            this.cargoItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void a(int par1, wm par2ItemStack) {
        this.cargoItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.a > this.d()) {
            par2ItemStack.a = this.d();
        }
    }

    public String b() {
        return LanguageRegistry.instance().getStringLocalization("container.spaceship.name");
    }

    public int d() {
        return 64;
    }

    public void k_() {
    }

    public void f() {
    }

    public void g() {
    }

    @Override
    public mp[] getSpaceshipParts() {
        return null;
    }

    @Override
    public HashSet getPossiblePlanets() {
        HashSet<Integer> dimensions = new HashSet<Integer>();
        dimensions.add(0);
        dimensions.add(GCMoonConfigManager.dimensionIDMoon);
        return dimensions;
    }

    @Override
    public int getPreLaunchWait() {
        return 400;
    }

    @Override
    public List getItemsDropped() {
        ArrayList<wm> items = new ArrayList<wm>();
        items.add(new wm(GCCoreItems.spaceship, 1, this.rocketType.getIndex()));
        if (this.cargoItems != null) {
            for (wm item : this.cargoItems) {
                if (item == null) continue;
                items.add(item);
            }
        }
        return items;
    }

    public boolean c() {
        return false;
    }

    public boolean b(int i, wm itemstack) {
        return false;
    }

    @Override
    public int getMaxFuel() {
        return this.spaceshipFuelTank.getCapacity();
    }

    @Override
    public boolean canLock(IMissile missile) {
        return true;
    }

    @Override
    public Vector3 getPredictedPosition(int ticks) {
        return new Vector3(this);
    }

    @Override
    public int addFuel(LiquidStack liquid, int amount, boolean doFill) {
        LiquidStack liquidInTank = this.spaceshipFuelTank.getLiquid();
        if (liquid != null && LiquidDictionary.findLiquidName((LiquidStack)liquid).equals("Fuel") && (liquidInTank == null || liquidInTank.amount + liquid.amount <= this.spaceshipFuelTank.getCapacity())) {
            return this.spaceshipFuelTank.fill(liquid, doFill);
        }
        return 0;
    }

    @Override
    public LiquidStack removeFuel(LiquidStack liquid, int amount) {
        if (liquid == null) {
            return this.spaceshipFuelTank.drain(amount, true);
        }
        return null;
    }

    @Override
    public ICargoEntity.EnumCargoLoadingState addCargo(wm stack, boolean doAdd) {
        wm stackAt;
        if (this.rocketType.getInventorySpace() <= 3) {
            return ICargoEntity.EnumCargoLoadingState.NOINVENTORY;
        }
        int count = 0;
        for (count = 0; count < this.cargoItems.length - 3; ++count) {
            stackAt = this.cargoItems[count];
            if (stackAt == null || stackAt.c != stack.c || stackAt.k() != stack.k() || stackAt.a >= stackAt.e()) continue;
            if (doAdd) {
                this.cargoItems[count].a += stack.a;
            }
            return ICargoEntity.EnumCargoLoadingState.SUCCESS;
        }
        for (count = 0; count < this.cargoItems.length - 3; ++count) {
            stackAt = this.cargoItems[count];
            if (stackAt != null) continue;
            if (doAdd) {
                this.cargoItems[count] = stack;
            }
            return ICargoEntity.EnumCargoLoadingState.SUCCESS;
        }
        return ICargoEntity.EnumCargoLoadingState.FULL;
    }

    @Override
    public ICargoEntity.RemovalResult removeCargo(boolean doRemove) {
        for (int i = 0; i < this.cargoItems.length - 3; ++i) {
            wm stackAt = this.cargoItems[i];
            if (stackAt == null) continue;
            if (doRemove && --this.cargoItems[i].a <= 0) {
                this.cargoItems[i] = null;
            }
            return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.SUCCESS, new wm(stackAt.c, 1, stackAt.k()));
        }
        return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.EMPTY, null);
    }

    @Override
    public void onPadDestroyed() {
        if (!this.M && this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.getPhase()) {
            this.dropShipAsItem();
            this.w();
        }
    }

    @Override
    public void setPad(IFuelDock pad) {
        this.landingPad = pad;
    }

    @Override
    public IFuelDock getLandingPad() {
        return this.landingPad;
    }

    @Override
    public boolean isDockValid(IFuelDock dock) {
        return dock instanceof GCCoreTileEntityLandingPad || dock instanceof GCCoreTileEntityCargoPad;
    }
}

