/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.oxygen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import micdoodle8.mods.galacticraft.API.IOxygenReliantBlock;
import micdoodle8.mods.galacticraft.API.IPartialSealedBlock;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenSealer;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.vector.Vector3;

public class OxygenPressureProtocol {
    private LinkedList checked = new LinkedList();
    private LinkedList oxygenReliantBlocks = new LinkedList();
    private boolean airtight;
    private static ArrayList vanillaPermeableBlocks = new ArrayList();
    private static Map nonPermeableBlocks = new HashMap();

    private void loopThrough(aab var1, int var2, int var3, int var4, int var5) {
        Vector3 vecAt = new Vector3(var2, var3, var4);
        this.checked.add(vecAt);
        if (this.touchingUnsealedBlock(var1, var2, var3, var4) && this.airtight) {
            if (var5 > 0) {
                this.nextVec(var1, var2, var3, var4, var5);
            } else if (!this.getIsSealed(var1, var2, var3, var4)) {
                this.airtight = false;
            }
        }
    }

    private void checkAtVec(aab var1, Vector3 vec) {
        this.checked.add(vec);
        if (this.isTouchingBreathableAir(var1, vec.intX(), vec.intY(), vec.intZ())) {
            this.nextVecD(var1, vec.intX(), vec.intY(), vec.intZ());
        }
    }

    private void nextVec(aab var1, int var2, int var3, int var4, int var5) {
        for (ForgeDirection dir : ForgeDirection.values()) {
            aqp tileAtVec;
            int idAtVec;
            if (dir == ForgeDirection.UNKNOWN) continue;
            Vector3 vec = new Vector3(var2, var3, var4);
            if (this.canBlockPass(var1, vec = vec.add(new Vector3(dir))) && !this.isVisited(vec)) {
                this.loopThrough(var1, vec.intX(), vec.intY(), vec.intZ(), var5 - 1);
            }
            if ((idAtVec = vec.getBlockID((aak)var1)) != 0 && apa.r[idAtVec] instanceof IOxygenReliantBlock) {
                this.oxygenReliantBlocks.add(vec);
            }
            if ((tileAtVec = vec.getTileEntity((aak)var1)) == null || !(tileAtVec instanceof GCCoreTileEntityOxygenSealer)) continue;
            var5 = (int)((double)var5 + (double)((GCCoreTileEntityOxygenSealer)tileAtVec).storedOxygen / 25.0);
        }
    }

    private void nextVecD(aab var1, int var2, int var3, int var4) {
        for (ForgeDirection dir : ForgeDirection.values()) {
            int idAtVec;
            if (dir == ForgeDirection.UNKNOWN) continue;
            Vector3 vec = new Vector3(var2, var3, var4);
            if (OxygenPressureProtocol.isBreathableAir(var1, (vec = vec.add(new Vector3(dir))).intX(), vec.intY(), vec.intZ()) && !this.isVisited(vec)) {
                this.checkAtVec(var1, vec);
            }
            if ((idAtVec = vec.getBlockID((aak)var1)) == 0 || !(apa.r[idAtVec] instanceof IOxygenReliantBlock)) continue;
            this.oxygenReliantBlocks.add(vec);
        }
    }

    public boolean seal(aab var1, int var2, int var3, int var4, int var5) {
        this.airtight = true;
        this.nextVec(var1, var2, var3, var4, var5);
        if (this.airtight) {
            for (Vector3 var7 : this.checked) {
                if (this.getIsSealed(var1, var7.intX(), var7.intY(), var7.intZ())) continue;
                this.airtight = false;
            }
            for (Vector3 var7 : this.oxygenReliantBlocks) {
                apa block = apa.r[var7.getBlockID((aak)var1)];
                if (block == null || !(block instanceof IOxygenReliantBlock)) continue;
                ((IOxygenReliantBlock)block).onOxygenAdded(var1, var7.intX(), var7.intY(), var7.intZ());
            }
            for (Vector3 var7 : this.checked) {
                if (var7.getBlockID((aak)var1) != 0) continue;
                if (var1.a(var7.intX(), var7.intY() + 1, var7.intZ()) == 64) {
                    var1.c(var7.intX(), var7.intY() + 1, var7.intZ(), GCCoreBlocks.breatheableAir.cz);
                }
                if (var1.a(var7.intX(), var7.intY() - 1, var7.intZ()) == 64 && var1.a(var7.intX(), var7.intY() - 2, var7.intZ()) != 64) {
                    var1.c(var7.intX(), var7.intY() - 1, var7.intZ(), GCCoreBlocks.breatheableAir.cz);
                }
                var1.f(var7.intX(), var7.intY(), var7.intZ(), GCCoreBlocks.breatheableAir.cz, 0, 2);
            }
        }
        this.checked = new LinkedList();
        this.oxygenReliantBlocks = new LinkedList();
        return this.airtight;
    }

    public boolean checkSeal(aab var1, int var2, int var3, int var4, int var5) {
        this.airtight = true;
        if (var1.h(var2, var3, var4) != 100) {
            this.nextVec(var1, var2, var3, var4, var5);
        }
        if (this.airtight) {
            for (Vector3 var7 : this.checked) {
                if (this.getIsSealed(var1, var7.intX(), var7.intY(), var7.intZ())) continue;
                this.airtight = false;
            }
        }
        this.checked = new LinkedList();
        return this.airtight;
    }

    public void unSeal(aab var1, int var2, int var3, int var4) {
        this.nextVecD(var1, var2, var3, var4);
        for (Vector3 var6 : this.checked) {
            if (!this.canBlockPass(var1, var6)) continue;
            var1.a(var6.intX(), var6.intY(), var6.intZ());
            apa.r[var1.a(var6.intX(), var6.intY(), var6.intZ())].c(var1, var6.intX(), var6.intY(), var6.intZ(), var1.h(var6.intX(), var6.intY(), var6.intZ()), 0);
            var1.f(var6.intX(), var6.intY(), var6.intZ(), 0, 0, 2);
        }
        for (Vector3 var6 : this.checked) {
            if (var1.a(var6.intX(), var6.intY(), var6.intZ()) != GCCoreBlocks.breatheableAir.cz) continue;
            var1.f(var6.intX(), var6.intY(), var6.intZ(), 0, 0, 2);
        }
        for (Vector3 var6 : this.oxygenReliantBlocks) {
            int idAt = var6.getBlockID((aak)var1);
            if (idAt == 0 || !(apa.r[idAt] instanceof IOxygenReliantBlock)) continue;
            ((IOxygenReliantBlock)apa.r[idAt]).onOxygenRemoved(var1, var6.intX(), var6.intY(), var6.intZ());
        }
        for (Vector3 var6 : this.checked) {
            if (var6.getBlockID((aak)var1) != 0) continue;
            var1.f(var6.intX(), var6.intY(), var6.intZ(), 0);
        }
        this.oxygenReliantBlocks = new LinkedList();
        this.checked = new LinkedList();
    }

    public boolean canBlockPass(aab var0, Vector3 vec) {
        apa block = apa.r[vec.getBlockID((aak)var0)];
        return block == null || block.cz == 0 || block.cz == GCCoreBlocks.breatheableAir.cz || vanillaPermeableBlocks.contains(block.cz) || !block.c() && !(block instanceof IPartialSealedBlock) && (!nonPermeableBlocks.containsKey(block.cz) || !((ArrayList)nonPermeableBlocks.get(block.cz)).contains(vec.getBlockMetadata((aak)var0))) || !block.c() && block instanceof IPartialSealedBlock && !((IPartialSealedBlock)block).isSealed(var0, vec.intX(), vec.intY(), vec.intZ());
    }

    public static boolean isBreathableAir(aab var0, int var1, int var2, int var3) {
        return var0.a(var1, var2, var3) == GCCoreBlocks.breatheableAir.cz;
    }

    private boolean touchingUnsealedBlock(aab var1, int var2, int var3, int var4) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            Vector3 vec = new Vector3(var2, var3, var4);
            if (!this.canBlockPass(var1, vec = vec.add(new Vector3(dir))) || this.isVisited(vec)) continue;
            return true;
        }
        return false;
    }

    private boolean getIsSealed(aab var1, int var2, int var3, int var4) {
        for (ForgeDirection dir : ForgeDirection.values()) {
            if (dir == ForgeDirection.UNKNOWN) continue;
            Vector3 vec = new Vector3(var2, var3, var4);
            if ((vec = vec.add(new Vector3(dir))).getBlockID((aak)var1) != 0 || this.isVisited(vec)) continue;
            return false;
        }
        return true;
    }

    private boolean isTouchingBreathableAir(aab var1, int var2, int var3, int var4) {
        for (ForgeDirection dir : ForgeDirection.values()) {
            if (dir == ForgeDirection.UNKNOWN) continue;
            Vector3 vec = new Vector3(var2, var3, var4);
            if (!OxygenPressureProtocol.isBreathableAir(var1, (vec = vec.add(new Vector3(dir))).intX(), vec.intY(), vec.intZ()) || this.isVisited(vec)) continue;
            return true;
        }
        return false;
    }

    private boolean isVisited(Vector3 var1) {
        this.checked.iterator();
        for (Vector3 vec : this.checked) {
            if (!vec.equals(var1)) continue;
            return true;
        }
        return false;
    }

    static {
        vanillaPermeableBlocks.add(apa.P.cz);
        try {
            for (String s : GCCoreConfigManager.sealableIDs) {
                String[] split = s.split(":");
                if (nonPermeableBlocks.containsKey(Integer.parseInt(split[0]))) {
                    ArrayList l = (ArrayList)nonPermeableBlocks.get(Integer.parseInt(split[0]));
                    l.add(Integer.parseInt(split[1]));
                    nonPermeableBlocks.put(Integer.parseInt(split[0]), l);
                    continue;
                }
                ArrayList<Integer> a = new ArrayList<Integer>();
                a.add(Integer.parseInt(split[1]));
                nonPermeableBlocks.put(Integer.parseInt(split[0]), a);
            }
        }
        catch (Exception e) {
            System.err.println();
            System.err.println("Error finding sealable IDs from the Galacticraft config, check that they are listed properly!");
            System.err.println();
            e.printStackTrace();
        }
    }
}

