/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.tile.IWrenchable;
import micdoodle8.mods.galacticraft.API.IDisableableMachine;
import micdoodle8.mods.galacticraft.core.GCCoreCompatibilityManager;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.tile.GCCoreLinkedPowerProvider;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.item.ElectricItemHelper;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.network.IPacketReceiver;
import universalelectricity.prefab.network.PacketManager;
import universalelectricity.prefab.tile.TileEntityElectricityRunnable;

public abstract class GCCoreTileEntityElectric
extends TileEntityElectricityRunnable
implements IWrenchable,
IPowerReceptor,
IEnergySink,
IPacketReceiver,
IDisableableMachine {
    public int ueWattsPerTick;
    public double maxEnergy;
    public double ic2Energy;
    public double ic2EnergyPerTick;
    public IPowerProvider bcPowerProvider;
    @SideOnly(value=Side.CLIENT)
    public double bcEnergy;
    public double bcEnergyPerTick;
    public boolean addedToEnergyNet = false;
    public boolean disabled = true;
    public int disableCooldown = 0;

    public abstract boolean shouldPullEnergy();

    public abstract void readPacket(ByteArrayDataInput var1);

    public abstract ei getPacket();

    public abstract ForgeDirection getElectricInputDirection();

    public abstract wm getBatteryInSlot();

    public GCCoreTileEntityElectric(int ueWattsPerTick, double maxEnergy, double ic2EnergyPerTick, double bcEnergyPerTick) {
        this.ueWattsPerTick = ueWattsPerTick;
        this.maxEnergy = maxEnergy;
        this.ic2EnergyPerTick = ic2EnergyPerTick;
        this.bcEnergyPerTick = bcEnergyPerTick;
        if (PowerFramework.currentFramework != null) {
            this.bcPowerProvider = new GCCoreLinkedPowerProvider(this);
            this.bcPowerProvider.configure(20, 1, 10, 10, 1000);
        }
    }

    @Override
    public void w_() {
        this.unloadIC2();
        super.w_();
    }

    public void onChunkUnload() {
        this.unloadIC2();
        super.onChunkUnload();
    }

    private void unloadIC2() {
        if (this.addedToEnergyNet && this.k != null) {
            if (GCCoreCompatibilityManager.isIc2Loaded()) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            }
            this.addedToEnergyNet = false;
        }
    }

    @Override
    public ElectricityPack getRequest() {
        if (this.shouldPullEnergy()) {
            return new ElectricityPack((double)this.ueWattsPerTick / this.getVoltage(), this.getVoltage());
        }
        return new ElectricityPack();
    }

    @Override
    public void h() {
        super.h();
        if (!this.addedToEnergyNet && this.k != null) {
            if (GCCoreCompatibilityManager.isIc2Loaded()) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            }
            this.addedToEnergyNet = true;
        }
        if (!this.k.I) {
            this.ic2Energy = Math.max(this.ic2Energy - this.ic2EnergyPerTick, 0.0);
            if (this.getPowerProvider() != null && this.shouldPullEnergy()) {
                this.getPowerProvider().useEnergy((float)this.bcEnergyPerTick / 2.0f, (float)this.bcEnergyPerTick / 2.0f, true);
            }
            if (this.shouldPullEnergy()) {
                this.wattsReceived += ElectricItemHelper.dechargeItem(this.getBatteryInSlot(), this.ueWattsPerTick, this.getVoltage());
            }
            if (this.disableCooldown > 0) {
                --this.disableCooldown;
            }
            if (this.ticks % 3L == 0L) {
                PacketManager.sendPacketToClients(this.getPacket(), this.k, new Vector3(this), 12.0);
            }
            this.wattsReceived = Math.max(this.wattsReceived - (double)(this.ueWattsPerTick / 4), 0.0);
        }
    }

    public void b(bs nbt) {
        super.b(nbt);
        nbt.a("ic2Energy", this.ic2Energy);
        nbt.a("isDisabled", this.getDisabled());
    }

    public void a(bs nbt) {
        super.a(nbt);
        this.ic2Energy = nbt.h("ic2Energy");
        this.setDisabled(nbt.n("isDisabled"));
    }

    @Override
    public void handlePacketData(cg network, int type, dk packet, sq player, ByteArrayDataInput dataStream) {
        try {
            this.readPacket(dataStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        this.ic2Energy += (double)amount;
        int rejects = 0;
        if (this.ic2Energy > this.maxEnergy) {
            rejects = (int)(this.ic2Energy - this.maxEnergy);
            this.ic2Energy = this.maxEnergy;
        }
        return rejects;
    }

    @Override
    public int demandsEnergy() {
        return (int)(this.shouldPullEnergy() ? this.maxEnergy - this.ic2Energy : 0.0);
    }

    @Override
    public boolean acceptsEnergyFrom(aqp emitter, Direction direction) {
        return direction.toForgeDirection() == this.getElectricInputDirection();
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean canConnect(ForgeDirection direction) {
        return direction == this.getElectricInputDirection();
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (this.disableCooldown == 0) {
            this.disabled = disabled;
            this.disableCooldown = 20;
        }
    }

    @Override
    public boolean getDisabled() {
        return this.disabled;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.bcPowerProvider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        if (this.getPowerProvider() == null) {
            return 0;
        }
        return (int)Math.min((double)((float)this.getPowerProvider().getMaxEnergyStored() - this.getPowerProvider().getEnergyStored()) * GalacticraftCore.toBuildcraftEnergyScalar, (double)this.getPowerProvider().getMaxEnergyReceived());
    }

    @Override
    public boolean wrenchCanSetFacing(sq entityPlayer, int side) {
        return true;
    }

    @Override
    public short getFacing() {
        return (short)this.k.h(kx.c((double)this.l), kx.c((double)this.m), kx.c((double)this.n));
    }

    @Override
    public void setFacing(short facing) {
        int change = 0;
        switch (this.getFacing()) {
            case 0: {
                change = 3;
                break;
            }
            case 3: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
            }
        }
        this.k.b(kx.c((double)this.l), kx.c((double)this.m), kx.c((double)this.n), change, 3);
    }

    @Override
    public boolean wrenchCanRemove(sq entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public wm getWrenchDrop(sq entityPlayer) {
        return apa.r[this.q().cz].getPickBlock(null, this.k, this.l, this.m, this.n);
    }
}

