/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.registry.LanguageRegistry;
import micdoodle8.mods.galacticraft.API.IFuelable;
import micdoodle8.mods.galacticraft.core.items.GCCoreItemFuelCanister;
import micdoodle8.mods.galacticraft.core.items.GCCoreItems;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityElectric;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import universalelectricity.core.item.IItemElectric;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.multiblock.TileEntityMulti;
import universalelectricity.prefab.network.PacketManager;

public class GCCoreTileEntityFuelLoader
extends GCCoreTileEntityElectric
implements lt,
md,
ITankContainer {
    private final int tankCapacity = 12000;
    public LiquidTank fuelTank = new LiquidTank(this.tankCapacity);
    private wm[] containingItems = new wm[2];
    public static final double WATTS_PER_TICK = 300.0;
    public IFuelable attachedFuelable;

    public GCCoreTileEntityFuelLoader() {
        super(300, 130.0, 1.0, 1.0);
    }

    public int getScaledFuelLevel(int i) {
        double fuelLevel = this.fuelTank.getLiquid() == null ? 0.0 : (double)this.fuelTank.getLiquid().amount;
        return (int)(fuelLevel * (double)i / (double)this.tankCapacity);
    }

    @Override
    public void h() {
        super.h();
        if (!this.k.I) {
            LiquidStack liquid;
            if (this.containingItems[1] != null && (liquid = LiquidContainerRegistry.getLiquidForFilledItem((wm)this.containingItems[1])) != null && LiquidDictionary.findLiquidName((LiquidStack)liquid).equals("Fuel") && (this.fuelTank.getLiquid() == null || this.fuelTank.getLiquid().amount + liquid.amount <= this.fuelTank.getCapacity())) {
                this.fuelTank.fill(liquid, true);
                if (this.containingItems[1].b() instanceof GCCoreItemFuelCanister) {
                    this.containingItems[1] = new wm(GCCoreItems.oilCanister, 1, GCCoreItems.oilCanister.n());
                } else if (LiquidContainerRegistry.isBucket((wm)this.containingItems[1]) && LiquidContainerRegistry.isFilledContainer((wm)this.containingItems[1])) {
                    int amount = this.containingItems[1].a;
                    this.containingItems[1] = new wm(wk.ax, amount);
                } else {
                    --this.containingItems[1].a;
                    if (this.containingItems[1].a == 0) {
                        this.containingItems[1] = null;
                    }
                }
            }
            if (this.ticks % 100L == 0L) {
                boolean foundFuelable = false;
                for (ForgeDirection dir : ForgeDirection.values()) {
                    if (dir == ForgeDirection.UNKNOWN) continue;
                    Vector3 vecAt = new Vector3(this);
                    aqp pad = (vecAt = vecAt.modifyPositionFromSide(dir)).getTileEntity((aak)this.k);
                    if (pad != null && pad instanceof TileEntityMulti) {
                        aqp mainTile = ((TileEntityMulti)pad).mainBlockPosition.getTileEntity((aak)this.k);
                        if (mainTile == null || !(mainTile instanceof IFuelable)) continue;
                        this.attachedFuelable = (IFuelable)mainTile;
                        foundFuelable = true;
                        break;
                    }
                    if (pad == null || !(pad instanceof IFuelable)) continue;
                    this.attachedFuelable = (IFuelable)pad;
                    foundFuelable = true;
                    break;
                }
                if (!foundFuelable) {
                    this.attachedFuelable = null;
                }
            }
            liquid = LiquidDictionary.getLiquid((String)"Fuel", (int)1);
            if (this.attachedFuelable != null && (this.ic2Energy > 0.0 || this.wattsReceived > 0.0 || this.getPowerProvider() != null && this.getPowerProvider().getEnergyStored() > 0.0f) && !this.disabled && liquid != null) {
                this.fuelTank.drain(this.attachedFuelable.addFuel(liquid, 1, true), true);
            }
        }
    }

    public int j_() {
        return this.containingItems.length;
    }

    public wm a(int par1) {
        return this.containingItems[par1];
    }

    public wm a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].a <= par2) {
                wm var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            wm var3 = this.containingItems[par1].a(par2);
            if (this.containingItems[par1].a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public wm b(int par1) {
        if (this.containingItems[par1] != null) {
            wm var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void a(int par1, wm par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.a > this.d()) {
            par2ItemStack.a = this.d();
        }
    }

    @Override
    public void a(bs par1NBTTagCompound) {
        super.a(par1NBTTagCompound);
        ca var2 = par1NBTTagCompound.m("Items");
        this.containingItems = new wm[this.j_()];
        for (int var3 = 0; var3 < var2.c(); ++var3) {
            bs var4 = (bs)var2.b(var3);
            byte var5 = var4.c("Slot");
            if (var5 < 0 || var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = wm.a((bs)var4);
        }
        if (par1NBTTagCompound.b("fuelTank")) {
            this.fuelTank.readFromNBT(par1NBTTagCompound.l("fuelTank"));
        }
    }

    @Override
    public void b(bs par1NBTTagCompound) {
        super.b(par1NBTTagCompound);
        ca list = new ca();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            bs var4 = new bs();
            var4.a("Slot", (byte)var3);
            this.containingItems[var3].b(var4);
            list.a((cf)var4);
        }
        par1NBTTagCompound.a("Items", (cf)list);
        if (this.fuelTank.getLiquid() != null) {
            par1NBTTagCompound.a("fuelTank", (cf)this.fuelTank.writeToNBT(new bs()));
        }
    }

    public String b() {
        return LanguageRegistry.instance().getStringLocalization("container.fuelloader.name");
    }

    public int d() {
        return 1;
    }

    public boolean a(sq par1EntityPlayer) {
        return this.k.r(this.l, this.m, this.n) != this ? false : par1EntityPlayer.e((double)this.l + 0.5, (double)this.m + 0.5, (double)this.n + 0.5) <= 64.0;
    }

    public void f() {
    }

    public void g() {
    }

    public int[] c(int side) {
        int[] nArray;
        if (side == 1 || side == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        }
        return nArray;
    }

    public boolean a(int slotID, wm itemstack, int side) {
        return this.b(slotID, itemstack);
    }

    public boolean b(int slotID, wm itemstack, int side) {
        return slotID == 1;
    }

    public boolean c() {
        return true;
    }

    public boolean b(int slotID, wm itemstack) {
        return slotID == 1 ? true : (slotID == 0 ? itemstack.b() instanceof IItemElectric : false);
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        int used = 0;
        String liquidName = LiquidDictionary.findLiquidName((LiquidStack)resource);
        if (tankIndex == 0 && liquidName != null && liquidName.equals("Fuel")) {
            used = this.fuelTank.fill(resource, doFill);
        }
        return used;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this.fuelTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (direction == ForgeDirection.getOrientation((int)(this.p() + 2))) {
            return this.fuelTank;
        }
        return null;
    }

    @Override
    public boolean shouldPullEnergy() {
        return this.fuelTank.getLiquid() != null && this.fuelTank.getLiquid().amount > 0 && !this.disabled;
    }

    @Override
    public void readPacket(ByteArrayDataInput data) {
        if (this.k.I) {
            this.wattsReceived = data.readDouble();
            this.ic2Energy = data.readDouble();
            this.fuelTank.setLiquid(new LiquidStack(GCCoreItems.fuel.cp, data.readInt(), 0));
            this.disabled = data.readBoolean();
            this.disableCooldown = data.readInt();
            this.bcEnergy = data.readDouble();
        }
    }

    @Override
    public ei getPacket() {
        return PacketManager.getPacket("GCCoreEntities", this, new Object[]{this.wattsReceived, this.ic2Energy, this.fuelTank.getLiquid() == null ? 0 : this.fuelTank.getLiquid().amount, this.disabled, this.disableCooldown, this.getPowerProvider() != null ? (double)this.getPowerProvider().getEnergyStored() : 0.0});
    }

    @Override
    public ForgeDirection getElectricInputDirection() {
        return ForgeDirection.getOrientation((int)(this.p() + 2));
    }

    @Override
    public wm getBatteryInSlot() {
        return this.a(0);
    }
}

