/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.registry.LanguageRegistry;
import mekanism.api.EnumGas;
import mekanism.api.GasTransmission;
import mekanism.api.IGasAcceptor;
import mekanism.api.ITubeConnection;
import micdoodle8.mods.galacticraft.API.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityElectric;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;
import universalelectricity.core.item.IItemElectric;
import universalelectricity.core.vector.Vector3;
import universalelectricity.core.vector.VectorHelper;
import universalelectricity.prefab.network.PacketManager;

public class GCCoreTileEntityOxygenCollector
extends GCCoreTileEntityElectric
implements ITubeConnection,
lt,
md {
    public boolean active;
    public static final double WATTS_PER_TICK = 200.0;
    public double power;
    public int MAX_POWER = 180;
    public int outputSpeed = 16;
    private wm[] containingItems = new wm[1];

    public GCCoreTileEntityOxygenCollector() {
        super(200, 130.0, 1.0, 0.75);
    }

    public int getCappedScaledOxygenLevel(int scale) {
        return (int)Math.max(Math.min(Math.floor(this.power / (double)this.MAX_POWER * (double)scale), (double)scale), 0.0);
    }

    @Override
    public void h() {
        super.h();
        if (!this.k.I) {
            if (this.getPower() > 0.0 && !this.k.I && (this.ic2Energy > 0.0 || this.wattsReceived > 0.0 || this.getPowerProvider() != null && this.getPowerProvider().getEnergyStored() > 0.0f)) {
                for (ForgeDirection orientation : ForgeDirection.values()) {
                    if (orientation == ForgeDirection.UNKNOWN || orientation != ForgeDirection.getOrientation((int)(this.p() + 2)).getOpposite()) continue;
                    this.setPower(this.getPower() - (Math.min(this.getPower(), (double)this.outputSpeed) - (double)GasTransmission.emitGasToNetwork(EnumGas.OXYGEN, (int)Math.min(this.getPower(), (double)this.outputSpeed), this, orientation)));
                    aqp tileEntity = VectorHelper.getTileEntityFromSide(this.k, new Vector3(this), orientation);
                    if (!(tileEntity instanceof IGasAcceptor) || !((IGasAcceptor)tileEntity).canReceiveGas(orientation.getOpposite(), EnumGas.OXYGEN)) continue;
                    double sendingGas = 0.0;
                    if (this.getPower() >= (double)this.outputSpeed) {
                        sendingGas = this.outputSpeed;
                    } else if (this.getPower() < (double)this.outputSpeed) {
                        sendingGas = this.getPower();
                    }
                    int rejects = ((IGasAcceptor)tileEntity).transferGasToAcceptor(kx.c((double)sendingGas), EnumGas.OXYGEN);
                    this.setPower(this.getPower() - (sendingGas - (double)rejects));
                }
            }
            double power = 0.0;
            if (this.k.t instanceof IGalacticraftWorldProvider) {
                for (int y = this.m - 5; y <= this.m + 5; ++y) {
                    for (int x2 = this.l - 5; x2 <= this.l + 5; ++x2) {
                        for (int z2 = this.n - 5; z2 <= this.n + 5; ++z2) {
                            apa block = apa.r[this.k.a(x2, y, z2)];
                            if (block == null) continue;
                            if (this.k.g(x2, y, z2) == aif.j) {
                                if (!this.k.I && this.k.s.nextInt(100000) == 0 && !GCCoreConfigManager.disableLeafDecay) {
                                    this.k.i(x2, y, z2);
                                }
                                power += 1.0;
                                continue;
                            }
                            if (!(block instanceof IPlantable) || ((IPlantable)block).getPlantType(this.k, x2, y, z2) != EnumPlantType.Crop) continue;
                            power += 2.0;
                        }
                    }
                }
                this.setPower(power / 1.2);
            } else {
                this.setPower(this.MAX_POWER);
            }
            if (this.getPower() > (double)this.MAX_POWER) {
                this.setPower(this.MAX_POWER);
            }
        }
    }

    @Override
    public void a(bs par1NBTTagCompound) {
        super.a(par1NBTTagCompound);
        this.setPower(par1NBTTagCompound.h("storedOxygenD"));
        ca var2 = par1NBTTagCompound.m("Items");
        this.containingItems = new wm[this.j_()];
        for (int var3 = 0; var3 < var2.c(); ++var3) {
            bs var4 = (bs)var2.b(var3);
            byte var5 = var4.c("Slot");
            if (var5 < 0 || var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = wm.a((bs)var4);
        }
    }

    @Override
    public void b(bs par1NBTTagCompound) {
        super.b(par1NBTTagCompound);
        par1NBTTagCompound.a("storedOxygenD", this.getPower());
        ca list = new ca();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            bs var4 = new bs();
            var4.a("Slot", (byte)var3);
            this.containingItems[var3].b(var4);
            list.a((cf)var4);
        }
        par1NBTTagCompound.a("Items", (cf)list);
    }

    public double getPower() {
        return this.power;
    }

    public void setPower(double power) {
        this.power = power;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection direction) {
        return direction == ForgeDirection.getOrientation((int)(this.p() + 2)).getOpposite();
    }

    public int j_() {
        return this.containingItems.length;
    }

    public wm a(int par1) {
        return this.containingItems[par1];
    }

    public wm a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].a <= par2) {
                wm var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            wm var3 = this.containingItems[par1].a(par2);
            if (this.containingItems[par1].a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public wm b(int par1) {
        if (this.containingItems[par1] != null) {
            wm var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void a(int par1, wm par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.a > this.d()) {
            par2ItemStack.a = this.d();
        }
    }

    public String b() {
        return LanguageRegistry.instance().getStringLocalization("container.oxygencollector.name");
    }

    public int d() {
        return 64;
    }

    public boolean a(sq par1EntityPlayer) {
        return this.k.r(this.l, this.m, this.n) != this ? false : par1EntityPlayer.e((double)this.l + 0.5, (double)this.m + 0.5, (double)this.n + 0.5) <= 64.0;
    }

    public void f() {
    }

    public void g() {
    }

    public int[] c(int side) {
        return new int[]{0};
    }

    public boolean a(int slotID, wm itemstack, int side) {
        return this.b(slotID, itemstack);
    }

    public boolean b(int slotID, wm itemstack, int side) {
        return slotID == 0;
    }

    public boolean c() {
        return true;
    }

    public boolean b(int slotID, wm itemstack) {
        return slotID == 0 ? itemstack.b() instanceof IItemElectric : false;
    }

    @Override
    public boolean shouldPullEnergy() {
        return this.getPower() > 0.0;
    }

    @Override
    public void readPacket(ByteArrayDataInput data) {
        if (this.k.I) {
            this.setPower(data.readDouble());
            this.wattsReceived = data.readDouble();
            this.ic2Energy = data.readDouble();
            this.disabled = data.readBoolean();
            this.bcEnergy = data.readDouble();
        }
    }

    @Override
    public ei getPacket() {
        return PacketManager.getPacket("GCCoreEntities", this, new Object[]{this.power, this.wattsReceived, this.ic2Energy, this.disabled, this.getPowerProvider() != null ? (double)this.getPowerProvider().getEnergyStored() : 0.0});
    }

    @Override
    public ForgeDirection getElectricInputDirection() {
        return ForgeDirection.getOrientation((int)(this.p() + 2));
    }

    @Override
    public wm getBatteryInSlot() {
        return this.a(0);
    }
}

