/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.moon.wgen.dungeon;

import java.util.ArrayList;
import java.util.Random;
import micdoodle8.mods.galacticraft.moon.items.GCMoonItems;
import micdoodle8.mods.galacticraft.moon.wgen.dungeon.GCDungeonBoundingBox;
import micdoodle8.mods.galacticraft.moon.wgen.dungeon.GCDungeonRoom;
import micdoodle8.mods.galacticraft.moon.wgen.dungeon.GCMapGenDungeon;

public class GCRoomChests
extends GCDungeonRoom {
    int sizeX;
    int sizeY;
    int sizeZ;
    private final ArrayList chests = new ArrayList();

    public GCRoomChests(aab worldObj, int posX, int posY, int posZ, int entranceDir) {
        super(worldObj, posX, posY, posZ, entranceDir);
        if (worldObj != null) {
            Random rand = new Random(worldObj.G() * (long)posX * (long)posY * 57L * (long)posZ);
            this.sizeX = rand.nextInt(5) + 6;
            this.sizeY = rand.nextInt(2) + 4;
            this.sizeZ = rand.nextInt(5) + 6;
        }
    }

    @Override
    public void generate(short[] chunk, byte[] meta, int cx, int cz) {
        for (int i = this.posX - 1; i <= this.posX + this.sizeX; ++i) {
            for (int j = this.posY - 1; j <= this.posY + this.sizeY; ++j) {
                for (int k = this.posZ - 1; k <= this.posZ + this.sizeZ; ++k) {
                    if (i == this.posX - 1 || i == this.posX + this.sizeX || j == this.posY - 1 || j == this.posY + this.sizeY || k == this.posZ - 1 || k == this.posZ + this.sizeZ) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, GCMapGenDungeon.DUNGEON_WALL_ID, 14);
                        continue;
                    }
                    this.placeBlock(chunk, meta, i, j, k, cx, cz, 0, 0);
                }
            }
        }
        int hx = (this.posX + this.posX + this.sizeX) / 2;
        int hz = (this.posZ + this.posZ + this.sizeZ) / 2;
        if (this.placeBlock(chunk, meta, hx, this.posY, hz, cx, cz, apa.ay.cz, 0)) {
            this.chests.add(new t(hx, this.posY, hz));
        }
    }

    @Override
    public GCDungeonBoundingBox getBoundingBox() {
        return new GCDungeonBoundingBox(this.posX, this.posZ, this.posX + this.sizeX, this.posZ + this.sizeZ);
    }

    @Override
    protected GCDungeonRoom makeRoom(aab worldObj, int x, int y, int z, int dir) {
        return new GCRoomChests(worldObj, x, y, z, dir);
    }

    @Override
    protected void handleTileEntities(Random rand) {
        for (t chestCoords : this.chests) {
            apy chest = (apy)this.worldObj.r(chestCoords.a, chestCoords.b, chestCoords.c);
            if (chest == null) continue;
            int amountOfGoodies = rand.nextInt(5) + 2;
            for (int i = 0; i < amountOfGoodies; ++i) {
                chest.a(rand.nextInt(chest.j_()), this.getLoot(rand));
            }
        }
    }

    private wm getLoot(Random rand) {
        if (rand.nextInt(27) < 5) {
            int r = rand.nextInt(5);
            switch (r) {
                case 0: {
                    return new wm(wk.k, 1, 0);
                }
                case 1: {
                    return new wm(wk.p, rand.nextInt(8) + 2, 0);
                }
                case 2: {
                    return new wm(wk.m, rand.nextInt(14) + 2, 0);
                }
                case 3: {
                    return new wm(GCMoonItems.meteoricIronRaw, 1 + rand.nextInt(2), 0);
                }
                case 4: {
                    return new wm(wk.ay, rand.nextInt(2) + 1, 0);
                }
            }
        }
        return null;
    }
}

