/*
 * Decompiled with CFR 0.152.
 */
package andrew.powersuits.modules;

import andrew.powersuits.common.AddonComponent;
import andrew.powersuits.common.AddonConfig;
import andrew.powersuits.common.AddonUtils;
import andrew.powersuits.modules.PropertyModifierIntLinearAdditive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.machinemuse.api.IPropertyModifier;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MuseStringUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class OreScannerModule
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_ORE_SCANNER = "Ore Scanner";
    public static final String ORE_SCANNER_ENERGY_CONSUMPTION = "Energy Per Block";
    public static final String ORE_SCANNER_RADIUS_X = "X Radius";
    public static final String ORE_SCANNER_RADIUS_Y = "Y Radius";
    public static final String ORE_SCANNER_RADIUS_Z = "Z Radius";
    private static String[] oreNames = new String[]{"oreCopper", "oreTin", "oreSilver", "oreLead", "oreNickel", "orePlatinum", "oreZinc", "oreApatite", "oreUranium"};
    private static ArrayList ores = new ArrayList();
    private static HashMap oreMap = new HashMap();
    private static HashMap valueMap = new HashMap();

    public OreScannerModule(List validItems) {
        super(validItems);
        this.addBaseProperty(ORE_SCANNER_ENERGY_CONSUMPTION, 50.0);
        this.addBaseProperty(ORE_SCANNER_RADIUS_X, 1.0);
        this.addBaseProperty(ORE_SCANNER_RADIUS_Y, 1.0);
        this.addBaseProperty(ORE_SCANNER_RADIUS_Z, 1.0);
        this.addIntTradeoffProperty(ORE_SCANNER_RADIUS_X, ORE_SCANNER_RADIUS_X, 3.0, "m", 1, 0);
        this.addIntTradeoffProperty(ORE_SCANNER_RADIUS_Y, ORE_SCANNER_RADIUS_Y, 3.0, "m", 1, 0);
        this.addIntTradeoffProperty(ORE_SCANNER_RADIUS_Z, ORE_SCANNER_RADIUS_Z, 3.0, "m", 1, 0);
        this.addInstallCost(MuseItemUtils.copyAndResize((ItemStack)AddonComponent.computerChip, (int)1));
        this.addInstallCost(MuseItemUtils.copyAndResize((ItemStack)ItemComponent.controlCircuit, (int)2));
        for (int i = 0; i < oreNames.length; ++i) {
            ores.add(i, OreDictionary.getOres((String)oreNames[i]));
        }
        OreScannerModule.fillMap();
    }

    public PowerModuleBase addIntTradeoffProperty(String tradeoffName, String propertyName, double multiplier, String unit, int roundTo, int offset) {
        units.put(propertyName, unit);
        return this.addPropertyModifier(propertyName, (IPropertyModifier)new PropertyModifierIntLinearAdditive(tradeoffName, multiplier, roundTo, offset));
    }

    public void searchForValuables(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side) {
        int xRadius = (int)ModuleManager.computeModularProperty((ItemStack)itemStack, (String)ORE_SCANNER_RADIUS_X);
        int yRadius = (int)ModuleManager.computeModularProperty((ItemStack)itemStack, (String)ORE_SCANNER_RADIUS_Y);
        int zRadius = (int)ModuleManager.computeModularProperty((ItemStack)itemStack, (String)ORE_SCANNER_RADIUS_Z);
        int totalValue = 0;
        int totalEnergy = 0;
        int highestValue = 0;
        ForgeDirection fdSide = ForgeDirection.getOrientation((int)side).getOpposite();
        int cX = x + fdSide.offsetX * xRadius;
        int cY = y + fdSide.offsetY * yRadius;
        int cZ = z + fdSide.offsetZ * zRadius;
        for (int sX = cX - xRadius; sX <= cX + xRadius; ++sX) {
            for (int sY = cY - yRadius; sY <= cY + yRadius; ++sY) {
                for (int sZ = cZ - zRadius; sZ <= cZ + zRadius; ++sZ) {
                    int value = OreScannerModule.getValue(world.func_72798_a(sX, sY, sZ), world.func_72805_g(sX, sY, sZ));
                    totalValue += value;
                    ElectricItemUtils.drainPlayerEnergy((EntityPlayer)player, (double)ModuleManager.computeModularProperty((ItemStack)itemStack, (String)ORE_SCANNER_ENERGY_CONSUMPTION));
                    totalEnergy = (int)((double)totalEnergy + ModuleManager.computeModularProperty((ItemStack)itemStack, (String)ORE_SCANNER_ENERGY_CONSUMPTION));
                    if (value <= highestValue) continue;
                    highestValue = value;
                }
            }
        }
        if (ElectricItemUtils.getPlayerEnergy((EntityPlayer)player) > (double)totalEnergy) {
            ElectricItemUtils.drainPlayerEnergy((EntityPlayer)player, (double)totalEnergy);
            if (AddonUtils.isServerSide()) {
                if (AddonConfig.useAdvancedOreScannerMessage) {
                    player.func_70006_a("[Ore Scanner] Total ore value: " + totalValue + " --- Most valuable: " + highestValue + "\nSearch radius: " + (2 * (int)ModuleManager.computeModularProperty((ItemStack)itemStack, (String)ORE_SCANNER_RADIUS_X) + 1) + "x" + (2 * (int)ModuleManager.computeModularProperty((ItemStack)itemStack, (String)ORE_SCANNER_RADIUS_Y) + 1) + "x" + (2 * (int)ModuleManager.computeModularProperty((ItemStack)itemStack, (String)ORE_SCANNER_RADIUS_Z) + 1) + " --- Energy used: " + MuseStringUtils.formatNumberFromUnits((double)totalEnergy, (String)"J"));
                } else {
                    player.func_70006_a("[Ore Scanner] Total ore value: " + totalValue + " --- Most valuable: " + highestValue);
                }
            }
        }
    }

    public static int getValue(int blockID, int meta) {
        if (oreMap.containsKey(Arrays.asList(blockID, meta)) && valueMap.containsKey(oreMap.get(Arrays.asList(blockID, meta)))) {
            return (Integer)valueMap.get(oreMap.get(Arrays.asList(blockID, meta)));
        }
        return 0;
    }

    public static void fillMap() {
        for (int a = 0; a < ores.size(); ++a) {
            for (int b = 0; b < ((ArrayList)ores.get(a)).size(); ++b) {
                oreMap.put(Arrays.asList(((ItemStack)((ArrayList)OreScannerModule.ores.get((int)a)).get((int)b)).field_77993_c, ((ItemStack)((ArrayList)ores.get(a)).get(b)).func_77960_j()), oreNames[a]);
            }
        }
        oreMap.put(Arrays.asList(Block.field_71950_I.field_71990_ca, 0), "oreCoal");
        oreMap.put(Arrays.asList(Block.field_71949_H.field_71990_ca, 0), "oreIron");
        oreMap.put(Arrays.asList(Block.field_71941_G.field_71990_ca, 0), "oreGold");
        oreMap.put(Arrays.asList(Block.field_72047_aN.field_71990_ca, 0), "oreRedstone");
        oreMap.put(Arrays.asList(Block.field_72073_aw.field_71990_ca, 0), "oreDiamond");
        oreMap.put(Arrays.asList(Block.field_72068_bR.field_71990_ca, 0), "oreEmerald");
        oreMap.put(Arrays.asList(Block.field_71947_N.field_71990_ca, 0), "oreLapis");
        oreMap.put(Arrays.asList(Block.field_94342_cr.field_71990_ca, 0), "oreNetherQuartz");
        valueMap.put("oreCoal", 1);
        valueMap.put("oreIron", 4);
        valueMap.put("oreGold", 6);
        valueMap.put("oreRedstone", 3);
        valueMap.put("oreDiamond", 16);
        valueMap.put("oreEmerald", 18);
        valueMap.put("oreLapis", 12);
        valueMap.put("oreNetherQuartz", 8);
        valueMap.put("oreCopper", 4);
        valueMap.put("oreTin", 5);
        valueMap.put("oreSilver", 5);
        valueMap.put("oreLead", 6);
        valueMap.put("oreNickel", 14);
        valueMap.put("orePlatinum", 8);
        valueMap.put("oreZinc", 1);
        valueMap.put("oreApatite", 2);
        valueMap.put("oreUranium", 14);
        valueMap.put("oreXychorium", 2);
        valueMap.put("oreNaturalAluminum", 3);
        valueMap.put("oreCertusQuartz", 5);
    }

    public String getTextureFile() {
        return "orescanner";
    }

    public String getCategory() {
        return "Tool";
    }

    public String getName() {
        return MODULE_ORE_SCANNER;
    }

    public String getDescription() {
        return "A way to see how valuable the land around you is.";
    }

    public void onRightClick(EntityPlayer playerClicking, World world, ItemStack item) {
    }

    public void onItemUse(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        this.searchForValuables(itemStack, player, world, x, y, z, side);
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int par4) {
    }
}

