/*
 * Decompiled with CFR 0.152.
 */
package andrew.powersuits.modules;

import andrew.powersuits.common.AddonComponent;
import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class SolarGeneratorModule
extends PowerModuleBase
implements IPlayerTickModule {
    public static final String MODULE_SOLAR_GENERATOR = "Solar Generator";
    public static final String SOLAR_ENERGY_GENERATION_DAY = "Daytime Energy Generation";
    public static final String SOLAR_ENERGY_GENERATION_NIGHT = "Nighttime Energy Generation";

    public SolarGeneratorModule(List validItems) {
        super(validItems);
        this.addBaseProperty(SOLAR_ENERGY_GENERATION_DAY, 1500.0);
        this.addBaseProperty(SOLAR_ENERGY_GENERATION_NIGHT, 150.0);
        this.addInstallCost(MuseItemUtils.copyAndResize((ItemStack)AddonComponent.solarPanel, (int)1));
        this.addInstallCost(MuseItemUtils.copyAndResize((ItemStack)ItemComponent.controlCircuit, (int)2));
    }

    public String getTextureFile() {
        return "solarhelmet";
    }

    public String getCategory() {
        return "Energy";
    }

    public String getName() {
        return MODULE_SOLAR_GENERATOR;
    }

    public String getDescription() {
        return "Let the sun power your adventures.";
    }

    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        ItemStack helmet = player.func_82169_q(3);
        if (helmet != null && helmet.equals(item)) {
            boolean moonVisible;
            World world = player.field_70170_p;
            int xCoord = MathHelper.func_76128_c((double)player.field_70165_t);
            int zCoord = MathHelper.func_76128_c((double)player.field_70161_v);
            boolean canRain = true;
            if (world.func_82737_E() % 20L == 0L) {
                canRain = world.func_72959_q().func_76935_a(xCoord, zCoord).func_76744_g() > 0;
            }
            boolean isRaining = canRain && (world.func_72896_J() || world.func_72911_I());
            boolean sunVisible = world.func_72935_r() && !isRaining && world.func_72937_j(xCoord, MathHelper.func_76128_c((double)player.field_70163_u) + 1, zCoord);
            boolean bl = moonVisible = !world.func_72935_r() && !isRaining && world.func_72937_j(xCoord, MathHelper.func_76128_c((double)player.field_70163_u) + 1, zCoord);
            if (!world.field_72995_K && !world.field_73011_w.field_76576_e && world.func_82737_E() % 80L == 0L) {
                if (sunVisible) {
                    ElectricItemUtils.givePlayerEnergy((EntityPlayer)player, (double)ModuleManager.computeModularProperty((ItemStack)item, (String)SOLAR_ENERGY_GENERATION_DAY));
                } else if (moonVisible) {
                    ElectricItemUtils.givePlayerEnergy((EntityPlayer)player, (double)ModuleManager.computeModularProperty((ItemStack)item, (String)SOLAR_ENERGY_GENERATION_NIGHT));
                }
            }
        }
    }

    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }
}

