/*
 * Decompiled with CFR 0.152.
 */
package andrew.powersuits.tick;

import andrew.powersuits.common.AddonConfig;
import andrew.powersuits.common.AddonLogger;
import andrew.powersuits.common.AddonUtils;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.machinemuse.powersuits.item.ItemPowerArmorChestplate;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ClientTickHandler
implements ITickHandler {
    private static ClientTickHandler instance;
    private ArrayList SMPmagneticItems = new ArrayList();

    public void tickStart(EnumSet type, Object ... tickData) {
        EntityClientPlayerMP player;
        ItemStack torso;
        Minecraft mc = Minecraft.func_71410_x();
        if (type.contains(TickType.CLIENT) && mc.field_71441_e != null && (torso = (player = mc.field_71439_g).func_82169_q(2)) != null && torso.func_77973_b() instanceof ItemPowerArmorChestplate && MuseItemUtils.itemHasActiveModule((ItemStack)torso, (String)"Magnet")) {
            if (AddonConfig.useDebugMode) {
                AddonLogger.logDebug("Entering client tick handler for magnet.");
            }
            this.updateMagnetMode((World)mc.field_71441_e, (EntityPlayerSP)player);
        }
    }

    public void addSMPMagneticItem(int i, World world) {
        Entity entity = world.func_73045_a(i);
        if (entity == null || !(entity instanceof EntityItem)) {
            return;
        }
        this.SMPmagneticItems.add((EntityItem)entity);
        if (AddonConfig.useDebugMode) {
            AddonLogger.logDebug("Recieved magnet mode packet.");
        }
    }

    private void updateMagnetMode(World world, EntityPlayerSP player) {
        float distancexz = 16.0f;
        float distancey = 8.0f;
        double maxspeedxz = 0.5;
        double maxspeedy = 0.5;
        double speedxz = 0.05;
        double speedy = 0.07;
        List items = world.field_72995_K ? this.SMPmagneticItems : world.func_72872_a(EntityItem.class, player.field_70121_D.func_72314_b((double)distancexz, (double)distancey, (double)distancexz));
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            double rationspeedy;
            EntityItem item = (EntityItem)iterator.next();
            if (item.field_70293_c > 0) continue;
            if (item.field_70128_L && world.field_72995_K) {
                iterator.remove();
            }
            if (!AddonUtils.canItemFitInInventory((EntityPlayer)player, item.func_92059_d())) continue;
            double dx = player.field_70165_t - item.field_70165_t;
            double dy = player.field_70163_u + (double)player.func_70047_e() - item.field_70163_u;
            double dz = player.field_70161_v - item.field_70161_v;
            double absxz = Math.sqrt(dx * dx + dz * dz);
            double absy = Math.abs(dy);
            if (absxz > (double)distancexz) continue;
            if (absxz > 1.0) {
                dx /= absxz;
                dz /= absxz;
            }
            if (absy > 1.0) {
                dy /= absy;
            }
            double vx = item.field_70159_w + speedxz * dx;
            double vy = item.field_70181_x + speedy * dy;
            double vz = item.field_70179_y + speedxz * dz;
            double absvxz = Math.sqrt(vx * vx + vz * vz);
            double absvy = Math.abs(vy);
            double rationspeedxz = absvxz / maxspeedxz;
            if (rationspeedxz > 1.0) {
                vx /= rationspeedxz;
                vz /= rationspeedxz;
            }
            if ((rationspeedy = absvy / maxspeedy) > 1.0) {
                vy /= rationspeedy;
            }
            if (absvxz < 0.2 && absxz < 0.2 && world.field_72995_K) {
                item.func_70106_y();
            }
            if (AddonConfig.useDebugMode) {
                AddonLogger.logDebug("Set velocity " + vx + " " + vy + " " + vz + ".");
            }
            item.func_70016_h(vx, vy, vz);
        }
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
    }

    public static void load() {
        instance = new ClientTickHandler();
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.CLIENT);
    }

    public String getLabel() {
        return "MPSA: Client Tick";
    }

    public static ClientTickHandler instance() {
        return instance;
    }
}

