/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.tile;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;
import org.bouncycastle.util.Arrays;
import universalelectricity.core.block.IConductor;
import universalelectricity.core.block.IConnector;
import universalelectricity.core.block.INetworkProvider;
import universalelectricity.core.electricity.ElectricityNetwork;
import universalelectricity.core.electricity.IElectricityNetwork;
import universalelectricity.core.vector.Vector3;
import universalelectricity.core.vector.VectorHelper;
import universalelectricity.prefab.network.IPacketReceiver;
import universalelectricity.prefab.network.PacketManager;
import universalelectricity.prefab.tile.TileEntityAdvanced;

public abstract class TileEntityConductor
extends TileEntityAdvanced
implements IConductor,
IPacketReceiver {
    private IElectricityNetwork network;
    public boolean[] visuallyConnected = new boolean[]{false, false, false, false, false, false};
    public TileEntity[] connectedBlocks = new TileEntity[]{null, null, null, null, null, null};
    protected String channel = "";

    public void updateConnection(TileEntity tileEntity, ForgeDirection side) {
        if (!this.field_70331_k.field_72995_K) {
            if (tileEntity instanceof IConnector && ((IConnector)tileEntity).canConnect(side.getOpposite())) {
                this.connectedBlocks[side.ordinal()] = tileEntity;
                this.visuallyConnected[side.ordinal()] = true;
                if (tileEntity.getClass() == this.getClass() && tileEntity instanceof INetworkProvider) {
                    this.getNetwork().mergeConnection(((INetworkProvider)tileEntity).getNetwork());
                }
                return;
            }
            if (this.connectedBlocks[side.ordinal()] != null) {
                this.getNetwork().stopProducing(this.connectedBlocks[side.ordinal()]);
                this.getNetwork().stopRequesting(this.connectedBlocks[side.ordinal()]);
            }
            this.connectedBlocks[side.ordinal()] = null;
            this.visuallyConnected[side.ordinal()] = false;
        }
    }

    @Override
    public void handlePacketData(INetworkManager network, int type, Packet250CustomPayload packet, EntityPlayer player, ByteArrayDataInput dataStream) {
        if (this.field_70331_k.field_72995_K) {
            this.visuallyConnected[0] = dataStream.readBoolean();
            this.visuallyConnected[1] = dataStream.readBoolean();
            this.visuallyConnected[2] = dataStream.readBoolean();
            this.visuallyConnected[3] = dataStream.readBoolean();
            this.visuallyConnected[4] = dataStream.readBoolean();
            this.visuallyConnected[5] = dataStream.readBoolean();
        }
    }

    @Override
    public void initiate() {
        this.updateAdjacentConnections();
    }

    public void func_70313_j() {
        if (!this.field_70331_k.field_72995_K) {
            this.getNetwork().splitNetwork(this);
        }
        super.func_70313_j();
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K && this.ticks % 300L == 0L) {
            this.updateAdjacentConnections();
        }
    }

    @Override
    public void updateAdjacentConnections() {
        if (this.field_70331_k != null && !this.field_70331_k.field_72995_K) {
            boolean[] previousConnections = (boolean[])this.visuallyConnected.clone();
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                this.updateConnection(VectorHelper.getConnectorFromSide(this.field_70331_k, new Vector3(this), ForgeDirection.getOrientation((int)i)), ForgeDirection.getOrientation((int)i));
            }
            if (!Arrays.areEqual((boolean[])previousConnections, (boolean[])this.visuallyConnected)) {
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        }
    }

    public Packet func_70319_e() {
        return PacketManager.getPacket(this.channel, this, new Object[]{this.visuallyConnected[0], this.visuallyConnected[1], this.visuallyConnected[2], this.visuallyConnected[3], this.visuallyConnected[4], this.visuallyConnected[5]});
    }

    @Override
    public IElectricityNetwork getNetwork() {
        if (this.network == null) {
            this.setNetwork(new ElectricityNetwork(this));
        }
        return this.network;
    }

    @Override
    public void setNetwork(IElectricityNetwork network) {
        this.network = network;
    }

    @Override
    public TileEntity[] getAdjacentConnections() {
        return this.connectedBlocks;
    }

    @Override
    public boolean canConnect(ForgeDirection direction) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 1), (double)(this.field_70327_n + 1));
    }
}

