/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.inventory;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.inventory.IInventoryManager;
import powercrystals.core.inventory.InventoryManager;

public class InventoryManagerStandard
implements IInventoryManager {
    private IInventory _inv;
    protected ForgeDirection _targetSide;

    public InventoryManagerStandard(IInventory inventory, ForgeDirection targetSide) {
        this._inv = inventory;
        this._targetSide = targetSide;
    }

    protected boolean canAddItem(ItemStack stack, int slot) {
        return this._inv.func_94041_b(slot, stack);
    }

    protected boolean canRemoveItem(ItemStack stack, int slot) {
        return true;
    }

    @Override
    public ItemStack addItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        int quantitytoadd = stack.field_77994_a;
        ItemStack remaining = stack.func_77946_l();
        for (int i : this.getSlots()) {
            ItemStack add;
            int maxStackSize = Math.min(this._inv.func_70297_j_(), stack.func_77976_d());
            ItemStack s = this.getSlotContents(i);
            if (s == null) {
                add = stack.func_77946_l();
                add.field_77994_a = Math.min(quantitytoadd, maxStackSize);
                if (this.canAddItem(add, i)) {
                    quantitytoadd -= add.field_77994_a;
                    this._inv.func_70299_a(i, add);
                }
            } else if (InventoryManager.stacksEqual(s, stack)) {
                add = stack.func_77946_l();
                add.field_77994_a = Math.min(quantitytoadd, maxStackSize - s.field_77994_a);
                if (add.field_77994_a > 0 && this.canAddItem(add, i)) {
                    s.field_77994_a += add.field_77994_a;
                    quantitytoadd -= add.field_77994_a;
                    this._inv.func_70299_a(i, s);
                }
            }
            if (quantitytoadd == 0) break;
        }
        remaining.field_77994_a = quantitytoadd;
        if (remaining.field_77994_a == 0) {
            return null;
        }
        return remaining;
    }

    @Override
    public ItemStack removeItem(int maxRemove) {
        if (maxRemove <= 0) {
            return null;
        }
        for (int i : this.getSlots()) {
            ItemStack s = this.getSlotContents(i);
            if (s == null || !this.canRemoveItem(s, i)) continue;
            int toRemove = Math.min(s.field_77994_a, maxRemove);
            s.field_77994_a -= toRemove;
            ItemStack removed = s.func_77946_l();
            removed.field_77994_a = toRemove;
            if (s.field_77994_a > 0) {
                this._inv.func_70299_a(i, s);
            } else {
                this._inv.func_70299_a(i, null);
            }
            return removed;
        }
        return null;
    }

    @Override
    public ItemStack removeItem(int maxRemove, ItemStack type) {
        if (maxRemove <= 0) {
            return null;
        }
        for (int i : this.getSlots()) {
            ItemStack s = this.getSlotContents(i);
            if (!InventoryManager.stacksEqual(s, type) || !this.canRemoveItem(s, i)) continue;
            int toRemove = Math.min(s.field_77994_a, maxRemove);
            s.field_77994_a -= toRemove;
            ItemStack removed = s.func_77946_l();
            removed.field_77994_a = toRemove;
            if (s.field_77994_a > 0) {
                this._inv.func_70299_a(i, s);
            } else {
                this._inv.func_70299_a(i, null);
            }
            return removed;
        }
        return null;
    }

    @Override
    public ItemStack getSlotContents(int slot) {
        return this._inv.func_70301_a(slot);
    }

    @Override
    public int hasItem(ItemStack type) {
        int quantity = 0;
        for (ItemStack s : this.getContents().values()) {
            if (!InventoryManager.stacksEqual(s, type)) continue;
            quantity += s.field_77994_a;
        }
        return quantity;
    }

    @Override
    public int findItem(ItemStack type) {
        for (int i : this.getSlots()) {
            ItemStack s = this._inv.func_70301_a(i);
            if (!InventoryManager.stacksEqual(s, type)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int[] getSlots() {
        int[] slots = new int[this._inv.func_70302_i_()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    @Override
    public Map getContents() {
        HashMap<Integer, ItemStack> contents = new HashMap<Integer, ItemStack>();
        for (int i : this.getSlots()) {
            contents.put(i, this._inv.func_70301_a(i));
        }
        return contents;
    }
}

